<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Component;

use Webedia\UiBundle\Contracts\Component\ButtonConfigInterface;

/**
 * Implementation of ButtonConfigInterface.
 */
class ButtonConfig implements ButtonConfigInterface
{
    public function __construct(
        private string $text,
        private ?string $href = null,
        private ?string $type = null,
        private ?string $size = null,
        private ?string $icon = null,
        private array $classes = [],
        private ?string $markup = null,
        private ?string $background = null,
        private ?string $color = null,
        private array $data = []
    ) {}

    public function getText(): string
    {
        return $this->text;
    }

    public function getHref(): ?string
    {
        return $this->href;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function getSize(): ?string
    {
        return $this->size;
    }

    public function getIcon(): ?string
    {
        return $this->icon;
    }

    public function getClasses(): array
    {
        return $this->classes;
    }

    public function getMarkup(): ?string
    {
        return $this->markup;
    }

    public function getBackground(): ?string
    {
        return $this->background;
    }

    public function getColor(): ?string
    {
        return $this->color;
    }

    public function getData(): array
    {
        return $this->data;
    }

    public function validate(): bool
    {
        return !empty($this->text);
    }
}