<?php

declare(strict_types=1);

namespace Symfony\Component\DependencyInjection\Loader\Configurator;

use Webedia\UiBundle\Service\MenuBuilder;
use Webedia\UiBundle\Twig\UiExtension;

return function (ContainerConfigurator $configurator) {
    $services = $configurator->services();

    $services
        ->set(MenuBuilder::class)
        ->autowire()
        ->autoconfigure()
        ->tag("knp_menu.menu_builder", [
            "method" => "createMainMenu",
            "alias" => "main",
        ])
        ->tag("knp_menu.menu_builder", [
            "method" => "createLinkBar",
            "alias" => "link_bar",
        ]);

    $services->set(UiExtension::class)->autowire()->autoconfigure();
};
