import { addClass, removeClass } from "@Ui/js/dom/classes";
import { on } from "@Ui/js/dom/events";
import { setCookie, getCookie } from "@Ui/js/tools/cookie";

const CONTAINER_COOKIE_BANNER = document.getElementById("js-cookie-banner-container");
const BTN_CLOSE_COOKIE_BANNER = document.getElementById("js-cookie-banner-submit");
const COOKIE_BANNER_KEY = 'cookie_banner'

export default function consentPolicyCookie() {

    if (!CONTAINER_COOKIE_BANNER || !BTN_CLOSE_COOKIE_BANNER) {
      return false;
    }

    const SHOW_BANNER = !getCookie(COOKIE_BANNER_KEY);

    if (SHOW_BANNER) {
      addClass(CONTAINER_COOKIE_BANNER, "active");
    }

    on(BTN_CLOSE_COOKIE_BANNER, "click", () => {
      removeClass(CONTAINER_COOKIE_BANNER, "active");
      setCookie(COOKIE_BANNER_KEY, 'true', 396);
    });
}
