# ui-bundle

UiBundle is a front library for Symfony.

## Getting started

To use this bundle, you need to add some instructions in your composer.json:
```
{
    ...
    "require": {
        "webedia/ui-bundle": "^1.0"
    },
    ...
    "repositories": [
        {
            "type": "composer",
            "url": "https://gitlab.com/api/v4/group/56281921/-/packages/composer/"
        }
    ],
    ...
}
```

Then, you need to create two aliases for this bundle in your webpack.config.js:
```
.addAliases({
    '@Ui': path.resolve(__dirname, './vendor/webedia/ui-bundle/assets'),
})
```

Now you can download the bundle from git to your project:
```
composer require webedia/ui-bundle
```

## Integration
To use a component or a module from the bundle in twig:
```
{% include "@Ui/module/ads/rectangle.html.twig" with {
    position: "atf",
    is_sticky: true,
    ad_id: "rectangle_atf"
} only %}
```

To use the associated css, you need to import the source in your scss:
```
@import '@Ui/scss/module/ads';
```

To use the associated js, you need to import the source in your js app:
```
import '@Ui/js/module/roller';
roller();
```

## PHP Interface Contractss (Optional)

This bundle provides optional PHP interfaces for type-safe template data. These contracts ensure that your controllers pass correctly structured data to Twig templates while maintaining full backward compatibility.

### Basic Usage

```php
use Webedia\UiBundle\Contracts\Implementation\LinkBarItem;

// New typed approach
$linkBarItems = [
    new LinkBarItem(
        routeName: 'category_show',
        routeParams: ['id' => 1, 'slug' => 'my-category'],
        label: 'My Category',
        tracking: 'analytics_code'
    ),
];

return $this->render('template.html.twig', [
    'link_bar' => $linkBarItems,
]);
```

### Backward Compatibility

Existing array-based code continues to work unchanged:

```php
// This still works perfectly
$linkBarItems = [
    'item-key' => [
        'route_name' => 'category_show',
        'route_params' => ['id' => 1, 'slug' => 'my-category'],
        'label' => 'My Category',
        'tracking' => 'analytics_code',
    ],
];
```

### Available Contractss

- `LinkBarItemInterface`: For navigation link bar items
- `ButtonConfigInterface`: For button component configuration

### Benefits

- **Type Safety**: IDE autocompletion and validation
- **Documentation**: Interfaces serve as living documentation
- **Validation**: Built-in validation of required fields
- **Zero Breaking Changes**: Existing code continues to work
