import loadScript from "load-script";

import { getConsentForGoogle } from "./../consent/didomi";
import { getConsentState } from "./../consent/tcfApi";
import { deferToLoad } from "./../dom/events";

const OUTBRAIN_URL = "//widgets.outbrain.com/outbrain.js";
const OUTBRAIN_URL_COOKIELESS = `${OUTBRAIN_URL}?i=${window?._GLOBALS?.outbrain?.cookieless_id}`;
let loaded = false;

export async function loadOutbrain() {
  if (loaded) {
    return;
  }

  loaded = true;

  const outbrainAnchor = document.querySelector(".OUTBRAIN");
  if (!outbrainAnchor) {
    return;
  }

  if (OUTBRAIN_URL_COOKIELESS) {

    await Promise.all([getConsentState(), deferToLoad()]);

    // In that case CMP was validated but with a paiement and user disagree to all cookies
    const googleConsent = await getConsentForGoogle();

    if (!googleConsent) {
        loadScript(OUTBRAIN_URL_COOKIELESS);
        return;
    }
  }

  loadScript(OUTBRAIN_URL);
}