import { on } from "../../dom/events";

const shareSet = new Set();

//FUNCTION
export default function shareOnMobile() {
  const SHARE_BTN = document.querySelectorAll(".js-share");

  //Event (open mobile panel)
  SHARE_BTN.forEach((item) => {
    if (shareSet.has(item)) {
      return false;
    }

    shareSet.add(item);

    on(item, "click", async () => {
      const SHARE_DATA = {
        title: item.dataset.title || window.document.title,
        url: item.dataset.href || window.document.location.href,
      };

      if (item.dataset.text) {
        SHARE_DATA.text = item.dataset.text;
      }

      try {
        await navigator.share(SHARE_DATA);
      } catch (error) {
        console.debug(error);
      }
    });
  });
}
