<?php

<?php

namespace Webedia\UiBundle;

use Symfony\Component\Config\Definition\Configurator\DefinitionConfigurator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\Configurator\ContainerConfigurator;
use Webedia\UiBundle\Service\MenuBuilder;
use Webedia\UiBundle\Twig\UiExtension;

if (class_exists('Symfony\Component\HttpKernel\Bundle\AbstractBundle')) {
    abstract class BaseBundle extends Symfony\Component\HttpKernel\Bundle\AbstractBundle {}
} else {
    abstract class BaseBundle extends Symfony\Component\HttpKernel\Bundle\Bundle {}
}

class UiBundle extends BaseBundle
{
    protected string $extensionAlias = 'webedia_ui';

    public function configure(DefinitionConfigurator $definition): void
    {
        // loads config definition from a file
        $definition->import('../config/definition.php');
    }

    public function loadExtension(array $config, ContainerConfigurator $container, ContainerBuilder $builder): void
    {
        $container->import('../config/services.php');

        $menuBuilderDef = $builder->getDefinition(MenuBuilder::class);
        $menuBuilderDef->setArgument('$menusConfig', $config['menus']);

        // check is SeoBundle is registered in list of registered bundles
        if (array_key_exists('WebediaSeoBundle', $builder->getParameter('kernel.bundles'))) {
            $uiExtensionDef = $builder->getDefinition(UiExtension::class);
            $uiExtensionDef->setArgument('$seoBundleEnabled', true);
        }
    }
}
