<?php

namespace Webedia\UiBundle;

use Symfony\Component\Config\Definition\Configurator\DefinitionConfigurator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\Configurator\ContainerConfigurator;
use Symfony\Component\HttpKernel\Bundle\AbstractBundle;
use Webedia\UiBundle\Service\MenuBuilder;
use Webedia\UiBundle\Twig\UiExtension;

class UiBundle extends AbstractBundle
{
    protected string $extensionAlias = 'webedia_ui';

    public function configure(DefinitionConfigurator $definition): void
    {
        // loads config definition from a file
        $definition->import('../config/definition.php');
    }

    public function loadExtension(array $config, ContainerConfigurator $container, ContainerBuilder $builder): void
    {
        $container->import('../config/services.php');

        $menuBuilderDef = $builder->getDefinition(MenuBuilder::class);
        $menuBuilderDef->setArgument('$menusConfig', $config['menus']);

        $kernelBundles = $builder->getParameter('kernel.bundles');

        $seoEnabled = array_key_exists('WebediaSeoBundle', $kernelBundles);
        $nativePlacementsEnabled = array_key_exists('WebediaNativePlacementsBundle', $kernelBundles);

        $uiExtensionDef = $builder->getDefinition(UiExtension::class);
        $uiExtensionDef->setArgument('$seoBundleEnabled', $seoEnabled);
        $uiExtensionDef->setArgument('$nativePlacementsEnabled', $nativePlacementsEnabled);
    }
}
