import { removeClass, addClass } from "../../dom/classes";
import { on } from "../../dom/events";
import { BODY, CLASS_BODY_OVERLAY_OPEN } from "../../constant/dom";
import eventEmitter, { EventsTypes } from "../../services/events/eventEmitter";

export const OVERLAY_ELEMENT = document.getElementById("overlay-layer");

let overlayOpen;

export function showOverlay() {
  addClass(BODY, CLASS_BODY_OVERLAY_OPEN);
  overlayOpen = true;
}

export function hideOverlay() {
  removeClass(BODY, CLASS_BODY_OVERLAY_OPEN);
  overlayOpen = false;
}

export function getOverlayState() {
  return { open: overlayOpen };
}

// add event to always hide overlay when clicking on it.
on(OVERLAY_ELEMENT, "click", () => {
  eventEmitter.emit(EventsTypes.OVERLAY_CLICK);
});

eventEmitter.on(EventsTypes.OVERLAY_CLICK, () => {
  hideOverlay();
});
