import eventEmitter, { EventsTypes } from "../services/events/eventEmitter";
import { on } from "../dom/events";
import debounce from "../tools/debounce";

const mqIndicator = document.getElementById("mq-state");
const MQ_UNKNOWN = 0;

let currentState = MQ_UNKNOWN;

export const getState = () => window.Number.isInteger(currentState) ? currentState : 0;

export const computeState = () => {
  if (!mqIndicator) {
    return MQ_UNKNOWN;
  }

  const index = parseInt(
    window.getComputedStyle(mqIndicator).getPropertyValue("z-index"),
    10
  );
  return index || MQ_UNKNOWN;
};

const initMqState = () => {
  currentState = computeState(); // on start, store the current state

  on(
    window,
    "resize",
    debounce(function resizeCallback() {
      const newState = computeState();
      if (currentState !== newState) {
        currentState = newState; // store the current state
        eventEmitter.emit(EventsTypes.MQ_STATE, currentState);
      }
    })
  );

  // media queries state detection
  window.MqState = {
    getState: getState,
  };
};

export default initMqState;
