import { on } from "../dom/events";
import scrollTo from "../dom/scrollTo";
import { runAfterDeobfuscation } from "../services/seo/deobfuscation";

function anchorScroll(href) {
    let elem = null;
    let anchor = href || document.location.hash;

    if (!anchor || anchor.trim() === '') {
        return false;
    }

    anchor = anchor.split('#')[1];
    elem = document.getElementById(anchor);

    if (!elem) {
        return false;
    }

    scrollTo(elem, 800, true);
}

function init() {
    const links = document.querySelectorAll('.js-anchor-link');

    links.forEach(link => {
        on(link, 'click', function scrollWindow(e) {
            if (e.target.pathname === document.location.pathname) {
                e.preventDefault();
                anchorScroll(this.href);
            }
        });
    });
}

export default function initAnchors() {
    runAfterDeobfuscation(init);
}
