# Routing Bundle

This version of the Routing Bundle is compatible with **Symfony 7.0 and later**.  
If you are using an older version of Symfony, please use the v1 version of this bundle.

## Installation

Require via composer :

```shell
composer require webedia/routing-bundle
```

Now, add the new RoutingBundle Bundle to bundles.php file:

```php
// config/bundles.php

return [
    // ...
    Webedia\RoutingBundle\WebediaRoutingBundle::class => ['all' => true],
];
```

## Bundle Configuration

To use the RoutingBundle, no extra configuration is needed.

## Usage

Add routes with yaml files in the `/config/routes` directory.
For example : 

```yaml
# config/routes/company.yaml

company_press_movies_reviews:
  path: /presse-{idPress}/critiques/cinema/[land-{country}/][foo-{foo}/]
  defaults:
    _controller: App\Controller\HomeController::test
    order: REVERSE_CREATED_AT
    type: 'MOVIE'
    _check_url_requirements:
      country: "[0-9]{1,10}"
      foo: "[0-9]+"
      idPress: "[0-9]+"
  requirements:
    country: "[0-9]{1,10}"
    foo: "[0-9]+"
    idPress: "[0-9]+"
```
Check that the route match with symfony console : 

```shell
$ bin/console router:match /presse-123/critiques/cinema/land-1234/
```
## Documentation

- [Introduction](docs/introduction.md)
- [Convertisseurs](docs/convertisseurs.md)
