<?php

$finder = PhpCsFixer\Finder::create()
    ->in(__DIR__)
    ->exclude(['var'])
;

$config = new PhpCsFixer\Config();
return $config->setRules([
        '@Symfony' => true,
        '@Symfony:risky' => true,
        'array_syntax' => ['syntax' => 'short'],
        'compact_nullable_typehint' => true,
        'logical_operators' => true,
        'ordered_imports' => true,
        'no_superfluous_phpdoc_tags' => true,
        'method_argument_space' => ['on_multiline' => 'ensure_single_line'],
    ])
    ->setRiskyAllowed(true)
    ->setFinder($finder)
;
