<?php

namespace Webedia\RoutingBundle\Tests;

use PHPUnit\Framework\Assert;
use PHPUnit\Framework\Constraint\IsEqual;
use Symfony\Component\Yaml\Yaml;
use Webedia\RoutingBundle\RouteConverterInterface;

trait RouteConverterTrait
{
    protected function assertRouteConverts(RouteConverterInterface $converter, string $expected, string $actual): void
    {
        Assert::assertThat($converter->convertRoutes(Yaml::parse(file_get_contents($actual))), new IsEqual(Yaml::parse(file_get_contents($expected))));
    }
}
