<?php

namespace Webedia\RoutingBundle\Router;

use Symfony\Component\Routing\Exception\ResourceNotFoundException;
use Symfony\Component\Routing\Exception\RouteNotFoundException;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

abstract class AbstractRouterDecoratorV5 extends AbstractRouterDecorator
{
    public function generate(string $name, array $parameters = [], int $referenceType = UrlGeneratorInterface::ABSOLUTE_PATH): string
    {
        try {
            return $this->doGenerate($name, $parameters, $referenceType);
        } catch (RouteNotFoundException $e) {
            throw new ResourceNotFoundException(sprintf('Unable to generate a URL for the named route "%s" as such route does not exist', $name), 0, $e);
        }
    }

    public function match(string $pathinfo): array
    {
        return $this->router->match($pathinfo);
    }

    public function warmUp(string $cacheDir): array
    {
        return $this->router->warmUp($cacheDir);
    }
}
