<?php

namespace Webedia\RoutingBundle\Router;

use Symfony\Component\Config\Loader\LoaderInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Symfony\Component\Routing\RequestContext;
use Symfony\Component\Routing\RouteCollection;
use Symfony\Component\Routing\RouterInterface;
use Webedia\RoutingBundle\Exception\RetryWithNoPrefixException;
use Webedia\RoutingBundle\UrlGenerator;

class AbstractRouterDecorator
{
    /**
     * @var RouterInterface
     */
    protected $router;

    public static function getSubscribedServices(): array
    {
        return [
            'routing.loader' => LoaderInterface::class,
        ];
    }

    public function __construct(RouterInterface $router)
    {
        $this->router = $router;
    }

    public function setUrlGenerator(): self
    {
        $this->router->setOption('generator_class', UrlGenerator::class);

        return $this;
    }

    public function setContext(RequestContext $context): void
    {
        $this->router->setContext($context);
    }

    public function getContext(): RequestContext
    {
        return $this->router->getContext();
    }

    /**
     * @return mixed|RouteCollection|null
     */
    public function getRouteCollection()
    {
        return $this->router->getRouteCollection();
    }

    public function matchRequest(Request $request): array
    {
        return $this->router->matchRequest($request);
    }

    protected function doGenerate(string $name, array $parameters = [], int $referenceType = UrlGeneratorInterface::ABSOLUTE_PATH): string
    {
        try {
            return $this->router->generate($name, $parameters, $referenceType);
        } catch (RetryWithNoPrefixException $ex) {
            return $this->router->generate($name.'_no_prefix', $parameters, $referenceType);
        }
    }
}
