<?php

namespace Webedia\RoutingBundle;

use Symfony\Component\Yaml\Yaml;

class ChainRouteConverter
{
    /**
     * @var RouteConverterInterface[]
     */
    private $converters;

    /**
     * @param RouteConverterInterface[] $converters
     */
    public function __construct(array $converters)
    {
        $this->converters = $converters;
    }

    public function convert(string $content): string
    {
        if (empty(trim($content))) {
            return $content;
        }

        $routes = Yaml::parse($content, Yaml::PARSE_CONSTANT);

        foreach ($this->converters as $converter) {
            if (!empty($routes)) {
                $routes = $converter->convertRoutes($routes);
            }
        }

        return Yaml::dump($routes);
    }
}
