<?php

declare(strict_types=1);

namespace Webedia\RoutingBundle;

class BracketRouteConverter implements RouteConverterInterface
{
    public function convertRoutes(array $routes): array
    {
        if (empty($routes)) {
            return [];
        }

        $newRoutes = [];
        foreach ($routes as $routeName => $route) {
            $newRoutes[$routeName] = $this->convertRoute($route);
        }

        return $newRoutes;
    }

    protected function convertRoute(array $route): array
    {
        if (empty($route['path'])) {
            return $route;
        }

        $newRoute = $route;

        $this->convertPath($newRoute['path']);

        return $newRoute;
    }

    protected function convertPath(string &$path): void
    {
        preg_match_all('#(\[.+\])([^[]|$)#mU', $path, $matches, \PREG_SET_ORDER);
        foreach ($matches as $index => $match) {
            $path = str_replace($match[1], $this->convertFilterGroupPath($match[1], $index), $path);
        }
    }

    protected function convertFilterGroupPath(string $filterGroup, int $index): string
    {
        preg_match_all('#\[(.+?)/\]#', $filterGroup, $matches, \PREG_SET_ORDER);

        $filters = [];
        foreach ($matches as $match) {
            $parts = explode('-', $match[1]);
            if (1 === \count($parts)) {
                $varName = substr($parts[0], 1, -1);
                $filters[] = sprintf('%s: ~', $varName);
                continue;
            }

            $filters[] = sprintf('%s: %s', substr($parts[1], 1, -1), $parts[0]);
        }

        return preg_replace('#(\[.+?\])+#', sprintf('[filters_%d://%s]', $index, implode(', ', $filters)), $filterGroup) ?: '';
    }
}
