#!/usr/bin/env bash

echo "Formatting PHP codes";

IFS='
';
COMMIT_RANGE=${COMMIT_RANGE:-HEAD};
CHANGED_FILES=$(git diff --cached --name-only --diff-filter=ACMRTUXB "${COMMIT_RANGE}");

if [[ $? == 0 ]]; then
    if ! echo "${CHANGED_FILES}" | grep -qE "^(.php_cs(.dist)?|composer.lock|docker-compose.+|Makefile)$"; then
        PHP_CS_FIXER_EXTRA_ARGS=$(printf -- '--path-mode=intersection\n--\n%s' "${CHANGED_FILES}");
    fi;
fi;

if [[ -z "${PHP_CS_FIXER_EXTRA_ARGS}" ]]; then
    echo "Nothing to lint"
    exit 0
fi

if [[ -n "${DRY_RUN}" ]]; then
	php-cs-fixer fix --config=.php-cs-fixer.dist.php --verbose --dry-run --using-cache=no --diff --diff-format=udiff ${PHP_CS_FIXER_EXTRA_ARGS};
	exit $?
fi;

php-cs-fixer fix --config=.php-cs-fixer.dist.php --verbose ${PHP_CS_FIXER_EXTRA_ARGS};
