<?php

namespace Webedia\RoutingBundle\UrlGenerator;

use Webedia\RoutingBundle\Exception\RetryWithNoPrefixException;

abstract class AbstractUrlGeneratorV5 extends AbstractUrlGenerator
{
    public function generate(string $name, array $parameters = [], int $referenceType = self::ABSOLUTE_PATH): string
    {
        try {
            return parent::generate($name, $parameters, $referenceType);
        } catch (RetryWithNoPrefixException $ex) {
            return parent::generate($name.'_no_prefix', $parameters, $referenceType);
        }
    }

    /**
     * @throws RetryWithNoPrefixException
     */
    protected function doGenerate(array $variables, array $defaults, array $requirements, array $tokens, array $parameters, string $name, int $referenceType, array $hostTokens, array $requiredSchemes = []): string
    {
        if (!empty($filterTokenNames = $this->extractFilterToken($tokens))) {
            $this->buildFiltersParameters($filterTokenNames, $defaults, $parameters);
        }

        foreach ($parameters as $parameterName => $parameter) {
            if ('c' === $parameterName[0] && ctype_upper($parameterName[1])) {
                $parameters[strtolower(substr($parameterName, 1))] = $parameter;
            }
        }

        return parent::doGenerate($variables, $defaults, $requirements, $tokens, $parameters, $name, $referenceType, $hostTokens, $requiredSchemes);
    }
}
