Convertisseurs
==============

Les convertisseurs sont pour l'instant au nombre de 3.

BracketRouteConverter
---------------------

Ce convertisseur transforme les `[]` qui rendent des parties de routes optionnelles en
un système plus général, celui des filtres dont on parlera plus bas dans la partie traitant
le `FilterRouteConverter`.

Un exemple sera ici assez parlant :

    /entities/[{order}/][genre-{genre}/][pays-{country}/]

devient

    /entities/[filters_0://order: ~, genre: genre, country: pays]

Le système de filtres est numéroté, il peut y avoir plusieurs groupes de filtres lorsque
des parties non consécutives d'une URL sont optionnelles, ce qui est un cas rare mais
présent sur le site.

Chaque filtre est composé d'un nom qui est le nom du paramètre qui sera envoyé
au contrôleur et d'un préfixe optionnel qui peut valoir `null`, ici représenté par un
`~` pour suivre les conventions employées par le format YAML.

OptionalPrefixRouteConverter
----------------------------

Ce convertisseur gère le cas particulier où un filtre est situé en début d'URL, qui
pose des problèmes à cause d'un comportement de Symfony qui rajoute automatiquement
des / en début de path s'ils ne semblent pas spécifiés.

FilterRouteConverter
--------------------

Ce convertisseur est le plus complexe mais le plus intéressant. Il génère une regex par
groupe de filtres qui détecte des paramètres nommés correspondant aux différents filtres
avec gestion de l'ordre des filtres.

Les détails peuvent être trouvés dans le fichier de fixtures de test `tests/fixtures/4-after-filters.yaml`
