<?php

declare(strict_types=1);

namespace Webedia\RoutingBundle;

class MultiplePathsRouteConverter implements RouteConverterInterface
{
    public const SUB_ROUTE_SEPARATOR = '__';
    public const SUB_ROUTE_PREFIX = 'SUB_ROUTE' . self::SUB_ROUTE_SEPARATOR;

    public function convertRoutes(array $routes): array
    {
        if (empty($routes)) {
            return [];
        }

        $newRoutes = [];
        foreach ($routes as $routeName => $route) {
            $newRoutes = array_merge($newRoutes, $this->explodeRoute($routeName, $route));
        }

        return $newRoutes;
    }

    public static function hasRouteMultiplePaths(array $route): bool
    {
        return isset($route['path']) && !empty($route['path']) && is_array($route['path']);
    }

    private function explodeRoute(string $routeName, array $route): array
    {
        if (!$this->hasRouteMultiplePaths($route)) {
            return [$routeName => $route];
        }

        $brandedRoutes = [];
        foreach ($route['path'] as $subRoute => $path) {
            $newRoute = $route;
            $newRoute['path'] = $newRoute['path'][$subRoute];

            $brandedRoutes[self::SUB_ROUTE_PREFIX . $subRoute . self::SUB_ROUTE_SEPARATOR . $routeName] = $newRoute;
        }

        return $brandedRoutes;
    }
}
