<?php

namespace Webedia\RoutingBundle\EventSubscriber;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpKernel\Event\RequestEvent;
use Symfony\Component\HttpKernel\KernelEvents;

class UrlMappingSubscriber implements EventSubscriberInterface
{
    public static function getSubscribedEvents(): array
    {
        return [
            KernelEvents::REQUEST => ['onKernelRequest', -100],
        ];
    }

    public function onKernelRequest(RequestEvent $event): void
    {
        $attributes = $event->getRequest()->attributes;
        $parameters = $event->getRequest()->get('_route_params');
        if (empty($parameters['_mapping'])) {
            $this->cleanEmptyFilterParts($attributes);

            return;
        }
        $mapping = $parameters['_mapping'];
        foreach ($mapping as $mappingKey => $mappingValues) {
            $attributes->set($mappingKey, array_search($attributes->get($mappingKey, ''), $mappingValues, false));
        }
        $this->cleanEmptyFilterParts($attributes);
    }

    /**
     * Remove from request attributes empty filters parts.
     */
    private function cleanEmptyFilterParts(ParameterBag $attributes): void
    {
        $filterPartNames = [];
        foreach ($attributes as $attributeName => $attributeValue) {
            if (preg_match('#filters_[0-9]+_order#', $attributeName)) {
                $filterPartNames = array_merge($filterPartNames, array_keys($attributeValue));
            }
        }
        foreach ($attributes as $attributeName => $attributeValue) {
            if ('' === $attributeValue && \in_array($attributeName, $filterPartNames)) {
                $filtersDefaults = $attributes->get('filters_defaults', []);
                if (isset($filtersDefaults[$attributeName])) {
                    $attributes->set($attributeName, $filtersDefaults[$attributeName]);
                } else {
                    $attributes->remove($attributeName);
                }
            }
        }
    }
}
