<?php

declare(strict_types=1);

namespace Symfony\Component\DependencyInjection\Loader\Configurator;

use Webedia\RoutingBundle\BracketRouteConverter;
use Webedia\RoutingBundle\ChainRouteConverter;
use Webedia\RoutingBundle\EventSubscriber\UrlMappingSubscriber;
use Webedia\RoutingBundle\FilterRouteConverter;
use Webedia\RoutingBundle\Loader\AttributeClassLoader;
use Webedia\RoutingBundle\Loader\YamlFileLoader;
use Webedia\RoutingBundle\MultiplePathsRouteConverter;
use Webedia\RoutingBundle\OptionalPrefixRouteConverter;
use Webedia\RoutingBundle\RouterDecorator;

return static function (ContainerConfigurator $container): void {
    $services = $container->services();

    $services->set('webedia_routing.router_decorator', RouterDecorator::class)
        ->decorate('router')
        ->args([service('webedia_routing.router_decorator.inner')])
        ->call('setUrlGenerator');

    $services->set('webedia_routing.url_mapping_subscriber', UrlMappingSubscriber::class)
        ->tag('kernel.event_subscriber');

    $services->set('webedia_routing.multiple_paths_route_converter', MultiplePathsRouteConverter::class)
        ->tag('routing.route_converter', ['priority' => 10]);

    $services->set('webedia_routing.bracket_route_converter', BracketRouteConverter::class)
        ->tag('routing.route_converter', ['priority' => 9]);

    $services->set('webedia_routing.optional_prefix_route_converter', OptionalPrefixRouteConverter::class)
        ->tag('routing.route_converter', ['priority' => 2]);

    $services->set('webedia_routing.filter_route_converter', FilterRouteConverter::class)
        ->tag('routing.route_converter', ['priority' => 1]);

    $services->set('webedia_routing.chain_route_converter', ChainRouteConverter::class)
        ->args([tagged_iterator('routing.route_converter', indexAttribute: 'priority')]);

    $services->set('webedia_routing.loader.yaml_file_loader', YamlFileLoader::class)
        ->args([
            service('file_locator'),
            service('webedia_routing.chain_route_converter'),
            param('kernel.environment'),
        ])
        ->tag('routing.loader');

    $services->set('webedia_routing.loader.attribute_class_loader', AttributeClassLoader::class)
        ->args([
            service('webedia_routing.chain_route_converter'),
            param('kernel.environment'),
        ])
        ->tag('routing.loader');

    $services->alias('routing.loader.yml', 'webedia_routing.loader.yaml_file_loader');
    $services->alias('routing.loader.attribute', 'webedia_routing.loader.attribute_class_loader');
};
