<?php

namespace Webedia\RoutingBundle\Router;

use Symfony\Component\Routing\Exception\ResourceNotFoundException;
use Symfony\Component\Routing\Exception\RouteNotFoundException;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

abstract class AbstractRouterDecoratorV4 extends AbstractRouterDecorator
{
    public function generate($name, $parameters = [], $referenceType = UrlGeneratorInterface::ABSOLUTE_PATH)
    {
        try {
            return $this->doGenerate($name, $parameters, $referenceType);
        } catch (RouteNotFoundException $e) {
            throw new ResourceNotFoundException(sprintf('Unable to generate a URL for the named route "%s" as such route does not exist', $name), 0, $e);
        }
    }

    public function match($pathinfo)
    {
        return $this->router->match($pathinfo);
    }

    public function warmUp($cacheDir)
    {
        $this->router->warmUp($cacheDir);
    }
}
