<?php

namespace Webedia\RoutingBundle;

class OptionalPrefixRouteConverter implements RouteConverterInterface
{
    public function convertRoutes(array $routes): array
    {
        if (empty($routes)) {
            return [];
        }

        $newRoutes = [];
        foreach ($routes as $routeName => $route) {
            $newRoutes[$routeName] = $route;
            if ($this->hasOptionalPrefix($route)) {
                continue;
            }

            $this->removeRequirements($route);
            $route['path'] = preg_replace('#\[filters_0:\/\/[^]]+\]#', '', $route['path']);
            $newRoutes[$routeName.'_no_prefix'] = $route;
        }

        return $newRoutes;
    }

    private function hasOptionalPrefix(array $route): bool
    {
        return empty($route['path']) || !preg_match('#^\/\[filters_0#', $route['path']);
    }

    private function removeRequirements(array &$route): void
    {
        preg_match('#\/\[filters_0:\/\/(.+)\]#', $route['path'], $matches);
        /** @var array $urlParts */
        $urlParts = preg_split('#,\s*#', $matches[1]);
        foreach ($urlParts as $urlPart) {
            /** @var array $part */
            $part = preg_split('#:\s*#', $urlPart);

            if (!empty($route['requirements'][$part[0]])) {
                unset($route['requirements'][$part[0]]);

                if (empty($route['requirements'])) {
                    unset($route['requirements']);
                }
            }
        }
    }
}
