<?php

namespace Webedia\RoutingBundle;

use Symfony\Component\Yaml\Yaml;

class ChainRouteConverter
{
    /**
     * @var RouteConverterInterface[]
     */
    private $converters;

    /**
     * @param iterable $converters
     */
    public function __construct(iterable $converters)
    {
        $this->converters = $converters instanceof \Traversable ? iterator_to_array($converters) : $converters;
    }

    public function convert(string $content): string
    {
        if (empty(trim($content))) {
            return $content;
        }

        $routes = Yaml::parse($content, Yaml::PARSE_CONSTANT);

        foreach ($this->converters as $converter) {
            if (!empty($routes)) {
                $routes = $converter->convertRoutes($routes);
            }
        }

        return Yaml::dump($routes);
    }
}
