Introduction au Routing chez WEBEDIA Entertainment
=====================================

Le SEO a imposé de nombreuses contraintes au système de routing des sites WEBEDIA Entertainment.

Lors du passage à Symfony 4.3, ce système très complexe n'était plus valable et
a dû être refait avec pour objectif d'être un peu plus maintenable mais surtout
de garder la définition des routes du legacy pour le moment car cela impactait
non seulement les routes mais également les controllers qui attendaient leurs arguments
sous une certaine forme et les templates qui dépendaient également des paramètres du Router.

Un exemple de routage complexe, inspiré du site allocine.fr, peut se voir sur la page des films qui doit supporter les filtres suivants et toutes leurs combinaisons :

  - /entities/
  - /entities/presse/genre-1/pays-1/decennie-1980/annee-1985
  - /entities/pays-1/decennie-1980
  - /entities/press/country-1/decade-1980 **(exemple de traduction pour une autre brand)**

Les objectifs du nouveau router sont donc de :

  - Fournir un système qui permet de  manière transparente de compiler des routes
  complexes non supportées par Symfony en routes plus simples et classiques
  - Gérer correctement les brands et l'ancien système dit de mapping qui permet par
  exemple d'utiliser le mot clé `presse` en français et `press` en anglais selon la
  brand dans l'URL pour parler d'un même type d'ordre (trié par notes attribuées par
  la presse). La classe `UrlMappingSubscriber` s'occupe de traduire les paramètres
  possédant un mapping.
  - Gérer correctement l'ancien système de crochets qui indiquent une partie de la
  route optionnelle et qui permettent de gérer les différentes combinaisons de routes
  ci-dessus.
  - Etre complètement compatible avec l'ancien système, notamment au niveau de la génération
  et de la reconnaissance de routes pour éviter d'avoir à modifier tous les templates et
  tous les contrôleurs.

Pour que le système soit extensible, on utilise un système de convertisseurs successifs qui
traitent les fichiers de routes définis dans `config` en décorant le `YamlFileLoader` pour
qu'il donne à Symfony des fichiers convertis.

L'intégralité du code du système de routage se situe dans `src/Routing` pour
éviter d'avoir à chercher un peu partout si on doit de nouveau le modifier un jour.

Des exemples de ce que font les convertisseurs sont disponibles dans le dossier de fixtures
de test : `tests/fixtures`. Le premier fichier est le fichier source et les
suivants sont des passages à travers les convertisseurs successifs qui sont détaillés dans
[cette documentation](convertisseurs.md).
