# Jump PHP Utils

This library, `jump-php-utils`, is a cross-platform utility library to generate a Jump token for PHP environments. It includes functions to encode data in base64url format and to encrypt and decrypt data using the XOR algorithm.

## Features

- Encode strings into base64url format.
- Encrypt strings using a simple XOR cipher.

## Usage

Here's a quick example to get you started:

This example build fully Jump link
```php
<?php

use Webedia\Jump\DTO\JumpLink;
use Webedia\Jump\TokenGenerator;

require 'vendor/autoload.php';

$url = 
    (
        new JumpLinkGenerator(
            new TokenGenerator('key')
        )
    )->buildLink(
        'http://pattern.fr/truc#%s',
        new JumpLink('fakeurl', 'partner', ['productName'])
    );

  echo $url;
```

or generate token

```php
<?php

use Webedia\Jump\DTO\JumpLink;
use Webedia\Jump\TokenGenerator;

require 'vendor/autoload.php';

$token = (new TokenGenerator('key'))
            ->buildToken(new JumpLink('fakeurl', 'partner', ['productName'])
        ;
echo $token;
```


This will output a Jump token that is encrypted and encoded, ready for use in your jump link.

## Start project 


please use the following command to start the project:

```bash
docker-compose run php bash
```

## Advance usage

If you create token generator, it's possible to add custom normalizer to override IterableNormalizer and format data as you want.

```php
<?php


use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
use Webedia\Jump\DTO\JumpLink;
use Webedia\Jump\TokenGenerator;

require 'vendor/autoload.php';

class CustomNormalizer implements NormalizerInterface
{
    public function normalize($data, string $format = null, array $context = [])
    {
        return ['valeur1' => 'default_value', 'valeur2' => $data[0]];
    }

    public function supportsNormalization($data, string $format = null)
    {
        return true;
    }
}

$token = (new TokenGenerator('key', new CustomNormalizer()))
    ->buildToken(new JumpLink('fakeurl', 'partner', ['productName']))
        ;
echo $token;
```

