<?php

namespace Webedia\Jump\Tests;

use PHPUnit\Framework\TestCase;
use Webedia\Jump\Base64Url;
use Webedia\Jump\DTO\Data;
use Webedia\Jump\DTO\JumpLink;
use Webedia\Jump\DTO\Publication;
use Webedia\Jump\Serializer\IterableNormalizer;
use Webedia\Jump\TokenGenerator;
use Webedia\Jump\XorCypher;

class TokenGeneratorTest extends TestCase
{
    public function testBuildTokenWithEntity(): void
    {
        //given;
        $urlRedirect = 'http://redirect.com';
        $partner = 'partner';
        $key = 'toto';
        $productName = 'productName';
        $publicationSource = 'source';
        $date = new \DateTime();
        $data = [
            'product_name' => 'productName',
            'publication_date' => $date->format('Y-m-d'),
            'publication_source' => 'source'
        ];

        //when
        $token = (new TokenGenerator($key, new IterableNormalizer()))
            ->buildToken(new JumpLink($urlRedirect, $partner, $data))
        ;

        //then
        $tokenDecrypted = json_decode(XorCypher::encrypt(Base64Url::decode($token), $key), true);

        static::assertSame($urlRedirect, $tokenDecrypted['url']);
        static::assertSame($partner, $tokenDecrypted['partner']);
        static::assertArrayHasKey('data', $tokenDecrypted);

        $data = json_decode($tokenDecrypted['data'], true);

        static::assertArrayHasKey('product_name', $data);
        static::assertSame($productName, $data['product_name']);

        static::assertArrayHasKey('publication_date', $data);
        self::assertSame($date->format('Y-m-d'), $data['publication_date']);

        static::assertArrayHasKey('publication_source', $data);
        static::assertSame($publicationSource, $data['publication_source']);
    }
}
