<?php

namespace Webedia\Jump\Tests\Serializer;

use PHPUnit\Framework\TestCase;
use Webedia\Jump\DTO\JumpLink;
use Webedia\Jump\Serializer\IterableNormalizer;
use Webedia\Jump\Serializer\JumpLinkNormalization;

class JumpLinkNormalizationTest extends TestCase
{
    public function testNormalize(): void
    {
        //given
        $url = 'http://redirect.com';
        $partner = 'partner';
        $data = [1, '2', ['key' => 'value']];

        //then
        $result = (new JumpLinkNormalization(new IterableNormalizer()))
            ->normalize(
                new JumpLink($url, $partner, $data)
            );

        //then
        static::assertSame($url, $result['url']);
        static::assertSame($partner, $result['partner']);
        static::assertSame(json_encode($data, JSON_FORCE_OBJECT), $result['data']);
    }

    public function testSupport(): void
    {
        //given
        $jumpNormalization = new JumpLinkNormalization(new IterableNormalizer());

        //then
        static::assertFalse($jumpNormalization->supportsNormalization(''));
        static::assertTrue(
            $jumpNormalization->supportsNormalization(new JumpLink('url', 'partner', []))
        );
    }
}
