<?php

namespace Webedia\Jump\Tests;

use PHPUnit\Framework\TestCase;
use Webedia\Jump\DTO\JumpLink;
use Webedia\Jump\JumpLinkGenerator;
use Webedia\Jump\TokenGenerator;

class JumpLinkGeneratorTest extends TestCase
{
    public function testBuildUrl(): void
    {
        //when
        $url = (new JumpLinkGenerator(
            new TokenGenerator('key')
        )
        )->buildLink(
            'http://pattern.fr/truc#%s',
            new JumpLink('fakeurl', 'partner', ['productName'])
        );

        //then
        static::assertMatchesRegularExpression('/^http:\/\/pattern.fr\/truc#(\w|\d)*$/', $url);
    }
}
