<?php

namespace Webedia\Jump\Serializer;

use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class IterableNormalizer implements NormalizerInterface
{
    public function normalize($object, ?string $format = null, array $context = []): array
    {
        return iterator_to_array($object);
    }

    public function supportsNormalization($data, ?string $format = null): bool
    {
        return is_iterable($data);
    }
}
