<?php

namespace Webedia\Jump;

use Symfony\Component\Serializer\Encoder\JsonEncoder;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
use Symfony\Component\Serializer\Normalizer\PropertyNormalizer;
use Symfony\Component\Serializer\Serializer;
use Symfony\Component\Serializer\SerializerInterface;
use Webedia\Jump\DTO\JumpLink;
use Webedia\Jump\Interfaces\TokenGeneratorInterface;
use Webedia\Jump\Serializer\IterableNormalizer;
use Webedia\Jump\Serializer\JumpLinkNormalization;

class TokenGenerator implements TokenGeneratorInterface
{
    private SerializerInterface $serializer;
    private string $key;

    public function __construct(string $jumpKey, ?NormalizerInterface $normalizer = null)
    {
        if ($normalizer === null) {
            $normalizer = new IterableNormalizer();
        }

        $this->serializer = new Serializer(
            [new JumpLinkNormalization($normalizer),  new PropertyNormalizer()],
            [new JsonEncoder()]
        );

        $this->key = $jumpKey;
    }

    public function buildToken(JumpLink $jumpLink): string
    {
        $jsonContent = $this->serializer->serialize(
            $jumpLink,
            JsonEncoder::FORMAT,
            ['json_encode_options' => JSON_UNESCAPED_SLASHES, 'jump']
        );

        $xorToken = XorCypher::encrypt($jsonContent, $this->key);

        return Base64Url::encode($xorToken);
    }
}
