<?php

namespace Webedia\Jump\Serializer;

use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
use Webedia\Jump\DTO\JumpLink;

class JumpLinkNormalization implements NormalizerInterface
{
    private NormalizerInterface $dataNormalizer;

    public function __construct(NormalizerInterface $dataNormalizer)
    {
        $this->dataNormalizer = $dataNormalizer;
    }

    public function supportsNormalization($data, ?string $format = null, array $context = []): bool
    {
        return $data instanceof JumpLink;
    }

    public function normalize($object, ?string $format = null, array $context = []): array
    {
        if (!$object instanceof JumpLink) {
            throw new \RuntimeException('Impossible because is checked by supportsNormalization');
        }

        $commonData = [
            'url' => $object->getUrlRedirect(),
            'partner' => $object->getPartner(),
        ];

        return array_merge(
            $commonData,
            [
                'data' => json_encode(
                    $this->dataNormalizer->normalize($object->getData(), $format, $context),
                    JSON_FORCE_OBJECT
                )
            ]
        );
    }

    public function getSupportedTypes(?string $format): array
    {
        return [
            JumpLink::class => true,
        ];
    }
}
