<?php

namespace Webedia\Jump;

use Webedia\Jump\DTO\JumpLink;
use Webedia\Jump\Interfaces\JumpLinkGeneratorInterface;
use Webedia\Jump\Interfaces\TokenGeneratorInterface;

class JumpLinkGenerator implements JumpLinkGeneratorInterface
{
    private TokenGeneratorInterface $tokenGenerator;

    public function __construct(TokenGeneratorInterface $tokenGenerator)
    {
        $this->tokenGenerator = $tokenGenerator;
    }

    /**
     * @param string $pattern The pattern to build the link
     */
    public function buildLink(string $pattern, JumpLink $jumpLink): string
    {
        return sprintf($pattern, $this->tokenGenerator->buildToken($jumpLink));
    }
}
