<?php

declare(strict_types=1);

namespace Webedia\CloudflareBundle\DependencyInjection;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

class WebediaCloudflareExtension extends Extension
{
    public function load(array $configs, ContainerBuilder $container): void
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new YamlFileLoader($container, new FileLocator(__DIR__.'/../Resources/config'));
        $loader->load('services.yml');

        $cloudflareDefinition = $container->getDefinition('app.http_client.cloudflare');
        $cloudflareDefinition
            ->setArgument(0, array_merge(
                    $cloudflareDefinition->getArgument(0), [
                        'base_uri' => $config['base_uri'],
                        'auth_bearer' => $config['auth_bearer'],
                    ]
                )
            );

        $container->getDefinition('Webedia\CloudflareBundle\Cache\CloudflareCachePurger')
            ->setArguments([
                '$domains' => $config['domains'],
                '$domainIdentifiers' => $config['domain_identifiers'],
            ]);
    }
}
