<?php

declare(strict_types=1);

namespace Webedia\CloudflareBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder('webedia_cloudflare');

        $treeBuilder
            ->getRootNode()
                ->children()
                    ->scalarNode('base_uri')->end()
                    ->scalarNode('auth_bearer')->end()
                    ->arrayNode('domain_identifiers')
                        ->scalarPrototype()->end()
                    ->end()
                    ->arrayNode('domains')
                        ->arrayPrototype()
                            ->children()
                                ->scalarNode('domain')->end()
                                ->scalarNode('proto')->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
