<?php

$finder = PhpCsFixer\Finder::create()
    ->exclude('Annotation')
    ->name('*.php')
    ->in([
        __DIR__.'/src',
        __DIR__.'/tests',
    ])
;

return (new PhpCsFixer\Config())
    ->setRules(
        [
            '@Symfony' => true,
            '@PHP71Migration' => true,
            '@PHP71Migration:risky' => true,
            'ordered_imports' => ['imports_order' => ['class', 'function', 'const']],
            'fully_qualified_strict_types' => true,
            'single_line_throw' => false,
            'phpdoc_to_comment' => false,
            'no_superfluous_phpdoc_tags' => ['allow_mixed' => true],
            'global_namespace_import' => ['import_functions' => true, 'import_classes' => true, 'import_constants' => true],
            'phpdoc_summary' => false,
            'single_line_comment_style' => ['comment_types' => ['hash']],
            'phpdoc_no_alias_tag' => ['replacements' => ['type' => 'var']],
            'no_mixed_echo_print' => ['use' => 'echo'],
        ]
    )
    ->setFinder($finder)
    ->setUsingCache(true)
    ;
