SHELL := /bin/bash
.DEFAULT_GOAL := help
CURRENT_DIR := $(shell dirname $(realpath $(lastword $(MAKEFILE_LIST))))
MAKE_DIR := $(shell dirname $(realpath $(firstword $(MAKEFILE_LIST))))

ifneq (,$(wildcard $(MAKE_DIR)/.env.makefile))
    include $(MAKE_DIR)/.env.makefile
	export $(shell sed 's/=.*//' $(MAKE_DIR)/.env.makefile)
endif

ifeq ($(shell uname -s),Linux)
export DOCKER_BUILDKIT = 1
endif

export USER_ID ?=$(shell id -u)
export GROUP_ID ?= $(shell id -g)
export APP_ENV ?= dev

DOCKER_RUN = docker run --rm -ti -v ${CURRENT_DIR}/..:/workspace

## —— Utils 🔧  ———————————————————————————————————————————————————————————————————————
check-command-%:
	@: $(if $(shell which $*),,$(error command not found: $*))

define color_text
	printf "\e[1;$(2)m$(1)\e[0m\n"
endef

.env: .env.$(APP_ENV).dist
	@test -f $@ \
		&& $(call color_text,/!\ $< might have been modified - remove $@ to be up-to-date,31) \
		|| ( echo "Copy $@ from $<"; cp $< $@)

.PHONY: clean
clean: ## Clean all files not versioned
	git clean -xdf

## —— The Makefile ℹ️  —————————————————————————————————————————————————————————————————
.PHONY: help
help: ## Outputs this help screen
	@grep -h -E '(^[a-zA-Z0-9_-]+:.*?##.*$$)|(^##)' $(MAKEFILE_LIST) | awk 'BEGIN {FS = ":.*?## "}{printf "\033[32m%-30s\033[0m %s\n", $$1, $$2}' | sed -e 's/\[32m##/[33m/'
