CURRENT_DIR := $(shell dirname $(realpath $(lastword $(MAKEFILE_LIST))))
GCP_LOCATION ?= europe-west1

ifeq (${APP_ENV},dev)
GCLOUD_PREFIX = ${DOCKER_RUN} -e CLOUDSDK_CONFIG=/workspace/.docker/gcloud/config \
				 -u ${USER_ID}:${GROUP_ID} \
				 -w /workspace \
				 gcr.io/google.com/cloudsdktool/cloud-sdk:slim
else
GCLOUD_PREFIX = CLOUDSDK_CONFIG="${PWD}/.docker/gcloud/config"
endif

## —— authentification 🔧   —————————————————————————————————————————————
.PHONY: auth gcloud_check_auth gcloud_login docker_login

auth: gcloud_check_auth docker_login ## Login to Google Cloud Platform using docker container

gcloud_check_auth:
ifeq ($(shell ${GCLOUD_PREFIX} gcloud auth list --filter="status:ACTIVE AND account ~ '.+@((ext\.)?webedia-group\.com|corp\.webedia\.fr)'" --format="value(account)" 2> /dev/null | grep "@" | wc -l | tr -d ' '), 0)
	$(MAKE) gcloud_login
endif

gcloud_login: ## authenticate on GCP
	${GCLOUD_PREFIX} gcloud auth login --no-launch-browser

docker_login: ## authenticate
	${GCLOUD_PREFIX} gcloud auth print-access-token | docker login -u oauth2accesstoken --password-stdin https://${GCP_LOCATION}-docker.pkg.dev

docker-token:
	${GCLOUD_PREFIX} gcloud auth print-access-token

## —— Gcloud ⛅ ———————————————————————————————————————————————————————————————————————
.PHONY:  gcloud_sh

gcloud_sh: ## run a shell on the gcloud container
	${GCLOUD_PREFIX} bash
