<?php

declare(strict_types=1);

namespace Psalm\Internal;

/** @internal */
final class PreloaderList {
    public const CLASSES = [
        \AdvancedJsonRpc\Dispatcher::class,
        \AdvancedJsonRpc\Error::class,
        \AdvancedJsonRpc\ErrorCode::class,
        \AdvancedJsonRpc\ErrorResponse::class,
        \AdvancedJsonRpc\Notification::class,
        \AdvancedJsonRpc\Request::class,
        \AdvancedJsonRpc\Response::class,
        \AdvancedJsonRpc\SuccessResponse::class,
        \Amp\ByteStream\AsyncWriter::class,
        \Amp\ByteStream\Base64\Base64DecodingReadableStream::class,
        \Amp\ByteStream\Base64\Base64DecodingWritableStream::class,
        \Amp\ByteStream\Base64\Base64EncodingReadableStream::class,
        \Amp\ByteStream\Base64\Base64EncodingWritableStream::class,
        \Amp\ByteStream\BufferException::class,
        \Amp\ByteStream\BufferedReader::class,
        \Amp\ByteStream\ClosedException::class,
        \Amp\ByteStream\Compression\CompressingReadableStream::class,
        \Amp\ByteStream\Compression\CompressingWritableStream::class,
        \Amp\ByteStream\Compression\DecompressingReadableStream::class,
        \Amp\ByteStream\Compression\DecompressingWritableStream::class,
        \Amp\ByteStream\Internal\ChannelParser::class,
        \Amp\ByteStream\Payload::class,
        \Amp\ByteStream\PendingReadError::class,
        \Amp\ByteStream\Pipe::class,
        \Amp\ByteStream\ReadableBuffer::class,
        \Amp\ByteStream\ReadableIterableStream::class,
        \Amp\ByteStream\ReadableResourceStream::class,
        \Amp\ByteStream\ReadableStream::class,
        \Amp\ByteStream\ReadableStreamChain::class,
        \Amp\ByteStream\ReadableStreamIteratorAggregate::class,
        \Amp\ByteStream\ResourceStream::class,
        \Amp\ByteStream\StreamChannel::class,
        \Amp\ByteStream\StreamException::class,
        \Amp\ByteStream\WritableBuffer::class,
        \Amp\ByteStream\WritableIterableStream::class,
        \Amp\ByteStream\WritableResourceStream::class,
        \Amp\ByteStream\WritableStream::class,
        \Amp\Cache\AtomicCache::class,
        \Amp\Cache\Cache::class,
        \Amp\Cache\CacheException::class,
        \Amp\Cache\LocalCache::class,
        \Amp\Cache\NullCache::class,
        \Amp\Cache\PrefixCache::class,
        \Amp\Cache\SerializedCache::class,
        \Amp\Cache\StringCache::class,
        \Amp\Cache\StringCacheAdapter::class,
        \Amp\Cancellation::class,
        \Amp\CancelledException::class,
        \Amp\Closable::class,
        \Amp\CompositeCancellation::class,
        \Amp\CompositeException::class,
        \Amp\CompositeLengthException::class,
        \Amp\DeferredCancellation::class,
        \Amp\DeferredFuture::class,
        \Amp\Dns\BlockingFallbackDnsResolver::class,
        \Amp\Dns\DnsConfig::class,
        \Amp\Dns\DnsConfigException::class,
        \Amp\Dns\DnsConfigLoader::class,
        \Amp\Dns\DnsException::class,
        \Amp\Dns\DnsRecord::class,
        \Amp\Dns\DnsResolver::class,
        \Amp\Dns\DnsTimeoutException::class,
        \Amp\Dns\HostLoader::class,
        \Amp\Dns\Internal\Socket::class,
        \Amp\Dns\Internal\TcpSocket::class,
        \Amp\Dns\Internal\UdpSocket::class,
        \Amp\Dns\InvalidNameException::class,
        \Amp\Dns\MissingDnsRecordException::class,
        \Amp\Dns\Rfc1035StubDnsResolver::class,
        \Amp\Dns\StaticDnsConfigLoader::class,
        \Amp\Dns\UnixDnsConfigLoader::class,
        \Amp\Dns\WindowsDnsConfigLoader::class,
        \Amp\ForbidCloning::class,
        \Amp\ForbidSerialization::class,
        \Amp\Future::class,
        \Amp\Future\UnhandledFutureError::class,
        \Amp\Internal\Cancellable::class,
        \Amp\Internal\FutureIterator::class,
        \Amp\Internal\FutureIteratorQueue::class,
        \Amp\Internal\FutureState::class,
        \Amp\Internal\WrappedCancellation::class,
        \Amp\Interval::class,
        \Amp\NullCancellation::class,
        \Amp\PHPUnit\AsyncTestCase::class,
        \Amp\PHPUnit\CallbackStub::class,
        \Amp\PHPUnit\TestException::class,
        \Amp\PHPUnit\UnhandledException::class,
        \Amp\Parallel\Context\Context::class,
        \Amp\Parallel\Context\ContextException::class,
        \Amp\Parallel\Context\ContextFactory::class,
        \Amp\Parallel\Context\ContextPanicError::class,
        \Amp\Parallel\Context\DefaultContextFactory::class,
        \Amp\Parallel\Context\Internal\AbstractContext::class,
        \Amp\Parallel\Context\Internal\ContextChannel::class,
        \Amp\Parallel\Context\Internal\ContextException::class,
        \Amp\Parallel\Context\Internal\ContextMessage::class,
        \Amp\Parallel\Context\Internal\ExitFailure::class,
        \Amp\Parallel\Context\Internal\ExitResult::class,
        \Amp\Parallel\Context\Internal\ExitSuccess::class,
        \Amp\Parallel\Context\Internal\ParallelHub::class,
        \Amp\Parallel\Context\ProcessContext::class,
        \Amp\Parallel\Context\ProcessContextFactory::class,
        \Amp\Parallel\Context\StatusError::class,
        \Amp\Parallel\Context\ThreadContext::class,
        \Amp\Parallel\Context\ThreadContextFactory::class,
        \Amp\Parallel\Ipc\IpcHub::class,
        \Amp\Parallel\Ipc\LocalIpcHub::class,
        \Amp\Parallel\Ipc\SocketIpcHub::class,
        \Amp\Parallel\Worker\ContextWorkerFactory::class,
        \Amp\Parallel\Worker\ContextWorkerPool::class,
        \Amp\Parallel\Worker\DelegatingWorkerPool::class,
        \Amp\Parallel\Worker\Execution::class,
        \Amp\Parallel\Worker\Internal\ContextWorker::class,
        \Amp\Parallel\Worker\Internal\JobCancellation::class,
        \Amp\Parallel\Worker\Internal\JobChannel::class,
        \Amp\Parallel\Worker\Internal\JobMessage::class,
        \Amp\Parallel\Worker\Internal\JobPacket::class,
        \Amp\Parallel\Worker\Internal\PooledWorker::class,
        \Amp\Parallel\Worker\Internal\TaskCancelled::class,
        \Amp\Parallel\Worker\Internal\TaskExceptionType::class,
        \Amp\Parallel\Worker\Internal\TaskFailure::class,
        \Amp\Parallel\Worker\Internal\TaskResult::class,
        \Amp\Parallel\Worker\Internal\TaskSubmission::class,
        \Amp\Parallel\Worker\Internal\TaskSuccess::class,
        \Amp\Parallel\Worker\LimitedWorkerPool::class,
        \Amp\Parallel\Worker\Task::class,
        \Amp\Parallel\Worker\TaskCancelledException::class,
        \Amp\Parallel\Worker\TaskFailureError::class,
        \Amp\Parallel\Worker\TaskFailureException::class,
        \Amp\Parallel\Worker\TaskFailureThrowable::class,
        \Amp\Parallel\Worker\Worker::class,
        \Amp\Parallel\Worker\WorkerException::class,
        \Amp\Parallel\Worker\WorkerFactory::class,
        \Amp\Parallel\Worker\WorkerPool::class,
        \Amp\Parser\InvalidDelimiterError::class,
        \Amp\Parser\Parser::class,
        \Amp\Pipeline\ConcurrentIterator::class,
        \Amp\Pipeline\DisposedException::class,
        \Amp\Pipeline\Internal\ConcurrentArrayIterator::class,
        \Amp\Pipeline\Internal\ConcurrentChainedIterator::class,
        \Amp\Pipeline\Internal\ConcurrentClosureIterator::class,
        \Amp\Pipeline\Internal\ConcurrentFlatMapIterator::class,
        \Amp\Pipeline\Internal\ConcurrentIterableIterator::class,
        \Amp\Pipeline\Internal\ConcurrentMergedIterator::class,
        \Amp\Pipeline\Internal\ConcurrentQueueIterator::class,
        \Amp\Pipeline\Internal\FlatMapOperation::class,
        \Amp\Pipeline\Internal\IntermediateOperation::class,
        \Amp\Pipeline\Internal\QueueState::class,
        \Amp\Pipeline\Internal\Sequence::class,
        \Amp\Pipeline\Internal\SortOperation::class,
        \Amp\Pipeline\Pipeline::class,
        \Amp\Pipeline\Queue::class,
        \Amp\Process\Internal\Posix\PosixHandle::class,
        \Amp\Process\Internal\Posix\PosixRunner::class,
        \Amp\Process\Internal\ProcHolder::class,
        \Amp\Process\Internal\ProcessContext::class,
        \Amp\Process\Internal\ProcessHandle::class,
        \Amp\Process\Internal\ProcessRunner::class,
        \Amp\Process\Internal\ProcessStatus::class,
        \Amp\Process\Internal\ProcessStreams::class,
        \Amp\Process\Internal\Windows\HandshakeException::class,
        \Amp\Process\Internal\Windows\HandshakeStatus::class,
        \Amp\Process\Internal\Windows\SignalCode::class,
        \Amp\Process\Internal\Windows\SocketConnector::class,
        \Amp\Process\Internal\Windows\WindowsHandle::class,
        \Amp\Process\Internal\Windows\WindowsRunner::class,
        \Amp\Process\Process::class,
        \Amp\Process\ProcessException::class,
        \Amp\Serialization\CompressingSerializer::class,
        \Amp\Serialization\JsonSerializer::class,
        \Amp\Serialization\NativeSerializer::class,
        \Amp\Serialization\PassthroughSerializer::class,
        \Amp\Serialization\SerializationException::class,
        \Amp\Serialization\Serializer::class,
        \Amp\SignalCancellation::class,
        \Amp\SignalException::class,
        \Amp\Socket\BindContext::class,
        \Amp\Socket\Certificate::class,
        \Amp\Socket\CidrMatcher::class,
        \Amp\Socket\ClientTlsContext::class,
        \Amp\Socket\ConnectContext::class,
        \Amp\Socket\ConnectException::class,
        \Amp\Socket\DnsSocketConnector::class,
        \Amp\Socket\InternetAddress::class,
        \Amp\Socket\InternetAddressVersion::class,
        \Amp\Socket\PendingAcceptError::class,
        \Amp\Socket\PendingReceiveError::class,
        \Amp\Socket\ResourceServerSocket::class,
        \Amp\Socket\ResourceServerSocketFactory::class,
        \Amp\Socket\ResourceSocket::class,
        \Amp\Socket\ResourceUdpSocket::class,
        \Amp\Socket\RetrySocketConnector::class,
        \Amp\Socket\ServerSocket::class,
        \Amp\Socket\ServerSocketFactory::class,
        \Amp\Socket\ServerTlsContext::class,
        \Amp\Socket\Socket::class,
        \Amp\Socket\SocketAddress::class,
        \Amp\Socket\SocketAddressType::class,
        \Amp\Socket\SocketConnector::class,
        \Amp\Socket\SocketException::class,
        \Amp\Socket\SocketPool::class,
        \Amp\Socket\Socks5SocketConnector::class,
        \Amp\Socket\StaticSocketConnector::class,
        \Amp\Socket\TlsException::class,
        \Amp\Socket\TlsInfo::class,
        \Amp\Socket\TlsState::class,
        \Amp\Socket\UdpSocket::class,
        \Amp\Socket\UnixAddress::class,
        \Amp\Socket\UnlimitedSocketPool::class,
        \Amp\Sync\Barrier::class,
        \Amp\Sync\Channel::class,
        \Amp\Sync\ChannelException::class,
        \Amp\Sync\Internal\ConcurrentIteratorChannel::class,
        \Amp\Sync\KeyedMutex::class,
        \Amp\Sync\KeyedSemaphore::class,
        \Amp\Sync\LocalKeyedMutex::class,
        \Amp\Sync\LocalKeyedSemaphore::class,
        \Amp\Sync\LocalMutex::class,
        \Amp\Sync\LocalParcel::class,
        \Amp\Sync\LocalSemaphore::class,
        \Amp\Sync\Lock::class,
        \Amp\Sync\Mutex::class,
        \Amp\Sync\Parcel::class,
        \Amp\Sync\ParcelException::class,
        \Amp\Sync\PosixSemaphore::class,
        \Amp\Sync\PrefixedKeyedMutex::class,
        \Amp\Sync\PrefixedKeyedSemaphore::class,
        \Amp\Sync\PriorityQueue::class,
        \Amp\Sync\RateLimitingSemaphore::class,
        \Amp\Sync\Semaphore::class,
        \Amp\Sync\SemaphoreMutex::class,
        \Amp\Sync\SharedMemoryParcel::class,
        \Amp\Sync\StaticKeyMutex::class,
        \Amp\Sync\StaticKeySemaphore::class,
        \Amp\Sync\SyncException::class,
        \Amp\TimeoutCancellation::class,
        \Amp\TimeoutException::class,
        \Composer\Autoload\ClassLoader::class,
        \Composer\InstalledVersions::class,
        \Composer\Semver\Constraint\Constraint::class,
        \Composer\Semver\VersionParser::class,
        \Composer\XdebugHandler\XdebugHandler::class,
        \Fidry\CpuCoreCounter\CpuCoreCounter::class,
        \JsonMapper::class,
        \Kelunik\Certificate\Certificate::class,
        \LanguageServerProtocol\ClientCapabilities::class,
        \LanguageServerProtocol\ClientInfo::class,
        \LanguageServerProtocol\CodeAction::class,
        \LanguageServerProtocol\CodeActionContext::class,
        \LanguageServerProtocol\CodeActionKind::class,
        \LanguageServerProtocol\CodeDescription::class,
        \LanguageServerProtocol\Command::class,
        \LanguageServerProtocol\CompletionItem::class,
        \LanguageServerProtocol\CompletionItemKind::class,
        \LanguageServerProtocol\CompletionList::class,
        \LanguageServerProtocol\CompletionOptions::class,
        \LanguageServerProtocol\Diagnostic::class,
        \LanguageServerProtocol\DiagnosticSeverity::class,
        \LanguageServerProtocol\FileChangeType::class,
        \LanguageServerProtocol\FileEvent::class,
        \LanguageServerProtocol\Hover::class,
        \LanguageServerProtocol\InitializeResult::class,
        \LanguageServerProtocol\InitializeResultServerInfo::class,
        \LanguageServerProtocol\InsertTextFormat::class,
        \LanguageServerProtocol\Location::class,
        \LanguageServerProtocol\LogMessage::class,
        \LanguageServerProtocol\LogTrace::class,
        \LanguageServerProtocol\MarkupContent::class,
        \LanguageServerProtocol\MarkupKind::class,
        \LanguageServerProtocol\MessageType::class,
        \LanguageServerProtocol\ParameterInformation::class,
        \LanguageServerProtocol\Position::class,
        \LanguageServerProtocol\Range::class,
        \LanguageServerProtocol\SaveOptions::class,
        \LanguageServerProtocol\ServerCapabilities::class,
        \LanguageServerProtocol\SignatureHelp::class,
        \LanguageServerProtocol\SignatureHelpOptions::class,
        \LanguageServerProtocol\SignatureInformation::class,
        \LanguageServerProtocol\TextDocumentContentChangeEvent::class,
        \LanguageServerProtocol\TextDocumentIdentifier::class,
        \LanguageServerProtocol\TextDocumentItem::class,
        \LanguageServerProtocol\TextDocumentSyncKind::class,
        \LanguageServerProtocol\TextDocumentSyncOptions::class,
        \LanguageServerProtocol\TextEdit::class,
        \LanguageServerProtocol\VersionedTextDocumentIdentifier::class,
        \LanguageServerProtocol\WorkspaceEdit::class,
        \League\Uri\Uri::class,
        \League\Uri\UriString::class,
        \LibDNS\Decoder\Decoder::class,
        \LibDNS\Decoder\DecoderFactory::class,
        \LibDNS\Encoder\Encoder::class,
        \LibDNS\Encoder\EncoderFactory::class,
        \LibDNS\Messages\Message::class,
        \LibDNS\Messages\MessageFactory::class,
        \LibDNS\Messages\MessageResponseCodes::class,
        \LibDNS\Messages\MessageTypes::class,
        \LibDNS\Records\Question::class,
        \LibDNS\Records\QuestionFactory::class,
        \LibDNS\Records\ResourceQTypes::class,
        \LibDNS\Records\ResourceTypes::class,
        \PhpParser\Builder::class,
        \PhpParser\BuilderFactory::class,
        \PhpParser\BuilderHelpers::class,
        \PhpParser\Builder\ClassConst::class,
        \PhpParser\Builder\Class_::class,
        \PhpParser\Builder\Declaration::class,
        \PhpParser\Builder\EnumCase::class,
        \PhpParser\Builder\Enum_::class,
        \PhpParser\Builder\FunctionLike::class,
        \PhpParser\Builder\Function_::class,
        \PhpParser\Builder\Interface_::class,
        \PhpParser\Builder\Method::class,
        \PhpParser\Builder\Namespace_::class,
        \PhpParser\Builder\Param::class,
        \PhpParser\Builder\Property::class,
        \PhpParser\Builder\TraitUse::class,
        \PhpParser\Builder\TraitUseAdaptation::class,
        \PhpParser\Builder\Trait_::class,
        \PhpParser\Builder\Use_::class,
        \PhpParser\Comment::class,
        \PhpParser\Comment\Doc::class,
        \PhpParser\ConstExprEvaluationException::class,
        \PhpParser\ConstExprEvaluator::class,
        \PhpParser\Error::class,
        \PhpParser\ErrorHandler::class,
        \PhpParser\ErrorHandler\Collecting::class,
        \PhpParser\ErrorHandler\Throwing::class,
        \PhpParser\Internal\DiffElem::class,
        \PhpParser\Internal\Differ::class,
        \PhpParser\Internal\PrintableNewAnonClassNode::class,
        \PhpParser\Internal\TokenPolyfill::class,
        \PhpParser\Internal\TokenStream::class,
        \PhpParser\JsonDecoder::class,
        \PhpParser\Lexer::class,
        \PhpParser\Lexer\Emulative::class,
        \PhpParser\Lexer\TokenEmulator\AsymmetricVisibilityTokenEmulator::class,
        \PhpParser\Lexer\TokenEmulator\AttributeEmulator::class,
        \PhpParser\Lexer\TokenEmulator\EnumTokenEmulator::class,
        \PhpParser\Lexer\TokenEmulator\ExplicitOctalEmulator::class,
        \PhpParser\Lexer\TokenEmulator\KeywordEmulator::class,
        \PhpParser\Lexer\TokenEmulator\MatchTokenEmulator::class,
        \PhpParser\Lexer\TokenEmulator\NullsafeTokenEmulator::class,
        \PhpParser\Lexer\TokenEmulator\PropertyTokenEmulator::class,
        \PhpParser\Lexer\TokenEmulator\ReadonlyFunctionTokenEmulator::class,
        \PhpParser\Lexer\TokenEmulator\ReadonlyTokenEmulator::class,
        \PhpParser\Lexer\TokenEmulator\ReverseEmulator::class,
        \PhpParser\Lexer\TokenEmulator\TokenEmulator::class,
        \PhpParser\Modifiers::class,
        \PhpParser\NameContext::class,
        \PhpParser\Node::class,
        \PhpParser\NodeAbstract::class,
        \PhpParser\NodeDumper::class,
        \PhpParser\NodeFinder::class,
        \PhpParser\NodeTraverser::class,
        \PhpParser\NodeTraverserInterface::class,
        \PhpParser\NodeVisitor::class,
        \PhpParser\NodeVisitorAbstract::class,
        \PhpParser\NodeVisitor\CloningVisitor::class,
        \PhpParser\NodeVisitor\CommentAnnotatingVisitor::class,
        \PhpParser\NodeVisitor\FindingVisitor::class,
        \PhpParser\NodeVisitor\FirstFindingVisitor::class,
        \PhpParser\NodeVisitor\NameResolver::class,
        \PhpParser\NodeVisitor\NodeConnectingVisitor::class,
        \PhpParser\NodeVisitor\ParentConnectingVisitor::class,
        \PhpParser\Node\Arg::class,
        \PhpParser\Node\ArrayItem::class,
        \PhpParser\Node\Attribute::class,
        \PhpParser\Node\AttributeGroup::class,
        \PhpParser\Node\ClosureUse::class,
        \PhpParser\Node\ComplexType::class,
        \PhpParser\Node\Const_::class,
        \PhpParser\Node\DeclareItem::class,
        \PhpParser\Node\Expr::class,
        \PhpParser\Node\Expr\ArrayDimFetch::class,
        \PhpParser\Node\Expr\ArrayItem::class,
        \PhpParser\Node\Expr\Array_::class,
        \PhpParser\Node\Expr\ArrowFunction::class,
        \PhpParser\Node\Expr\Assign::class,
        \PhpParser\Node\Expr\AssignOp::class,
        \PhpParser\Node\Expr\AssignOp\BitwiseAnd::class,
        \PhpParser\Node\Expr\AssignOp\BitwiseOr::class,
        \PhpParser\Node\Expr\AssignOp\BitwiseXor::class,
        \PhpParser\Node\Expr\AssignOp\Coalesce::class,
        \PhpParser\Node\Expr\AssignOp\Concat::class,
        \PhpParser\Node\Expr\AssignOp\Div::class,
        \PhpParser\Node\Expr\AssignOp\Minus::class,
        \PhpParser\Node\Expr\AssignOp\Mod::class,
        \PhpParser\Node\Expr\AssignOp\Mul::class,
        \PhpParser\Node\Expr\AssignOp\Plus::class,
        \PhpParser\Node\Expr\AssignOp\Pow::class,
        \PhpParser\Node\Expr\AssignOp\ShiftLeft::class,
        \PhpParser\Node\Expr\AssignOp\ShiftRight::class,
        \PhpParser\Node\Expr\AssignRef::class,
        \PhpParser\Node\Expr\BinaryOp::class,
        \PhpParser\Node\Expr\BinaryOp\BitwiseAnd::class,
        \PhpParser\Node\Expr\BinaryOp\BitwiseOr::class,
        \PhpParser\Node\Expr\BinaryOp\BitwiseXor::class,
        \PhpParser\Node\Expr\BinaryOp\BooleanAnd::class,
        \PhpParser\Node\Expr\BinaryOp\BooleanOr::class,
        \PhpParser\Node\Expr\BinaryOp\Coalesce::class,
        \PhpParser\Node\Expr\BinaryOp\Concat::class,
        \PhpParser\Node\Expr\BinaryOp\Div::class,
        \PhpParser\Node\Expr\BinaryOp\Equal::class,
        \PhpParser\Node\Expr\BinaryOp\Greater::class,
        \PhpParser\Node\Expr\BinaryOp\GreaterOrEqual::class,
        \PhpParser\Node\Expr\BinaryOp\Identical::class,
        \PhpParser\Node\Expr\BinaryOp\LogicalAnd::class,
        \PhpParser\Node\Expr\BinaryOp\LogicalOr::class,
        \PhpParser\Node\Expr\BinaryOp\LogicalXor::class,
        \PhpParser\Node\Expr\BinaryOp\Minus::class,
        \PhpParser\Node\Expr\BinaryOp\Mod::class,
        \PhpParser\Node\Expr\BinaryOp\Mul::class,
        \PhpParser\Node\Expr\BinaryOp\NotEqual::class,
        \PhpParser\Node\Expr\BinaryOp\NotIdentical::class,
        \PhpParser\Node\Expr\BinaryOp\Plus::class,
        \PhpParser\Node\Expr\BinaryOp\Pow::class,
        \PhpParser\Node\Expr\BinaryOp\ShiftLeft::class,
        \PhpParser\Node\Expr\BinaryOp\ShiftRight::class,
        \PhpParser\Node\Expr\BinaryOp\Smaller::class,
        \PhpParser\Node\Expr\BinaryOp\SmallerOrEqual::class,
        \PhpParser\Node\Expr\BinaryOp\Spaceship::class,
        \PhpParser\Node\Expr\BitwiseNot::class,
        \PhpParser\Node\Expr\BooleanNot::class,
        \PhpParser\Node\Expr\CallLike::class,
        \PhpParser\Node\Expr\Cast::class,
        \PhpParser\Node\Expr\Cast\Array_::class,
        \PhpParser\Node\Expr\Cast\Bool_::class,
        \PhpParser\Node\Expr\Cast\Double::class,
        \PhpParser\Node\Expr\Cast\Int_::class,
        \PhpParser\Node\Expr\Cast\Object_::class,
        \PhpParser\Node\Expr\Cast\String_::class,
        \PhpParser\Node\Expr\Cast\Unset_::class,
        \PhpParser\Node\Expr\ClassConstFetch::class,
        \PhpParser\Node\Expr\Clone_::class,
        \PhpParser\Node\Expr\Closure::class,
        \PhpParser\Node\Expr\ClosureUse::class,
        \PhpParser\Node\Expr\ConstFetch::class,
        \PhpParser\Node\Expr\Empty_::class,
        \PhpParser\Node\Expr\Error::class,
        \PhpParser\Node\Expr\ErrorSuppress::class,
        \PhpParser\Node\Expr\Eval_::class,
        \PhpParser\Node\Expr\Exit_::class,
        \PhpParser\Node\Expr\FuncCall::class,
        \PhpParser\Node\Expr\Include_::class,
        \PhpParser\Node\Expr\Instanceof_::class,
        \PhpParser\Node\Expr\Isset_::class,
        \PhpParser\Node\Expr\List_::class,
        \PhpParser\Node\Expr\Match_::class,
        \PhpParser\Node\Expr\MethodCall::class,
        \PhpParser\Node\Expr\New_::class,
        \PhpParser\Node\Expr\NullsafeMethodCall::class,
        \PhpParser\Node\Expr\NullsafePropertyFetch::class,
        \PhpParser\Node\Expr\PostDec::class,
        \PhpParser\Node\Expr\PostInc::class,
        \PhpParser\Node\Expr\PreDec::class,
        \PhpParser\Node\Expr\PreInc::class,
        \PhpParser\Node\Expr\Print_::class,
        \PhpParser\Node\Expr\PropertyFetch::class,
        \PhpParser\Node\Expr\ShellExec::class,
        \PhpParser\Node\Expr\StaticCall::class,
        \PhpParser\Node\Expr\StaticPropertyFetch::class,
        \PhpParser\Node\Expr\Ternary::class,
        \PhpParser\Node\Expr\Throw_::class,
        \PhpParser\Node\Expr\UnaryMinus::class,
        \PhpParser\Node\Expr\UnaryPlus::class,
        \PhpParser\Node\Expr\Variable::class,
        \PhpParser\Node\Expr\YieldFrom::class,
        \PhpParser\Node\Expr\Yield_::class,
        \PhpParser\Node\FunctionLike::class,
        \PhpParser\Node\Identifier::class,
        \PhpParser\Node\InterpolatedStringPart::class,
        \PhpParser\Node\IntersectionType::class,
        \PhpParser\Node\MatchArm::class,
        \PhpParser\Node\Name::class,
        \PhpParser\Node\Name\FullyQualified::class,
        \PhpParser\Node\Name\Relative::class,
        \PhpParser\Node\NullableType::class,
        \PhpParser\Node\Param::class,
        \PhpParser\Node\PropertyHook::class,
        \PhpParser\Node\PropertyItem::class,
        \PhpParser\Node\Scalar::class,
        \PhpParser\Node\Scalar\DNumber::class,
        \PhpParser\Node\Scalar\Encapsed::class,
        \PhpParser\Node\Scalar\EncapsedStringPart::class,
        \PhpParser\Node\Scalar\Float_::class,
        \PhpParser\Node\Scalar\Int_::class,
        \PhpParser\Node\Scalar\InterpolatedString::class,
        \PhpParser\Node\Scalar\LNumber::class,
        \PhpParser\Node\Scalar\MagicConst::class,
        \PhpParser\Node\Scalar\MagicConst\Class_::class,
        \PhpParser\Node\Scalar\MagicConst\Dir::class,
        \PhpParser\Node\Scalar\MagicConst\File::class,
        \PhpParser\Node\Scalar\MagicConst\Function_::class,
        \PhpParser\Node\Scalar\MagicConst\Line::class,
        \PhpParser\Node\Scalar\MagicConst\Method::class,
        \PhpParser\Node\Scalar\MagicConst\Namespace_::class,
        \PhpParser\Node\Scalar\MagicConst\Property::class,
        \PhpParser\Node\Scalar\MagicConst\Trait_::class,
        \PhpParser\Node\Scalar\String_::class,
        \PhpParser\Node\StaticVar::class,
        \PhpParser\Node\Stmt::class,
        \PhpParser\Node\Stmt\Block::class,
        \PhpParser\Node\Stmt\Break_::class,
        \PhpParser\Node\Stmt\Case_::class,
        \PhpParser\Node\Stmt\Catch_::class,
        \PhpParser\Node\Stmt\ClassConst::class,
        \PhpParser\Node\Stmt\ClassLike::class,
        \PhpParser\Node\Stmt\ClassMethod::class,
        \PhpParser\Node\Stmt\Class_::class,
        \PhpParser\Node\Stmt\Const_::class,
        \PhpParser\Node\Stmt\Continue_::class,
        \PhpParser\Node\Stmt\DeclareDeclare::class,
        \PhpParser\Node\Stmt\Declare_::class,
        \PhpParser\Node\Stmt\Do_::class,
        \PhpParser\Node\Stmt\Echo_::class,
        \PhpParser\Node\Stmt\ElseIf_::class,
        \PhpParser\Node\Stmt\Else_::class,
        \PhpParser\Node\Stmt\EnumCase::class,
        \PhpParser\Node\Stmt\Enum_::class,
        \PhpParser\Node\Stmt\Expression::class,
        \PhpParser\Node\Stmt\Finally_::class,
        \PhpParser\Node\Stmt\For_::class,
        \PhpParser\Node\Stmt\Foreach_::class,
        \PhpParser\Node\Stmt\Function_::class,
        \PhpParser\Node\Stmt\Global_::class,
        \PhpParser\Node\Stmt\Goto_::class,
        \PhpParser\Node\Stmt\GroupUse::class,
        \PhpParser\Node\Stmt\HaltCompiler::class,
        \PhpParser\Node\Stmt\If_::class,
        \PhpParser\Node\Stmt\InlineHTML::class,
        \PhpParser\Node\Stmt\Interface_::class,
        \PhpParser\Node\Stmt\Label::class,
        \PhpParser\Node\Stmt\Namespace_::class,
        \PhpParser\Node\Stmt\Nop::class,
        \PhpParser\Node\Stmt\Property::class,
        \PhpParser\Node\Stmt\PropertyProperty::class,
        \PhpParser\Node\Stmt\Return_::class,
        \PhpParser\Node\Stmt\StaticVar::class,
        \PhpParser\Node\Stmt\Static_::class,
        \PhpParser\Node\Stmt\Switch_::class,
        \PhpParser\Node\Stmt\TraitUse::class,
        \PhpParser\Node\Stmt\TraitUseAdaptation::class,
        \PhpParser\Node\Stmt\TraitUseAdaptation\Alias::class,
        \PhpParser\Node\Stmt\TraitUseAdaptation\Precedence::class,
        \PhpParser\Node\Stmt\Trait_::class,
        \PhpParser\Node\Stmt\TryCatch::class,
        \PhpParser\Node\Stmt\Unset_::class,
        \PhpParser\Node\Stmt\UseUse::class,
        \PhpParser\Node\Stmt\Use_::class,
        \PhpParser\Node\Stmt\While_::class,
        \PhpParser\Node\UnionType::class,
        \PhpParser\Node\UseItem::class,
        \PhpParser\Node\VarLikeIdentifier::class,
        \PhpParser\Node\VariadicPlaceholder::class,
        \PhpParser\Parser::class,
        \PhpParser\ParserAbstract::class,
        \PhpParser\ParserFactory::class,
        \PhpParser\Parser\Php7::class,
        \PhpParser\Parser\Php8::class,
        \PhpParser\PhpVersion::class,
        \PhpParser\PrettyPrinter::class,
        \PhpParser\PrettyPrinterAbstract::class,
        \PhpParser\PrettyPrinter\Standard::class,
        \PhpParser\Token::class,
        \Psalm\Aliases::class,
        \Psalm\CodeLocation::class,
        \Psalm\CodeLocation\DocblockTypeLocation::class,
        \Psalm\CodeLocation\ParseErrorLocation::class,
        \Psalm\CodeLocation\Raw::class,
        \Psalm\Codebase::class,
        \Psalm\Config::class,
        \Psalm\Config\Creator::class,
        \Psalm\Config\ErrorLevelFileFilter::class,
        \Psalm\Config\FileFilter::class,
        \Psalm\Config\IssueHandler::class,
        \Psalm\Config\ProjectFileFilter::class,
        \Psalm\Config\TaintAnalysisFileFilter::class,
        \Psalm\Context::class,
        \Psalm\DocComment::class,
        \Psalm\ErrorBaseline::class,
        \Psalm\Exception\CircularReferenceException::class,
        \Psalm\Exception\CodeException::class,
        \Psalm\Exception\ComplicatedExpressionException::class,
        \Psalm\Exception\ConfigCreationException::class,
        \Psalm\Exception\ConfigException::class,
        \Psalm\Exception\ConfigNotFoundException::class,
        \Psalm\Exception\DocblockParseException::class,
        \Psalm\Exception\FileIncludeException::class,
        \Psalm\Exception\IncorrectDocblockException::class,
        \Psalm\Exception\InvalidClasslikeOverrideException::class,
        \Psalm\Exception\InvalidMethodOverrideException::class,
        \Psalm\Exception\RefactorException::class,
        \Psalm\Exception\ScopeAnalysisException::class,
        \Psalm\Exception\TypeParseTreeException::class,
        \Psalm\Exception\UnanalyzedFileException::class,
        \Psalm\Exception\UnpopulatedClasslikeException::class,
        \Psalm\Exception\UnpreparedAnalysisException::class,
        \Psalm\Exception\UnresolvableConstantException::class,
        \Psalm\Exception\UnsupportedIssueToFixException::class,
        \Psalm\FileBasedPluginAdapter::class,
        \Psalm\FileManipulation::class,
        \Psalm\FileSource::class,
        \Psalm\Internal\Algebra::class,
        \Psalm\Internal\Algebra\FormulaGenerator::class,
        \Psalm\Internal\Analyzer\AlgebraAnalyzer::class,
        \Psalm\Internal\Analyzer\AttributesAnalyzer::class,
        \Psalm\Internal\Analyzer\CanAlias::class,
        \Psalm\Internal\Analyzer\ClassAnalyzer::class,
        \Psalm\Internal\Analyzer\ClassLikeAnalyzer::class,
        \Psalm\Internal\Analyzer\ClassLikeNameOptions::class,
        \Psalm\Internal\Analyzer\ClosureAnalyzer::class,
        \Psalm\Internal\Analyzer\CommentAnalyzer::class,
        \Psalm\Internal\Analyzer\DataFlowNodeData::class,
        \Psalm\Internal\Analyzer\FileAnalyzer::class,
        \Psalm\Internal\Analyzer\FunctionAnalyzer::class,
        \Psalm\Internal\Analyzer\FunctionLikeAnalyzer::class,
        \Psalm\Internal\Analyzer\FunctionLike\ReturnTypeAnalyzer::class,
        \Psalm\Internal\Analyzer\FunctionLike\ReturnTypeCollector::class,
        \Psalm\Internal\Analyzer\InterfaceAnalyzer::class,
        \Psalm\Internal\Analyzer\IssueData::class,
        \Psalm\Internal\Analyzer\MethodAnalyzer::class,
        \Psalm\Internal\Analyzer\MethodComparator::class,
        \Psalm\Internal\Analyzer\NamespaceAnalyzer::class,
        \Psalm\Internal\Analyzer\ProjectAnalyzer::class,
        \Psalm\Internal\Analyzer\ScopeAnalyzer::class,
        \Psalm\Internal\Analyzer\SourceAnalyzer::class,
        \Psalm\Internal\Analyzer\StatementsAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Block\DoAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Block\ForAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Block\ForeachAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Block\IfConditionalAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Block\IfElseAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Block\IfElse\ElseAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Block\IfElse\ElseIfAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Block\IfElse\IfAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Block\LoopAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Block\SwitchAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Block\SwitchCaseAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Block\TryAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Block\WhileAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\BreakAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\ContinueAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\DeclareAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\EchoAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\ExpressionAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\ArrayAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\ArrayCreationInfo::class,
        \Psalm\Internal\Analyzer\Statements\Expression\AssertionFinder::class,
        \Psalm\Internal\Analyzer\Statements\Expression\AssignmentAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Assignment\ArrayAssignmentAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Assignment\AssignedProperty::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Assignment\InstancePropertyAssignmentAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Assignment\StaticPropertyAssignmentAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\BinaryOpAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\BinaryOp\AndAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\BinaryOp\ArithmeticOpAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\BinaryOp\CoalesceAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\BinaryOp\ConcatAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\BinaryOp\NonComparisonOpAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\BinaryOp\OrAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\BitwiseNotAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\BooleanNotAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\CallAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\ArgumentAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\ArgumentMapPopulator::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\ArgumentsAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\ArrayFunctionArgumentsAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\ClassTemplateParamCollector::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\FunctionCallAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\FunctionCallInfo::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\FunctionCallReturnTypeFetcher::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\HighOrderFunctionArgHandler::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\HighOrderFunctionArgInfo::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\MethodCallAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\Method\AtomicCallContext::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\Method\AtomicMethodCallAnalysisResult::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\Method\AtomicMethodCallAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\Method\ExistingAtomicMethodCallAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\Method\MethodCallProhibitionAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\Method\MethodCallPurityAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\Method\MethodCallReturnTypeFetcher::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\Method\MethodVisibilityAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\Method\MissingMethodCallHandler::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\NamedFunctionCallHandler::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\NewAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\StaticCallAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\StaticMethod\AtomicStaticCallAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Call\StaticMethod\ExistingAtomicStaticCallAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\CastAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\ClassConstAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\CloneAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\EmptyAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\EncapsulatedStringAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\EvalAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\ExitAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\ExpressionIdentifier::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Fetch\ArrayFetchAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Fetch\AtomicPropertyFetchAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Fetch\ConstFetchAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Fetch\InstancePropertyFetchAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Fetch\StaticPropertyFetchAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\Fetch\VariableFetchAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\IncDecExpressionAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\IncludeAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\InstanceofAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\IssetAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\MagicConstAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\MatchAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\NullsafeAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\PrintAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\SimpleTypeInferer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\TernaryAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\ThrowAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\UnaryPlusMinusAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\YieldAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\Expression\YieldFromAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\GlobalAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\ReturnAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\StaticAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\UnsetAnalyzer::class,
        \Psalm\Internal\Analyzer\Statements\UnusedAssignmentRemover::class,
        \Psalm\Internal\Analyzer\TraitAnalyzer::class,
        \Psalm\Internal\Analyzer\TypeAnalyzer::class,
        \Psalm\Internal\Cache::class,
        \Psalm\Internal\Clause::class,
        \Psalm\Internal\CliUtils::class,
        \Psalm\Internal\Cli\LanguageServer::class,
        \Psalm\Internal\Cli\Plugin::class,
        \Psalm\Internal\Cli\Psalm::class,
        \Psalm\Internal\Cli\Psalter::class,
        \Psalm\Internal\Cli\Refactor::class,
        \Psalm\Internal\Cli\Review::class,
        \Psalm\Internal\Codebase\Analyzer::class,
        \Psalm\Internal\Codebase\AssertionsFromInheritanceResolver::class,
        \Psalm\Internal\Codebase\ClassConstantByWildcardResolver::class,
        \Psalm\Internal\Codebase\ClassLikes::class,
        \Psalm\Internal\Codebase\ConstantTypeResolver::class,
        \Psalm\Internal\Codebase\DataFlowGraph::class,
        \Psalm\Internal\Codebase\Functions::class,
        \Psalm\Internal\Codebase\ImpureFunctionsList::class,
        \Psalm\Internal\Codebase\InternalCallMapHandler::class,
        \Psalm\Internal\Codebase\Methods::class,
        \Psalm\Internal\Codebase\Populator::class,
        \Psalm\Internal\Codebase\Properties::class,
        \Psalm\Internal\Codebase\PropertyMap::class,
        \Psalm\Internal\Codebase\ReferenceMapGenerator::class,
        \Psalm\Internal\Codebase\Reflection::class,
        \Psalm\Internal\Codebase\Scanner::class,
        \Psalm\Internal\Codebase\StorageByPatternResolver::class,
        \Psalm\Internal\Codebase\TaintFlowGraph::class,
        \Psalm\Internal\Codebase\VariableUseGraph::class,
        \Psalm\Internal\Composer::class,
        \Psalm\Internal\DataFlow\DataFlowNode::class,
        \Psalm\Internal\DataFlow\Path::class,
        \Psalm\Internal\Diff\AstDiffer::class,
        \Psalm\Internal\Diff\ClassStatementsDiffer::class,
        \Psalm\Internal\Diff\DiffElem::class,
        \Psalm\Internal\Diff\FileDiffer::class,
        \Psalm\Internal\Diff\FileStatementsDiffer::class,
        \Psalm\Internal\Diff\NamespaceStatementsDiffer::class,
        \Psalm\Internal\ErrorHandler::class,
        \Psalm\Internal\EventDispatcher::class,
        \Psalm\Internal\ExecutionEnvironment\BuildInfoCollector::class,
        \Psalm\Internal\ExecutionEnvironment\GitInfoCollector::class,
        \Psalm\Internal\ExecutionEnvironment\SystemCommandExecutor::class,
        \Psalm\Internal\FileManipulation\ClassDocblockManipulator::class,
        \Psalm\Internal\FileManipulation\CodeMigration::class,
        \Psalm\Internal\FileManipulation\FileManipulationBuffer::class,
        \Psalm\Internal\FileManipulation\FunctionDocblockManipulator::class,
        \Psalm\Internal\FileManipulation\PropertyDocblockManipulator::class,
        \Psalm\Internal\Fork\AnalyzerTask::class,
        \Psalm\Internal\Fork\ForkContext::class,
        \Psalm\Internal\Fork\IgbinarySerializer::class,
        \Psalm\Internal\Fork\InitAnalyzerTask::class,
        \Psalm\Internal\Fork\InitScannerTask::class,
        \Psalm\Internal\Fork\Pool::class,
        \Psalm\Internal\Fork\PsalmRestarter::class,
        \Psalm\Internal\Fork\ScannerTask::class,
        \Psalm\Internal\Fork\ShutdownAnalyzerTask::class,
        \Psalm\Internal\Fork\ShutdownScannerTask::class,
        \Psalm\Internal\GzipSerializer::class,
        \Psalm\Internal\IncludeCollector::class,
        \Psalm\Internal\Json\Json::class,
        \Psalm\Internal\LanguageServer\ClientConfiguration::class,
        \Psalm\Internal\LanguageServer\ClientHandler::class,
        \Psalm\Internal\LanguageServer\Client\Progress\LegacyProgress::class,
        \Psalm\Internal\LanguageServer\Client\Progress\Progress::class,
        \Psalm\Internal\LanguageServer\Client\Progress\ProgressInterface::class,
        \Psalm\Internal\LanguageServer\Client\TextDocument::class,
        \Psalm\Internal\LanguageServer\Client\Workspace::class,
        \Psalm\Internal\LanguageServer\EmitterInterface::class,
        \Psalm\Internal\LanguageServer\EmitterTrait::class,
        \Psalm\Internal\LanguageServer\IdGenerator::class,
        \Psalm\Internal\LanguageServer\LanguageClient::class,
        \Psalm\Internal\LanguageServer\LanguageServer::class,
        \Psalm\Internal\LanguageServer\Message::class,
        \Psalm\Internal\LanguageServer\PHPMarkdownContent::class,
        \Psalm\Internal\LanguageServer\PathMapper::class,
        \Psalm\Internal\LanguageServer\Progress::class,
        \Psalm\Internal\LanguageServer\ProtocolReader::class,
        \Psalm\Internal\LanguageServer\ProtocolStreamReader::class,
        \Psalm\Internal\LanguageServer\ProtocolStreamWriter::class,
        \Psalm\Internal\LanguageServer\ProtocolWriter::class,
        \Psalm\Internal\LanguageServer\Provider\InMemoryProjectCacheProvider::class,
        \Psalm\Internal\LanguageServer\Reference::class,
        \Psalm\Internal\LanguageServer\Server\TextDocument::class,
        \Psalm\Internal\LanguageServer\Server\Workspace::class,
        \Psalm\Internal\Lz4Serializer::class,
        \Psalm\Internal\MethodIdentifier::class,
        \Psalm\Internal\PhpTraverser\CustomTraverser::class,
        \Psalm\Internal\PhpVisitor\AssignmentMapVisitor::class,
        \Psalm\Internal\PhpVisitor\CheckTrivialExprVisitor::class,
        \Psalm\Internal\PhpVisitor\CloningVisitor::class,
        \Psalm\Internal\PhpVisitor\ConditionCloningVisitor::class,
        \Psalm\Internal\PhpVisitor\NodeCleanerVisitor::class,
        \Psalm\Internal\PhpVisitor\NodeCounterVisitor::class,
        \Psalm\Internal\PhpVisitor\OffsetShifterVisitor::class,
        \Psalm\Internal\PhpVisitor\ParamReplacementVisitor::class,
        \Psalm\Internal\PhpVisitor\PartialParserVisitor::class,
        \Psalm\Internal\PhpVisitor\ReflectorVisitor::class,
        \Psalm\Internal\PhpVisitor\Reflector\AttributeResolver::class,
        \Psalm\Internal\PhpVisitor\Reflector\ClassLikeDocblockParser::class,
        \Psalm\Internal\PhpVisitor\Reflector\ClassLikeNodeScanner::class,
        \Psalm\Internal\PhpVisitor\Reflector\ExpressionResolver::class,
        \Psalm\Internal\PhpVisitor\Reflector\ExpressionScanner::class,
        \Psalm\Internal\PhpVisitor\Reflector\FunctionLikeDocblockParser::class,
        \Psalm\Internal\PhpVisitor\Reflector\FunctionLikeDocblockScanner::class,
        \Psalm\Internal\PhpVisitor\Reflector\FunctionLikeNodeScanner::class,
        \Psalm\Internal\PhpVisitor\Reflector\TypeHintResolver::class,
        \Psalm\Internal\PhpVisitor\ShortClosureVisitor::class,
        \Psalm\Internal\PhpVisitor\SimpleNameResolver::class,
        \Psalm\Internal\PhpVisitor\TraitFinder::class,
        \Psalm\Internal\PhpVisitor\TypeMappingVisitor::class,
        \Psalm\Internal\PhpVisitor\YieldTypeCollector::class,
        \Psalm\Internal\PluginManager\Command\DisableCommand::class,
        \Psalm\Internal\PluginManager\Command\EnableCommand::class,
        \Psalm\Internal\PluginManager\Command\ShowCommand::class,
        \Psalm\Internal\PluginManager\ComposerLock::class,
        \Psalm\Internal\PluginManager\ConfigFile::class,
        \Psalm\Internal\PluginManager\PluginList::class,
        \Psalm\Internal\PluginManager\PluginListFactory::class,
        \Psalm\Internal\Preloader::class,
        \Psalm\Internal\PreloaderList::class,
        \Psalm\Internal\Provider\AddRemoveTaints\HtmlFunctionTainter::class,
        \Psalm\Internal\Provider\ClassLikeStorageCacheProvider::class,
        \Psalm\Internal\Provider\ClassLikeStorageProvider::class,
        \Psalm\Internal\Provider\DynamicFunctionStorageProvider::class,
        \Psalm\Internal\Provider\FakeFileProvider::class,
        \Psalm\Internal\Provider\FileProvider::class,
        \Psalm\Internal\Provider\FileReferenceCacheProvider::class,
        \Psalm\Internal\Provider\FileReferenceProvider::class,
        \Psalm\Internal\Provider\FileStorageCacheProvider::class,
        \Psalm\Internal\Provider\FileStorageProvider::class,
        \Psalm\Internal\Provider\FunctionExistenceProvider::class,
        \Psalm\Internal\Provider\FunctionParamsProvider::class,
        \Psalm\Internal\Provider\FunctionReturnTypeProvider::class,
        \Psalm\Internal\Provider\MethodExistenceProvider::class,
        \Psalm\Internal\Provider\MethodParamsProvider::class,
        \Psalm\Internal\Provider\MethodReturnTypeProvider::class,
        \Psalm\Internal\Provider\MethodVisibilityProvider::class,
        \Psalm\Internal\Provider\NodeDataProvider::class,
        \Psalm\Internal\Provider\ParamsProvider\ArrayFilterParamsProvider::class,
        \Psalm\Internal\Provider\ParamsProvider\ArrayMultisortParamsProvider::class,
        \Psalm\Internal\Provider\ParamsProvider\ArrayUArrayParamsProvider::class,
        \Psalm\Internal\Provider\ParserCacheProvider::class,
        \Psalm\Internal\Provider\ProjectCacheProvider::class,
        \Psalm\Internal\Provider\PropertyExistenceProvider::class,
        \Psalm\Internal\Provider\PropertyTypeProvider::class,
        \Psalm\Internal\Provider\PropertyTypeProvider\DomDocumentPropertyTypeProvider::class,
        \Psalm\Internal\Provider\PropertyVisibilityProvider::class,
        \Psalm\Internal\Provider\Providers::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\ArrayChunkReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\ArrayColumnReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\ArrayCombineReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\ArrayFillKeysReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\ArrayFillReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\ArrayFilterReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\ArrayMapReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\ArrayMergeReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\ArrayPadReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\ArrayPointerAdjustmentReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\ArrayPopReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\ArrayRandReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\ArrayReduceReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\ArrayReverseReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\ArraySliceReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\ArraySpliceReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\BasenameReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\ClosureFromCallableReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\DateReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\DateTimeModifyReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\DirnameReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\DomNodeAppendChild::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\FilterInputReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\FilterUtils::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\FilterVarReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\FirstArgStringReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\GetClassMethodsReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\GetObjectVarsReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\HexdecReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\ImagickPixelColorReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\InArrayReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\IteratorToArrayReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\MbInternalEncodingReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\MinMaxReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\MktimeReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\ParseUrlReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\PdoStatementReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\PdoStatementSetFetchMode::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\PowReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\RandReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\RoundReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\SprintfReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\StrReplaceReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\StrTrReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\TriggerErrorReturnTypeProvider::class,
        \Psalm\Internal\Provider\ReturnTypeProvider\VersionCompareReturnTypeProvider::class,
        \Psalm\Internal\Provider\StatementsProvider::class,
        \Psalm\Internal\ReferenceConstraint::class,
        \Psalm\Internal\RuntimeCaches::class,
        \Psalm\Internal\Scanner\ClassLikeDocblockComment::class,
        \Psalm\Internal\Scanner\DocblockParser::class,
        \Psalm\Internal\Scanner\FileScanner::class,
        \Psalm\Internal\Scanner\FunctionDocblockComment::class,
        \Psalm\Internal\Scanner\ParsedDocblock::class,
        \Psalm\Internal\Scanner\PhpStormMetaScanner::class,
        \Psalm\Internal\Scanner\UnresolvedConstantComponent::class,
        \Psalm\Internal\Scanner\UnresolvedConstant\ArrayOffsetFetch::class,
        \Psalm\Internal\Scanner\UnresolvedConstant\ArraySpread::class,
        \Psalm\Internal\Scanner\UnresolvedConstant\ArrayValue::class,
        \Psalm\Internal\Scanner\UnresolvedConstant\ClassConstant::class,
        \Psalm\Internal\Scanner\UnresolvedConstant\Constant::class,
        \Psalm\Internal\Scanner\UnresolvedConstant\EnumNameFetch::class,
        \Psalm\Internal\Scanner\UnresolvedConstant\EnumPropertyFetch::class,
        \Psalm\Internal\Scanner\UnresolvedConstant\EnumValueFetch::class,
        \Psalm\Internal\Scanner\UnresolvedConstant\KeyValuePair::class,
        \Psalm\Internal\Scanner\UnresolvedConstant\ScalarValue::class,
        \Psalm\Internal\Scanner\UnresolvedConstant\UnresolvedAdditionOp::class,
        \Psalm\Internal\Scanner\UnresolvedConstant\UnresolvedBinaryOp::class,
        \Psalm\Internal\Scanner\UnresolvedConstant\UnresolvedBitwiseAnd::class,
        \Psalm\Internal\Scanner\UnresolvedConstant\UnresolvedBitwiseOr::class,
        \Psalm\Internal\Scanner\UnresolvedConstant\UnresolvedBitwiseXor::class,
        \Psalm\Internal\Scanner\UnresolvedConstant\UnresolvedConcatOp::class,
        \Psalm\Internal\Scanner\UnresolvedConstant\UnresolvedDivisionOp::class,
        \Psalm\Internal\Scanner\UnresolvedConstant\UnresolvedMultiplicationOp::class,
        \Psalm\Internal\Scanner\UnresolvedConstant\UnresolvedSubtractionOp::class,
        \Psalm\Internal\Scanner\UnresolvedConstant\UnresolvedTernary::class,
        \Psalm\Internal\Scanner\VarDocblockComment::class,
        \Psalm\Internal\Scope\CaseScope::class,
        \Psalm\Internal\Scope\FinallyScope::class,
        \Psalm\Internal\Scope\IfConditionalScope::class,
        \Psalm\Internal\Scope\IfScope::class,
        \Psalm\Internal\Scope\LoopScope::class,
        \Psalm\Internal\Scope\SwitchScope::class,
        \Psalm\Internal\Stubs\Generator\ClassLikeStubGenerator::class,
        \Psalm\Internal\Stubs\Generator\StubsGenerator::class,
        \Psalm\Internal\TypeVisitor\CanContainObjectTypeVisitor::class,
        \Psalm\Internal\TypeVisitor\ClasslikeReplacer::class,
        \Psalm\Internal\TypeVisitor\ContainsClassLikeVisitor::class,
        \Psalm\Internal\TypeVisitor\ContainsLiteralVisitor::class,
        \Psalm\Internal\TypeVisitor\ContainsStaticVisitor::class,
        \Psalm\Internal\TypeVisitor\FromDocblockSetter::class,
        \Psalm\Internal\TypeVisitor\TemplateTypeCollector::class,
        \Psalm\Internal\TypeVisitor\TypeChecker::class,
        \Psalm\Internal\TypeVisitor\TypeLocalizer::class,
        \Psalm\Internal\TypeVisitor\TypeScanner::class,
        \Psalm\Internal\Type\ArrayType::class,
        \Psalm\Internal\Type\AssertionReconciler::class,
        \Psalm\Internal\Type\ClosedInheritanceToUnion::class,
        \Psalm\Internal\Type\Comparator\ArrayTypeComparator::class,
        \Psalm\Internal\Type\Comparator\AtomicTypeComparator::class,
        \Psalm\Internal\Type\Comparator\CallableTypeComparator::class,
        \Psalm\Internal\Type\Comparator\ClassLikeStringComparator::class,
        \Psalm\Internal\Type\Comparator\GenericTypeComparator::class,
        \Psalm\Internal\Type\Comparator\IntegerRangeComparator::class,
        \Psalm\Internal\Type\Comparator\KeyedArrayComparator::class,
        \Psalm\Internal\Type\Comparator\ObjectComparator::class,
        \Psalm\Internal\Type\Comparator\ScalarTypeComparator::class,
        \Psalm\Internal\Type\Comparator\TypeComparisonResult::class,
        \Psalm\Internal\Type\Comparator\UnionTypeComparator::class,
        \Psalm\Internal\Type\NegatedAssertionReconciler::class,
        \Psalm\Internal\Type\ParseTree::class,
        \Psalm\Internal\Type\ParseTreeCreator::class,
        \Psalm\Internal\Type\ParseTree\CallableParamTree::class,
        \Psalm\Internal\Type\ParseTree\CallableTree::class,
        \Psalm\Internal\Type\ParseTree\CallableWithReturnTypeTree::class,
        \Psalm\Internal\Type\ParseTree\ConditionalTree::class,
        \Psalm\Internal\Type\ParseTree\EncapsulationTree::class,
        \Psalm\Internal\Type\ParseTree\FieldEllipsis::class,
        \Psalm\Internal\Type\ParseTree\GenericTree::class,
        \Psalm\Internal\Type\ParseTree\IndexedAccessTree::class,
        \Psalm\Internal\Type\ParseTree\IntersectionTree::class,
        \Psalm\Internal\Type\ParseTree\KeyedArrayPropertyTree::class,
        \Psalm\Internal\Type\ParseTree\KeyedArrayTree::class,
        \Psalm\Internal\Type\ParseTree\MethodParamTree::class,
        \Psalm\Internal\Type\ParseTree\MethodTree::class,
        \Psalm\Internal\Type\ParseTree\MethodWithReturnTypeTree::class,
        \Psalm\Internal\Type\ParseTree\NullableTree::class,
        \Psalm\Internal\Type\ParseTree\Root::class,
        \Psalm\Internal\Type\ParseTree\TemplateAsTree::class,
        \Psalm\Internal\Type\ParseTree\TemplateIsTree::class,
        \Psalm\Internal\Type\ParseTree\UnionTree::class,
        \Psalm\Internal\Type\ParseTree\Value::class,
        \Psalm\Internal\Type\SimpleAssertionReconciler::class,
        \Psalm\Internal\Type\SimpleNegatedAssertionReconciler::class,
        \Psalm\Internal\Type\TemplateBound::class,
        \Psalm\Internal\Type\TemplateInferredTypeReplacer::class,
        \Psalm\Internal\Type\TemplateResult::class,
        \Psalm\Internal\Type\TemplateStandinTypeReplacer::class,
        \Psalm\Internal\Type\TypeAlias::class,
        \Psalm\Internal\Type\TypeAlias\ClassTypeAlias::class,
        \Psalm\Internal\Type\TypeAlias\InlineTypeAlias::class,
        \Psalm\Internal\Type\TypeAlias\LinkableTypeAlias::class,
        \Psalm\Internal\Type\TypeCombination::class,
        \Psalm\Internal\Type\TypeCombiner::class,
        \Psalm\Internal\Type\TypeExpander::class,
        \Psalm\Internal\Type\TypeParser::class,
        \Psalm\Internal\Type\TypeTokenizer::class,
        \Psalm\Internal\VersionUtils::class,
        \Psalm\IssueBuffer::class,
        \Psalm\Issue\AbstractInstantiation::class,
        \Psalm\Issue\AbstractMethodCall::class,
        \Psalm\Issue\AmbiguousConstantInheritance::class,
        \Psalm\Issue\ArgumentIssue::class,
        \Psalm\Issue\ArgumentTypeCoercion::class,
        \Psalm\Issue\AssignmentToVoid::class,
        \Psalm\Issue\CheckType::class,
        \Psalm\Issue\CircularReference::class,
        \Psalm\Issue\ClassConstantIssue::class,
        \Psalm\Issue\ClassIssue::class,
        \Psalm\Issue\ClassMustBeFinal::class,
        \Psalm\Issue\CodeIssue::class,
        \Psalm\Issue\ComplexFunction::class,
        \Psalm\Issue\ComplexMethod::class,
        \Psalm\Issue\ConfigIssue::class,
        \Psalm\Issue\ConflictingReferenceConstraint::class,
        \Psalm\Issue\ConstantDeclarationInTrait::class,
        \Psalm\Issue\ConstructorSignatureMismatch::class,
        \Psalm\Issue\ContinueOutsideLoop::class,
        \Psalm\Issue\DeprecatedClass::class,
        \Psalm\Issue\DeprecatedConstant::class,
        \Psalm\Issue\DeprecatedFunction::class,
        \Psalm\Issue\DeprecatedInterface::class,
        \Psalm\Issue\DeprecatedMethod::class,
        \Psalm\Issue\DeprecatedProperty::class,
        \Psalm\Issue\DeprecatedTrait::class,
        \Psalm\Issue\DirectConstructorCall::class,
        \Psalm\Issue\DocblockTypeContradiction::class,
        \Psalm\Issue\DuplicateArrayKey::class,
        \Psalm\Issue\DuplicateClass::class,
        \Psalm\Issue\DuplicateConstant::class,
        \Psalm\Issue\DuplicateEnumCase::class,
        \Psalm\Issue\DuplicateEnumCaseValue::class,
        \Psalm\Issue\DuplicateFunction::class,
        \Psalm\Issue\DuplicateMethod::class,
        \Psalm\Issue\DuplicateParam::class,
        \Psalm\Issue\DuplicateProperty::class,
        \Psalm\Issue\EmptyArrayAccess::class,
        \Psalm\Issue\ExtensionRequirementViolation::class,
        \Psalm\Issue\FalsableReturnStatement::class,
        \Psalm\Issue\FalseOperand::class,
        \Psalm\Issue\ForbiddenCode::class,
        \Psalm\Issue\FunctionIssue::class,
        \Psalm\Issue\IfThisIsMismatch::class,
        \Psalm\Issue\ImplementationRequirementViolation::class,
        \Psalm\Issue\ImplementedParamTypeMismatch::class,
        \Psalm\Issue\ImplementedReturnTypeMismatch::class,
        \Psalm\Issue\ImplicitToStringCast::class,
        \Psalm\Issue\ImpureByReferenceAssignment::class,
        \Psalm\Issue\ImpureFunctionCall::class,
        \Psalm\Issue\ImpureMethodCall::class,
        \Psalm\Issue\ImpurePropertyAssignment::class,
        \Psalm\Issue\ImpurePropertyFetch::class,
        \Psalm\Issue\ImpureStaticProperty::class,
        \Psalm\Issue\ImpureStaticVariable::class,
        \Psalm\Issue\ImpureVariable::class,
        \Psalm\Issue\InaccessibleClassConstant::class,
        \Psalm\Issue\InaccessibleMethod::class,
        \Psalm\Issue\InaccessibleProperty::class,
        \Psalm\Issue\InheritorViolation::class,
        \Psalm\Issue\InterfaceInstantiation::class,
        \Psalm\Issue\InternalClass::class,
        \Psalm\Issue\InternalMethod::class,
        \Psalm\Issue\InternalProperty::class,
        \Psalm\Issue\InvalidArgument::class,
        \Psalm\Issue\InvalidArrayAccess::class,
        \Psalm\Issue\InvalidArrayAssignment::class,
        \Psalm\Issue\InvalidArrayOffset::class,
        \Psalm\Issue\InvalidAttribute::class,
        \Psalm\Issue\InvalidCast::class,
        \Psalm\Issue\InvalidCatch::class,
        \Psalm\Issue\InvalidClass::class,
        \Psalm\Issue\InvalidClassConstantType::class,
        \Psalm\Issue\InvalidClone::class,
        \Psalm\Issue\InvalidConstantAssignmentValue::class,
        \Psalm\Issue\InvalidDocblock::class,
        \Psalm\Issue\InvalidDocblockParamName::class,
        \Psalm\Issue\InvalidEnumBackingType::class,
        \Psalm\Issue\InvalidEnumCaseValue::class,
        \Psalm\Issue\InvalidEnumMethod::class,
        \Psalm\Issue\InvalidExtendClass::class,
        \Psalm\Issue\InvalidFalsableReturnType::class,
        \Psalm\Issue\InvalidFunctionCall::class,
        \Psalm\Issue\InvalidGlobal::class,
        \Psalm\Issue\InvalidInterfaceImplementation::class,
        \Psalm\Issue\InvalidIterator::class,
        \Psalm\Issue\InvalidLiteralArgument::class,
        \Psalm\Issue\InvalidMethodCall::class,
        \Psalm\Issue\InvalidNamedArgument::class,
        \Psalm\Issue\InvalidNullableReturnType::class,
        \Psalm\Issue\InvalidOperand::class,
        \Psalm\Issue\InvalidOverride::class,
        \Psalm\Issue\InvalidParamDefault::class,
        \Psalm\Issue\InvalidParent::class,
        \Psalm\Issue\InvalidPassByReference::class,
        \Psalm\Issue\InvalidPropertyAssignment::class,
        \Psalm\Issue\InvalidPropertyAssignmentValue::class,
        \Psalm\Issue\InvalidPropertyFetch::class,
        \Psalm\Issue\InvalidReturnStatement::class,
        \Psalm\Issue\InvalidReturnType::class,
        \Psalm\Issue\InvalidScalarArgument::class,
        \Psalm\Issue\InvalidScope::class,
        \Psalm\Issue\InvalidStaticInvocation::class,
        \Psalm\Issue\InvalidStringClass::class,
        \Psalm\Issue\InvalidTemplateParam::class,
        \Psalm\Issue\InvalidThrow::class,
        \Psalm\Issue\InvalidToString::class,
        \Psalm\Issue\InvalidTraversableImplementation::class,
        \Psalm\Issue\InvalidTypeImport::class,
        \Psalm\Issue\LessSpecificClassConstantType::class,
        \Psalm\Issue\LessSpecificImplementedReturnType::class,
        \Psalm\Issue\LessSpecificReturnStatement::class,
        \Psalm\Issue\LessSpecificReturnType::class,
        \Psalm\Issue\LiteralKeyUnshapedArray::class,
        \Psalm\Issue\LoopInvalidation::class,
        \Psalm\Issue\MethodIssue::class,
        \Psalm\Issue\MethodSignatureMismatch::class,
        \Psalm\Issue\MethodSignatureMustOmitReturnType::class,
        \Psalm\Issue\MethodSignatureMustProvideReturnType::class,
        \Psalm\Issue\MismatchingDocblockParamType::class,
        \Psalm\Issue\MismatchingDocblockPropertyType::class,
        \Psalm\Issue\MismatchingDocblockReturnType::class,
        \Psalm\Issue\MissingClassConstType::class,
        \Psalm\Issue\MissingClosureParamType::class,
        \Psalm\Issue\MissingClosureReturnType::class,
        \Psalm\Issue\MissingConstructor::class,
        \Psalm\Issue\MissingDependency::class,
        \Psalm\Issue\MissingDocblockType::class,
        \Psalm\Issue\MissingFile::class,
        \Psalm\Issue\MissingImmutableAnnotation::class,
        \Psalm\Issue\MissingOverrideAttribute::class,
        \Psalm\Issue\MissingParamType::class,
        \Psalm\Issue\MissingPropertyType::class,
        \Psalm\Issue\MissingReturnType::class,
        \Psalm\Issue\MissingTemplateParam::class,
        \Psalm\Issue\MissingThrowsDocblock::class,
        \Psalm\Issue\MixedArgument::class,
        \Psalm\Issue\MixedArgumentTypeCoercion::class,
        \Psalm\Issue\MixedArrayAccess::class,
        \Psalm\Issue\MixedArrayAssignment::class,
        \Psalm\Issue\MixedArrayOffset::class,
        \Psalm\Issue\MixedArrayTypeCoercion::class,
        \Psalm\Issue\MixedAssignment::class,
        \Psalm\Issue\MixedClone::class,
        \Psalm\Issue\MixedFunctionCall::class,
        \Psalm\Issue\MixedIssue::class,
        \Psalm\Issue\MixedIssueTrait::class,
        \Psalm\Issue\MixedMethodCall::class,
        \Psalm\Issue\MixedOperand::class,
        \Psalm\Issue\MixedPropertyAssignment::class,
        \Psalm\Issue\MixedPropertyFetch::class,
        \Psalm\Issue\MixedPropertyTypeCoercion::class,
        \Psalm\Issue\MixedReturnStatement::class,
        \Psalm\Issue\MixedReturnTypeCoercion::class,
        \Psalm\Issue\MixedStringOffsetAssignment::class,
        \Psalm\Issue\MoreSpecificImplementedParamType::class,
        \Psalm\Issue\MoreSpecificReturnType::class,
        \Psalm\Issue\MutableDependency::class,
        \Psalm\Issue\NamedArgumentNotAllowed::class,
        \Psalm\Issue\NoEnumProperties::class,
        \Psalm\Issue\NoInterfaceProperties::class,
        \Psalm\Issue\NoValue::class,
        \Psalm\Issue\NonInvariantDocblockPropertyType::class,
        \Psalm\Issue\NonInvariantPropertyType::class,
        \Psalm\Issue\NonStaticSelfCall::class,
        \Psalm\Issue\NonVariableReferenceReturn::class,
        \Psalm\Issue\NullArgument::class,
        \Psalm\Issue\NullArrayAccess::class,
        \Psalm\Issue\NullArrayOffset::class,
        \Psalm\Issue\NullFunctionCall::class,
        \Psalm\Issue\NullIterator::class,
        \Psalm\Issue\NullOperand::class,
        \Psalm\Issue\NullPropertyAssignment::class,
        \Psalm\Issue\NullPropertyFetch::class,
        \Psalm\Issue\NullReference::class,
        \Psalm\Issue\NullableReturnStatement::class,
        \Psalm\Issue\OverriddenFinalConstant::class,
        \Psalm\Issue\OverriddenInterfaceConstant::class,
        \Psalm\Issue\OverriddenMethodAccess::class,
        \Psalm\Issue\OverriddenPropertyAccess::class,
        \Psalm\Issue\ParadoxicalCondition::class,
        \Psalm\Issue\ParamNameMismatch::class,
        \Psalm\Issue\ParentNotFound::class,
        \Psalm\Issue\ParseError::class,
        \Psalm\Issue\PluginIssue::class,
        \Psalm\Issue\PossibleRawObjectIteration::class,
        \Psalm\Issue\PossiblyFalseArgument::class,
        \Psalm\Issue\PossiblyFalseIterator::class,
        \Psalm\Issue\PossiblyFalseOperand::class,
        \Psalm\Issue\PossiblyFalsePropertyAssignmentValue::class,
        \Psalm\Issue\PossiblyFalseReference::class,
        \Psalm\Issue\PossiblyInvalidArgument::class,
        \Psalm\Issue\PossiblyInvalidArrayAccess::class,
        \Psalm\Issue\PossiblyInvalidArrayAssignment::class,
        \Psalm\Issue\PossiblyInvalidArrayOffset::class,
        \Psalm\Issue\PossiblyInvalidCast::class,
        \Psalm\Issue\PossiblyInvalidClone::class,
        \Psalm\Issue\PossiblyInvalidDocblockTag::class,
        \Psalm\Issue\PossiblyInvalidFunctionCall::class,
        \Psalm\Issue\PossiblyInvalidIterator::class,
        \Psalm\Issue\PossiblyInvalidMethodCall::class,
        \Psalm\Issue\PossiblyInvalidOperand::class,
        \Psalm\Issue\PossiblyInvalidPropertyAssignment::class,
        \Psalm\Issue\PossiblyInvalidPropertyAssignmentValue::class,
        \Psalm\Issue\PossiblyInvalidPropertyFetch::class,
        \Psalm\Issue\PossiblyNullArgument::class,
        \Psalm\Issue\PossiblyNullArrayAccess::class,
        \Psalm\Issue\PossiblyNullArrayAssignment::class,
        \Psalm\Issue\PossiblyNullArrayOffset::class,
        \Psalm\Issue\PossiblyNullFunctionCall::class,
        \Psalm\Issue\PossiblyNullIterator::class,
        \Psalm\Issue\PossiblyNullOperand::class,
        \Psalm\Issue\PossiblyNullPropertyAssignment::class,
        \Psalm\Issue\PossiblyNullPropertyAssignmentValue::class,
        \Psalm\Issue\PossiblyNullPropertyFetch::class,
        \Psalm\Issue\PossiblyNullReference::class,
        \Psalm\Issue\PossiblyUndefinedArrayOffset::class,
        \Psalm\Issue\PossiblyUndefinedGlobalVariable::class,
        \Psalm\Issue\PossiblyUndefinedIntArrayOffset::class,
        \Psalm\Issue\PossiblyUndefinedMethod::class,
        \Psalm\Issue\PossiblyUndefinedStringArrayOffset::class,
        \Psalm\Issue\PossiblyUndefinedVariable::class,
        \Psalm\Issue\PossiblyUnusedMethod::class,
        \Psalm\Issue\PossiblyUnusedParam::class,
        \Psalm\Issue\PossiblyUnusedProperty::class,
        \Psalm\Issue\PossiblyUnusedReturnValue::class,
        \Psalm\Issue\PrivateFinalMethod::class,
        \Psalm\Issue\PropertyIssue::class,
        \Psalm\Issue\PropertyNotSetInConstructor::class,
        \Psalm\Issue\PropertyTypeCoercion::class,
        \Psalm\Issue\PsalmInternalError::class,
        \Psalm\Issue\RawObjectIteration::class,
        \Psalm\Issue\RedundantCast::class,
        \Psalm\Issue\RedundantCastGivenDocblockType::class,
        \Psalm\Issue\RedundantCondition::class,
        \Psalm\Issue\RedundantConditionGivenDocblockType::class,
        \Psalm\Issue\RedundantFlag::class,
        \Psalm\Issue\RedundantFunctionCall::class,
        \Psalm\Issue\RedundantFunctionCallGivenDocblockType::class,
        \Psalm\Issue\RedundantIdentityWithTrue::class,
        \Psalm\Issue\RedundantPropertyInitializationCheck::class,
        \Psalm\Issue\ReferenceConstraintViolation::class,
        \Psalm\Issue\ReferenceReusedFromConfusingScope::class,
        \Psalm\Issue\ReservedWord::class,
        \Psalm\Issue\RiskyCast::class,
        \Psalm\Issue\RiskyTruthyFalsyComparison::class,
        \Psalm\Issue\StringIncrement::class,
        \Psalm\Issue\TaintedCallable::class,
        \Psalm\Issue\TaintedCookie::class,
        \Psalm\Issue\TaintedCustom::class,
        \Psalm\Issue\TaintedEval::class,
        \Psalm\Issue\TaintedExtract::class,
        \Psalm\Issue\TaintedFile::class,
        \Psalm\Issue\TaintedHeader::class,
        \Psalm\Issue\TaintedHtml::class,
        \Psalm\Issue\TaintedInclude::class,
        \Psalm\Issue\TaintedInput::class,
        \Psalm\Issue\TaintedLdap::class,
        \Psalm\Issue\TaintedSSRF::class,
        \Psalm\Issue\TaintedShell::class,
        \Psalm\Issue\TaintedSleep::class,
        \Psalm\Issue\TaintedSql::class,
        \Psalm\Issue\TaintedSystemSecret::class,
        \Psalm\Issue\TaintedTextWithQuotes::class,
        \Psalm\Issue\TaintedUnserialize::class,
        \Psalm\Issue\TaintedUserSecret::class,
        \Psalm\Issue\TaintedXpath::class,
        \Psalm\Issue\TooFewArguments::class,
        \Psalm\Issue\TooManyArguments::class,
        \Psalm\Issue\TooManyTemplateParams::class,
        \Psalm\Issue\Trace::class,
        \Psalm\Issue\TraitMethodSignatureMismatch::class,
        \Psalm\Issue\TypeDoesNotContainNull::class,
        \Psalm\Issue\TypeDoesNotContainType::class,
        \Psalm\Issue\UncaughtThrowInGlobalScope::class,
        \Psalm\Issue\UndefinedAttributeClass::class,
        \Psalm\Issue\UndefinedClass::class,
        \Psalm\Issue\UndefinedConstant::class,
        \Psalm\Issue\UndefinedDocblockClass::class,
        \Psalm\Issue\UndefinedFunction::class,
        \Psalm\Issue\UndefinedGlobalVariable::class,
        \Psalm\Issue\UndefinedInterface::class,
        \Psalm\Issue\UndefinedInterfaceMethod::class,
        \Psalm\Issue\UndefinedMagicMethod::class,
        \Psalm\Issue\UndefinedMagicPropertyAssignment::class,
        \Psalm\Issue\UndefinedMagicPropertyFetch::class,
        \Psalm\Issue\UndefinedMethod::class,
        \Psalm\Issue\UndefinedPropertyAssignment::class,
        \Psalm\Issue\UndefinedPropertyFetch::class,
        \Psalm\Issue\UndefinedThisPropertyAssignment::class,
        \Psalm\Issue\UndefinedThisPropertyFetch::class,
        \Psalm\Issue\UndefinedTrace::class,
        \Psalm\Issue\UndefinedTrait::class,
        \Psalm\Issue\UndefinedVariable::class,
        \Psalm\Issue\UnevaluatedCode::class,
        \Psalm\Issue\UnhandledMatchCondition::class,
        \Psalm\Issue\UnimplementedAbstractMethod::class,
        \Psalm\Issue\UnimplementedInterfaceMethod::class,
        \Psalm\Issue\UninitializedProperty::class,
        \Psalm\Issue\UnnecessaryVarAnnotation::class,
        \Psalm\Issue\UnrecognizedExpression::class,
        \Psalm\Issue\UnrecognizedStatement::class,
        \Psalm\Issue\UnresolvableConstant::class,
        \Psalm\Issue\UnresolvableInclude::class,
        \Psalm\Issue\UnsafeGenericInstantiation::class,
        \Psalm\Issue\UnsafeInstantiation::class,
        \Psalm\Issue\UnsupportedPropertyReferenceUsage::class,
        \Psalm\Issue\UnsupportedReferenceUsage::class,
        \Psalm\Issue\UnusedBaselineEntry::class,
        \Psalm\Issue\UnusedClass::class,
        \Psalm\Issue\UnusedClosureParam::class,
        \Psalm\Issue\UnusedConstructor::class,
        \Psalm\Issue\UnusedDocblockParam::class,
        \Psalm\Issue\UnusedForeachValue::class,
        \Psalm\Issue\UnusedFunctionCall::class,
        \Psalm\Issue\UnusedIssueHandlerSuppression::class,
        \Psalm\Issue\UnusedMethod::class,
        \Psalm\Issue\UnusedMethodCall::class,
        \Psalm\Issue\UnusedParam::class,
        \Psalm\Issue\UnusedProperty::class,
        \Psalm\Issue\UnusedPsalmSuppress::class,
        \Psalm\Issue\UnusedReturnValue::class,
        \Psalm\Issue\UnusedVariable::class,
        \Psalm\Issue\VariableIssue::class,
        \Psalm\NodeTypeProvider::class,
        \Psalm\Node\Expr\AssignOp\VirtualBitwiseAnd::class,
        \Psalm\Node\Expr\AssignOp\VirtualBitwiseOr::class,
        \Psalm\Node\Expr\AssignOp\VirtualBitwiseXor::class,
        \Psalm\Node\Expr\AssignOp\VirtualCoalesce::class,
        \Psalm\Node\Expr\AssignOp\VirtualConcat::class,
        \Psalm\Node\Expr\AssignOp\VirtualDiv::class,
        \Psalm\Node\Expr\AssignOp\VirtualMinus::class,
        \Psalm\Node\Expr\AssignOp\VirtualMod::class,
        \Psalm\Node\Expr\AssignOp\VirtualMul::class,
        \Psalm\Node\Expr\AssignOp\VirtualPlus::class,
        \Psalm\Node\Expr\AssignOp\VirtualPow::class,
        \Psalm\Node\Expr\AssignOp\VirtualShiftLeft::class,
        \Psalm\Node\Expr\AssignOp\VirtualShiftRight::class,
        \Psalm\Node\Expr\BinaryOp\VirtualBitwiseAnd::class,
        \Psalm\Node\Expr\BinaryOp\VirtualBitwiseOr::class,
        \Psalm\Node\Expr\BinaryOp\VirtualBitwiseXor::class,
        \Psalm\Node\Expr\BinaryOp\VirtualBooleanAnd::class,
        \Psalm\Node\Expr\BinaryOp\VirtualBooleanOr::class,
        \Psalm\Node\Expr\BinaryOp\VirtualCoalesce::class,
        \Psalm\Node\Expr\BinaryOp\VirtualConcat::class,
        \Psalm\Node\Expr\BinaryOp\VirtualDiv::class,
        \Psalm\Node\Expr\BinaryOp\VirtualEqual::class,
        \Psalm\Node\Expr\BinaryOp\VirtualGreater::class,
        \Psalm\Node\Expr\BinaryOp\VirtualGreaterOrEqual::class,
        \Psalm\Node\Expr\BinaryOp\VirtualIdentical::class,
        \Psalm\Node\Expr\BinaryOp\VirtualLogicalAnd::class,
        \Psalm\Node\Expr\BinaryOp\VirtualLogicalOr::class,
        \Psalm\Node\Expr\BinaryOp\VirtualLogicalXor::class,
        \Psalm\Node\Expr\BinaryOp\VirtualMinus::class,
        \Psalm\Node\Expr\BinaryOp\VirtualMod::class,
        \Psalm\Node\Expr\BinaryOp\VirtualMul::class,
        \Psalm\Node\Expr\BinaryOp\VirtualNotEqual::class,
        \Psalm\Node\Expr\BinaryOp\VirtualNotIdentical::class,
        \Psalm\Node\Expr\BinaryOp\VirtualPlus::class,
        \Psalm\Node\Expr\BinaryOp\VirtualPow::class,
        \Psalm\Node\Expr\BinaryOp\VirtualShiftLeft::class,
        \Psalm\Node\Expr\BinaryOp\VirtualShiftRight::class,
        \Psalm\Node\Expr\BinaryOp\VirtualSmaller::class,
        \Psalm\Node\Expr\BinaryOp\VirtualSmallerOrEqual::class,
        \Psalm\Node\Expr\BinaryOp\VirtualSpaceship::class,
        \Psalm\Node\Expr\Cast\VirtualArray::class,
        \Psalm\Node\Expr\Cast\VirtualBool::class,
        \Psalm\Node\Expr\Cast\VirtualDouble::class,
        \Psalm\Node\Expr\Cast\VirtualInt::class,
        \Psalm\Node\Expr\Cast\VirtualObject::class,
        \Psalm\Node\Expr\Cast\VirtualString::class,
        \Psalm\Node\Expr\Cast\VirtualUnset::class,
        \Psalm\Node\Expr\VirtualArray::class,
        \Psalm\Node\Expr\VirtualArrayDimFetch::class,
        \Psalm\Node\Expr\VirtualArrowFunction::class,
        \Psalm\Node\Expr\VirtualAssign::class,
        \Psalm\Node\Expr\VirtualAssignRef::class,
        \Psalm\Node\Expr\VirtualBitwiseNot::class,
        \Psalm\Node\Expr\VirtualBooleanNot::class,
        \Psalm\Node\Expr\VirtualClassConstFetch::class,
        \Psalm\Node\Expr\VirtualClone::class,
        \Psalm\Node\Expr\VirtualClosure::class,
        \Psalm\Node\Expr\VirtualConstFetch::class,
        \Psalm\Node\Expr\VirtualEmpty::class,
        \Psalm\Node\Expr\VirtualError::class,
        \Psalm\Node\Expr\VirtualErrorSuppress::class,
        \Psalm\Node\Expr\VirtualEval::class,
        \Psalm\Node\Expr\VirtualExit::class,
        \Psalm\Node\Expr\VirtualFuncCall::class,
        \Psalm\Node\Expr\VirtualInclude::class,
        \Psalm\Node\Expr\VirtualInstanceof::class,
        \Psalm\Node\Expr\VirtualIsset::class,
        \Psalm\Node\Expr\VirtualList::class,
        \Psalm\Node\Expr\VirtualMatch::class,
        \Psalm\Node\Expr\VirtualMethodCall::class,
        \Psalm\Node\Expr\VirtualNew::class,
        \Psalm\Node\Expr\VirtualNullsafeMethodCall::class,
        \Psalm\Node\Expr\VirtualNullsafePropertyFetch::class,
        \Psalm\Node\Expr\VirtualPostDec::class,
        \Psalm\Node\Expr\VirtualPostInc::class,
        \Psalm\Node\Expr\VirtualPreDec::class,
        \Psalm\Node\Expr\VirtualPreInc::class,
        \Psalm\Node\Expr\VirtualPrint::class,
        \Psalm\Node\Expr\VirtualPropertyFetch::class,
        \Psalm\Node\Expr\VirtualShellExec::class,
        \Psalm\Node\Expr\VirtualStaticCall::class,
        \Psalm\Node\Expr\VirtualStaticPropertyFetch::class,
        \Psalm\Node\Expr\VirtualTernary::class,
        \Psalm\Node\Expr\VirtualThrow::class,
        \Psalm\Node\Expr\VirtualUnaryMinus::class,
        \Psalm\Node\Expr\VirtualUnaryPlus::class,
        \Psalm\Node\Expr\VirtualVariable::class,
        \Psalm\Node\Expr\VirtualYield::class,
        \Psalm\Node\Expr\VirtualYieldFrom::class,
        \Psalm\Node\Name\VirtualFullyQualified::class,
        \Psalm\Node\Name\VirtualRelative::class,
        \Psalm\Node\Scalar\MagicConst\VirtualClass::class,
        \Psalm\Node\Scalar\MagicConst\VirtualDir::class,
        \Psalm\Node\Scalar\MagicConst\VirtualFile::class,
        \Psalm\Node\Scalar\MagicConst\VirtualFunction::class,
        \Psalm\Node\Scalar\MagicConst\VirtualLine::class,
        \Psalm\Node\Scalar\MagicConst\VirtualMethod::class,
        \Psalm\Node\Scalar\MagicConst\VirtualNamespace::class,
        \Psalm\Node\Scalar\MagicConst\VirtualTrait::class,
        \Psalm\Node\Scalar\VirtualFloat::class,
        \Psalm\Node\Scalar\VirtualInt::class,
        \Psalm\Node\Scalar\VirtualInterpolatedString::class,
        \Psalm\Node\Scalar\VirtualInterpolatedStringPart::class,
        \Psalm\Node\Scalar\VirtualString::class,
        \Psalm\Node\Stmt\TraitUseAdaptation\VirtualAlias::class,
        \Psalm\Node\Stmt\TraitUseAdaptation\VirtualPrecedence::class,
        \Psalm\Node\Stmt\VirtualBreak::class,
        \Psalm\Node\Stmt\VirtualCase::class,
        \Psalm\Node\Stmt\VirtualCatch::class,
        \Psalm\Node\Stmt\VirtualClass::class,
        \Psalm\Node\Stmt\VirtualClassConst::class,
        \Psalm\Node\Stmt\VirtualClassMethod::class,
        \Psalm\Node\Stmt\VirtualConst::class,
        \Psalm\Node\Stmt\VirtualContinue::class,
        \Psalm\Node\Stmt\VirtualDeclare::class,
        \Psalm\Node\Stmt\VirtualDeclareItem::class,
        \Psalm\Node\Stmt\VirtualDo::class,
        \Psalm\Node\Stmt\VirtualEcho::class,
        \Psalm\Node\Stmt\VirtualElse::class,
        \Psalm\Node\Stmt\VirtualElseIf::class,
        \Psalm\Node\Stmt\VirtualExpression::class,
        \Psalm\Node\Stmt\VirtualFinally::class,
        \Psalm\Node\Stmt\VirtualFor::class,
        \Psalm\Node\Stmt\VirtualForeach::class,
        \Psalm\Node\Stmt\VirtualFunction::class,
        \Psalm\Node\Stmt\VirtualGlobal::class,
        \Psalm\Node\Stmt\VirtualGoto::class,
        \Psalm\Node\Stmt\VirtualGroupUse::class,
        \Psalm\Node\Stmt\VirtualHaltCompiler::class,
        \Psalm\Node\Stmt\VirtualIf::class,
        \Psalm\Node\Stmt\VirtualInlineHTML::class,
        \Psalm\Node\Stmt\VirtualInterface::class,
        \Psalm\Node\Stmt\VirtualLabel::class,
        \Psalm\Node\Stmt\VirtualNamespace::class,
        \Psalm\Node\Stmt\VirtualNop::class,
        \Psalm\Node\Stmt\VirtualProperty::class,
        \Psalm\Node\Stmt\VirtualReturn::class,
        \Psalm\Node\Stmt\VirtualStatic::class,
        \Psalm\Node\Stmt\VirtualSwitch::class,
        \Psalm\Node\Stmt\VirtualTrait::class,
        \Psalm\Node\Stmt\VirtualTraitUse::class,
        \Psalm\Node\Stmt\VirtualTryCatch::class,
        \Psalm\Node\Stmt\VirtualUnset::class,
        \Psalm\Node\Stmt\VirtualUse::class,
        \Psalm\Node\Stmt\VirtualWhile::class,
        \Psalm\Node\VirtualArg::class,
        \Psalm\Node\VirtualArrayItem::class,
        \Psalm\Node\VirtualAttribute::class,
        \Psalm\Node\VirtualAttributeGroup::class,
        \Psalm\Node\VirtualClosureUse::class,
        \Psalm\Node\VirtualConst::class,
        \Psalm\Node\VirtualIdentifier::class,
        \Psalm\Node\VirtualMatchArm::class,
        \Psalm\Node\VirtualName::class,
        \Psalm\Node\VirtualNode::class,
        \Psalm\Node\VirtualNullableType::class,
        \Psalm\Node\VirtualParam::class,
        \Psalm\Node\VirtualPropertyItem::class,
        \Psalm\Node\VirtualStaticVar::class,
        \Psalm\Node\VirtualUnionType::class,
        \Psalm\Node\VirtualUseItem::class,
        \Psalm\Node\VirtualVarLikeIdentifier::class,
        \Psalm\PluginFileExtensionsSocket::class,
        \Psalm\PluginRegistrationSocket::class,
        \Psalm\Plugin\ArgTypeInferer::class,
        \Psalm\Plugin\DynamicFunctionStorage::class,
        \Psalm\Plugin\DynamicTemplateProvider::class,
        \Psalm\Plugin\EventHandler\AddTaintsInterface::class,
        \Psalm\Plugin\EventHandler\AfterAnalysisInterface::class,
        \Psalm\Plugin\EventHandler\AfterClassLikeAnalysisInterface::class,
        \Psalm\Plugin\EventHandler\AfterClassLikeExistenceCheckInterface::class,
        \Psalm\Plugin\EventHandler\AfterClassLikeVisitInterface::class,
        \Psalm\Plugin\EventHandler\AfterCodebasePopulatedInterface::class,
        \Psalm\Plugin\EventHandler\AfterEveryFunctionCallAnalysisInterface::class,
        \Psalm\Plugin\EventHandler\AfterExpressionAnalysisInterface::class,
        \Psalm\Plugin\EventHandler\AfterFileAnalysisInterface::class,
        \Psalm\Plugin\EventHandler\AfterFunctionCallAnalysisInterface::class,
        \Psalm\Plugin\EventHandler\AfterFunctionLikeAnalysisInterface::class,
        \Psalm\Plugin\EventHandler\AfterMethodCallAnalysisInterface::class,
        \Psalm\Plugin\EventHandler\AfterStatementAnalysisInterface::class,
        \Psalm\Plugin\EventHandler\BeforeAddIssueInterface::class,
        \Psalm\Plugin\EventHandler\BeforeExpressionAnalysisInterface::class,
        \Psalm\Plugin\EventHandler\BeforeFileAnalysisInterface::class,
        \Psalm\Plugin\EventHandler\BeforeStatementAnalysisInterface::class,
        \Psalm\Plugin\EventHandler\ClassFilePathProviderInterface::class,
        \Psalm\Plugin\EventHandler\DynamicFunctionStorageProviderInterface::class,
        \Psalm\Plugin\EventHandler\Event\AddRemoveTaintsEvent::class,
        \Psalm\Plugin\EventHandler\Event\AfterAnalysisEvent::class,
        \Psalm\Plugin\EventHandler\Event\AfterClassLikeAnalysisEvent::class,
        \Psalm\Plugin\EventHandler\Event\AfterClassLikeExistenceCheckEvent::class,
        \Psalm\Plugin\EventHandler\Event\AfterClassLikeVisitEvent::class,
        \Psalm\Plugin\EventHandler\Event\AfterCodebasePopulatedEvent::class,
        \Psalm\Plugin\EventHandler\Event\AfterEveryFunctionCallAnalysisEvent::class,
        \Psalm\Plugin\EventHandler\Event\AfterExpressionAnalysisEvent::class,
        \Psalm\Plugin\EventHandler\Event\AfterFileAnalysisEvent::class,
        \Psalm\Plugin\EventHandler\Event\AfterFunctionCallAnalysisEvent::class,
        \Psalm\Plugin\EventHandler\Event\AfterFunctionLikeAnalysisEvent::class,
        \Psalm\Plugin\EventHandler\Event\AfterMethodCallAnalysisEvent::class,
        \Psalm\Plugin\EventHandler\Event\AfterStatementAnalysisEvent::class,
        \Psalm\Plugin\EventHandler\Event\BeforeAddIssueEvent::class,
        \Psalm\Plugin\EventHandler\Event\BeforeExpressionAnalysisEvent::class,
        \Psalm\Plugin\EventHandler\Event\BeforeFileAnalysisEvent::class,
        \Psalm\Plugin\EventHandler\Event\BeforeStatementAnalysisEvent::class,
        \Psalm\Plugin\EventHandler\Event\DynamicFunctionStorageProviderEvent::class,
        \Psalm\Plugin\EventHandler\Event\FunctionExistenceProviderEvent::class,
        \Psalm\Plugin\EventHandler\Event\FunctionParamsProviderEvent::class,
        \Psalm\Plugin\EventHandler\Event\FunctionReturnTypeProviderEvent::class,
        \Psalm\Plugin\EventHandler\Event\MethodExistenceProviderEvent::class,
        \Psalm\Plugin\EventHandler\Event\MethodParamsProviderEvent::class,
        \Psalm\Plugin\EventHandler\Event\MethodReturnTypeProviderEvent::class,
        \Psalm\Plugin\EventHandler\Event\MethodVisibilityProviderEvent::class,
        \Psalm\Plugin\EventHandler\Event\PropertyExistenceProviderEvent::class,
        \Psalm\Plugin\EventHandler\Event\PropertyTypeProviderEvent::class,
        \Psalm\Plugin\EventHandler\Event\PropertyVisibilityProviderEvent::class,
        \Psalm\Plugin\EventHandler\Event\StringInterpreterEvent::class,
        \Psalm\Plugin\EventHandler\FunctionExistenceProviderInterface::class,
        \Psalm\Plugin\EventHandler\FunctionParamsProviderInterface::class,
        \Psalm\Plugin\EventHandler\FunctionReturnTypeProviderInterface::class,
        \Psalm\Plugin\EventHandler\MethodExistenceProviderInterface::class,
        \Psalm\Plugin\EventHandler\MethodParamsProviderInterface::class,
        \Psalm\Plugin\EventHandler\MethodReturnTypeProviderInterface::class,
        \Psalm\Plugin\EventHandler\MethodVisibilityProviderInterface::class,
        \Psalm\Plugin\EventHandler\PropertyExistenceProviderInterface::class,
        \Psalm\Plugin\EventHandler\PropertyTypeProviderInterface::class,
        \Psalm\Plugin\EventHandler\PropertyVisibilityProviderInterface::class,
        \Psalm\Plugin\EventHandler\RemoveTaintsInterface::class,
        \Psalm\Plugin\EventHandler\StringInterpreterInterface::class,
        \Psalm\Plugin\FileExtensionsInterface::class,
        \Psalm\Plugin\PluginEntryPointInterface::class,
        \Psalm\Plugin\PluginFileExtensionsInterface::class,
        \Psalm\Plugin\PluginInterface::class,
        \Psalm\Plugin\RegistrationInterface::class,
        \Psalm\Plugin\Shepherd::class,
        \Psalm\Progress\DebugProgress::class,
        \Psalm\Progress\DefaultProgress::class,
        \Psalm\Progress\LongProgress::class,
        \Psalm\Progress\Phase::class,
        \Psalm\Progress\Progress::class,
        \Psalm\Progress\VoidProgress::class,
        \Psalm\Report::class,
        \Psalm\Report\ByIssueLevelAndTypeReport::class,
        \Psalm\Report\CheckstyleReport::class,
        \Psalm\Report\CodeClimateReport::class,
        \Psalm\Report\CompactReport::class,
        \Psalm\Report\ConsoleReport::class,
        \Psalm\Report\CountReport::class,
        \Psalm\Report\EmacsReport::class,
        \Psalm\Report\GithubActionsReport::class,
        \Psalm\Report\JsonReport::class,
        \Psalm\Report\JsonSummaryReport::class,
        \Psalm\Report\JunitReport::class,
        \Psalm\Report\PhpStormReport::class,
        \Psalm\Report\PylintReport::class,
        \Psalm\Report\ReportOptions::class,
        \Psalm\Report\SarifReport::class,
        \Psalm\Report\SonarqubeReport::class,
        \Psalm\Report\TextReport::class,
        \Psalm\Report\XmlReport::class,
        \Psalm\SourceControl\Git\CommitInfo::class,
        \Psalm\SourceControl\Git\GitInfo::class,
        \Psalm\SourceControl\Git\RemoteInfo::class,
        \Psalm\SourceControl\SourceControlInfo::class,
        \Psalm\StatementsSource::class,
        \Psalm\Storage\Assertion::class,
        \Psalm\Storage\Assertion\Any::class,
        \Psalm\Storage\Assertion\ArrayKeyDoesNotExist::class,
        \Psalm\Storage\Assertion\ArrayKeyExists::class,
        \Psalm\Storage\Assertion\DoesNotHaveAtLeastCount::class,
        \Psalm\Storage\Assertion\DoesNotHaveExactCount::class,
        \Psalm\Storage\Assertion\DoesNotHaveMethod::class,
        \Psalm\Storage\Assertion\Empty_::class,
        \Psalm\Storage\Assertion\Falsy::class,
        \Psalm\Storage\Assertion\HasArrayKey::class,
        \Psalm\Storage\Assertion\HasAtLeastCount::class,
        \Psalm\Storage\Assertion\HasExactCount::class,
        \Psalm\Storage\Assertion\HasIntOrStringArrayAccess::class,
        \Psalm\Storage\Assertion\HasMethod::class,
        \Psalm\Storage\Assertion\HasStringArrayAccess::class,
        \Psalm\Storage\Assertion\InArray::class,
        \Psalm\Storage\Assertion\IsAClass::class,
        \Psalm\Storage\Assertion\IsClassEqual::class,
        \Psalm\Storage\Assertion\IsClassNotEqual::class,
        \Psalm\Storage\Assertion\IsCountable::class,
        \Psalm\Storage\Assertion\IsEqualIsset::class,
        \Psalm\Storage\Assertion\IsGreaterThan::class,
        \Psalm\Storage\Assertion\IsGreaterThanOrEqualTo::class,
        \Psalm\Storage\Assertion\IsIdentical::class,
        \Psalm\Storage\Assertion\IsIsset::class,
        \Psalm\Storage\Assertion\IsLessThan::class,
        \Psalm\Storage\Assertion\IsLessThanOrEqualTo::class,
        \Psalm\Storage\Assertion\IsLooselyEqual::class,
        \Psalm\Storage\Assertion\IsNotAClass::class,
        \Psalm\Storage\Assertion\IsNotCountable::class,
        \Psalm\Storage\Assertion\IsNotIdentical::class,
        \Psalm\Storage\Assertion\IsNotIsset::class,
        \Psalm\Storage\Assertion\IsNotLooselyEqual::class,
        \Psalm\Storage\Assertion\IsNotType::class,
        \Psalm\Storage\Assertion\IsType::class,
        \Psalm\Storage\Assertion\NestedAssertions::class,
        \Psalm\Storage\Assertion\NonEmpty::class,
        \Psalm\Storage\Assertion\NonEmptyCountable::class,
        \Psalm\Storage\Assertion\NotInArray::class,
        \Psalm\Storage\Assertion\NotNestedAssertions::class,
        \Psalm\Storage\Assertion\NotNonEmptyCountable::class,
        \Psalm\Storage\Assertion\Truthy::class,
        \Psalm\Storage\AttributeArg::class,
        \Psalm\Storage\AttributeStorage::class,
        \Psalm\Storage\ClassConstantStorage::class,
        \Psalm\Storage\ClassLikeStorage::class,
        \Psalm\Storage\CustomMetadataTrait::class,
        \Psalm\Storage\EnumCaseStorage::class,
        \Psalm\Storage\FileStorage::class,
        \Psalm\Storage\FunctionLikeParameter::class,
        \Psalm\Storage\FunctionLikeStorage::class,
        \Psalm\Storage\FunctionStorage::class,
        \Psalm\Storage\HasAttributesInterface::class,
        \Psalm\Storage\ImmutableNonCloneableTrait::class,
        \Psalm\Storage\MethodStorage::class,
        \Psalm\Storage\Possibilities::class,
        \Psalm\Storage\PropertyStorage::class,
        \Psalm\Storage\UnserializeMemoryUsageSuppressionTrait::class,
        \Psalm\Type::class,
        \Psalm\Type\Atomic::class,
        \Psalm\Type\Atomic\CallableTrait::class,
        \Psalm\Type\Atomic\DependentType::class,
        \Psalm\Type\Atomic\GenericTrait::class,
        \Psalm\Type\Atomic\HasIntersectionTrait::class,
        \Psalm\Type\Atomic\Scalar::class,
        \Psalm\Type\Atomic\TAnonymousClassInstance::class,
        \Psalm\Type\Atomic\TArray::class,
        \Psalm\Type\Atomic\TArrayKey::class,
        \Psalm\Type\Atomic\TBool::class,
        \Psalm\Type\Atomic\TCallable::class,
        \Psalm\Type\Atomic\TCallableObject::class,
        \Psalm\Type\Atomic\TCallableString::class,
        \Psalm\Type\Atomic\TClassConstant::class,
        \Psalm\Type\Atomic\TClassString::class,
        \Psalm\Type\Atomic\TClassStringMap::class,
        \Psalm\Type\Atomic\TClosedResource::class,
        \Psalm\Type\Atomic\TClosure::class,
        \Psalm\Type\Atomic\TConditional::class,
        \Psalm\Type\Atomic\TDependentGetClass::class,
        \Psalm\Type\Atomic\TDependentGetDebugType::class,
        \Psalm\Type\Atomic\TDependentGetType::class,
        \Psalm\Type\Atomic\TEmptyMixed::class,
        \Psalm\Type\Atomic\TEmptyNumeric::class,
        \Psalm\Type\Atomic\TEmptyScalar::class,
        \Psalm\Type\Atomic\TEnumCase::class,
        \Psalm\Type\Atomic\TFalse::class,
        \Psalm\Type\Atomic\TFloat::class,
        \Psalm\Type\Atomic\TGenericObject::class,
        \Psalm\Type\Atomic\TInt::class,
        \Psalm\Type\Atomic\TIntMask::class,
        \Psalm\Type\Atomic\TIntMaskOf::class,
        \Psalm\Type\Atomic\TIntRange::class,
        \Psalm\Type\Atomic\TIterable::class,
        \Psalm\Type\Atomic\TKeyOf::class,
        \Psalm\Type\Atomic\TKeyedArray::class,
        \Psalm\Type\Atomic\TLiteralClassString::class,
        \Psalm\Type\Atomic\TLiteralFloat::class,
        \Psalm\Type\Atomic\TLiteralInt::class,
        \Psalm\Type\Atomic\TLiteralString::class,
        \Psalm\Type\Atomic\TLowercaseString::class,
        \Psalm\Type\Atomic\TMixed::class,
        \Psalm\Type\Atomic\TNamedObject::class,
        \Psalm\Type\Atomic\TNever::class,
        \Psalm\Type\Atomic\TNonEmptyArray::class,
        \Psalm\Type\Atomic\TNonEmptyLowercaseString::class,
        \Psalm\Type\Atomic\TNonEmptyMixed::class,
        \Psalm\Type\Atomic\TNonEmptyNonspecificLiteralString::class,
        \Psalm\Type\Atomic\TNonEmptyScalar::class,
        \Psalm\Type\Atomic\TNonEmptyString::class,
        \Psalm\Type\Atomic\TNonFalsyString::class,
        \Psalm\Type\Atomic\TNonspecificLiteralInt::class,
        \Psalm\Type\Atomic\TNonspecificLiteralString::class,
        \Psalm\Type\Atomic\TNull::class,
        \Psalm\Type\Atomic\TNumeric::class,
        \Psalm\Type\Atomic\TNumericString::class,
        \Psalm\Type\Atomic\TObject::class,
        \Psalm\Type\Atomic\TObjectWithProperties::class,
        \Psalm\Type\Atomic\TPropertiesOf::class,
        \Psalm\Type\Atomic\TResource::class,
        \Psalm\Type\Atomic\TScalar::class,
        \Psalm\Type\Atomic\TSingleLetter::class,
        \Psalm\Type\Atomic\TString::class,
        \Psalm\Type\Atomic\TTemplateIndexedAccess::class,
        \Psalm\Type\Atomic\TTemplateKeyOf::class,
        \Psalm\Type\Atomic\TTemplateParam::class,
        \Psalm\Type\Atomic\TTemplateParamClass::class,
        \Psalm\Type\Atomic\TTemplatePropertiesOf::class,
        \Psalm\Type\Atomic\TTemplateValueOf::class,
        \Psalm\Type\Atomic\TTraitString::class,
        \Psalm\Type\Atomic\TTrue::class,
        \Psalm\Type\Atomic\TTypeAlias::class,
        \Psalm\Type\Atomic\TUnknownClassString::class,
        \Psalm\Type\Atomic\TValueOf::class,
        \Psalm\Type\Atomic\TVoid::class,
        \Psalm\Type\MutableTypeVisitor::class,
        \Psalm\Type\MutableUnion::class,
        \Psalm\Type\Reconciler::class,
        \Psalm\Type\TaintKind::class,
        \Psalm\Type\TypeNode::class,
        \Psalm\Type\TypeVisitor::class,
        \Psalm\Type\Union::class,
        \Psalm\Type\UnionTrait::class,
        \Revolt\EventLoop::class,
        \Revolt\EventLoop\Driver\TracingDriver::class,
        \Revolt\EventLoop\FiberLocal::class,
        \SebastianBergmann\Diff\Differ::class,
        \SebastianBergmann\Diff\Output\StrictUnifiedDiffOutputBuilder::class,
        \Spatie\ArrayToXml\ArrayToXml::class,
        \Symfony\Component\Console\Application::class,
        \Symfony\Component\Console\Command\Command::class,
        \Symfony\Component\Console\Helper\Table::class,
        \Symfony\Component\Console\Input\InputArgument::class,
        \Symfony\Component\Console\Input\InputOption::class,
        \Symfony\Component\Console\Output\BufferedOutput::class,
        \Symfony\Component\Console\Style\SymfonyStyle::class,
        \Symfony\Component\Filesystem\Path::class,
        \Webmozart\Assert\Assert::class,
        \XdgBaseDir\Xdg::class,

    ];
}
