# Atomic types

Atomic types are the basic building block of all type information used in Psalm. Multiple atomic types can be combined, either with [union types](union_types.md) or [intersection types](intersection_types.md). Psalm allows many different sorts of atomic types to be expressed in docblock syntax:

**Note**: you can view detailed documentation and usage examples for all atomic types by clicking on each type in the following list.

* [Scalar types](scalar_types.md)
    * [bool](scalar_types.md#scalar)
    * [int](scalar_types.md#scalar)
    * [float](scalar_types.md#scalar)
    * [string](scalar_types.md#scalar)
    * [`int-range<x, y>`](scalar_types.md#int-range)
    * [`int-mask<1, 2, 4>`](scalar_types.md#int-mask1-2-4)
    * [`int-mask-of<MyClass::CLASS_CONSTANT_*>`](scalar_types.md#int-mask-ofmyclassclass_constant_)
    * [class-string and class-string&lt;Foo&gt;](scalar_types.md#class-string-interface-string)
    * [trait-string](scalar_types.md#trait-string)
    * [enum-string](scalar_types.md#enum-string)
    * [callable-string](scalar_types.md#callable-string)
    * [numeric-string](scalar_types.md#numeric-string)
    * [literal-string](scalar_types.md#literal-string)
    * [literal-int](scalar_types.md#literal-int)
    * [array-key](scalar_types.md#array-key)
    * [numeric](scalar_types.md#numeric)
    * [scalar](scalar_types.md#scalar)
* [Object types](object_types.md)
    * [object](object_types.md#unnamed-objects)
    * [object{foo: string}](object_types.md#object-properties)
    * [Exception, Foo\MyClass and `Foo\MyClass<Bar>`](object_types.md#named-objectsmd)
    * [Generator](object_types.md#generators)
* [Array types](array_types.md)
    * [array&lt;int, string&gt;](array_types.md#generic-arrays)
    * [non-empty-array](array_types.md#non-empty-array)
    * [string\[\]](array_types.md#phpdoc-syntax)
    * [list & non-empty-list](array_types.md#lists)
    * [list&lt;string&gt;](array_types.md#lists)
    * [array{foo: int, bar: string} and list{int, string}](array_types.md#object-like-arrays)
    * [callable-array](array_types.md#callable-arrays)
* [Callable types](callable_types.md)
* [Value types](value_types.md)
    * [null](value_types.md#null)
    * [true, false](value_types.md#true-false)
    * [6, 7.0, "forty-two" and 'forty two'](value_types.md#some_string-4-314)
    * [Foo\Bar::MY_SCALAR_CONST](value_types.md#regular-class-constants)
* [Utility types](utility_types.md)
    * [(T is true ? string : bool)](conditional_types.md)
    * [`key-of<T>`](utility_types.md#key-oft)
    * [`value-of<T>`](utility_types.md#value-oft)
    * [`properties-of<T>`](utility_types.md#properties-oft)
    * [`class-string-map<T of Foo, T>`](utility_types.md#class-string-mapt-as-foo-t)
    * [`T[K]`](utility_types.md#tk)
    * [Type aliases](utility_types.md#type-aliases)
    * [Variable templates](utility_types.md#variable-templates)
* [Other types](other_types.md)
    * [`iterable<TKey, TValue>`](other_types.md)
    * [void](other_types.md)
    * [resource](other_types.md)
    * [closed-resource](other_types.md)
* [Top and bottom types](top_bottom_types.md)
    * [mixed](top_bottom_types.md#mixed)
    * [never](top_bottom_types.md#never)
