<?php

declare(strict_types=1);

namespace Psalm\Issue;

use Psalm\CodeLocation;

use function strtolower;

final class MixedArgument extends ArgumentIssue implements MixedIssue
{
    public const ERROR_LEVEL = 1;
    public const SHORTCODE = 30;

    use MixedIssueTrait;

    /**
     * @psalm-mutation-free
     */
    public function __construct(
        string $message,
        CodeLocation $code_location,
        ?string $function_id = null,
        ?CodeLocation $origin_location = null,
    ) {
        parent::__construct($message, $code_location);
        $this->function_id = $function_id ? strtolower($function_id) : null;
        $this->origin_location = $origin_location;
    }
}
