<?php

declare(strict_types=1);

namespace Psalm\Exception;

use LogicException;

final class UnpopulatedClasslikeException extends LogicException
{
    /**
     * @psalm-mutation-free
     */
    public function __construct(string $fq_classlike_name)
    {
        parent::__construct(
            'Cannot check inheritance - \'' . $fq_classlike_name . '\' has not been populated yet.'
            . ' You may need to defer this check to a later phase.',
        );
    }
}
