<?php

declare(strict_types=1);

namespace Psalm\Storage\Assertion;

use Override;
use Psalm\Storage\Assertion;
use Psalm\Storage\UnserializeMemoryUsageSuppressionTrait;

/**
 * @psalm-immutable
 */
final class IsEqualIsset extends Assertion
{
    use UnserializeMemoryUsageSuppressionTrait;
    #[Override]
    public function getNegation(): Assertion
    {
        return new Any();
    }

    public function __toString(): string
    {
        return '=isset';
    }

    #[Override]
    public function hasEquality(): bool
    {
        return true;
    }

    #[Override]
    public function isNegationOf(Assertion $assertion): bool
    {
        return false;
    }
}
