<?php

use Psalm\Type\TaintKind;

// This maps internal function names to sink types that we don’t want to end up there

/**
 * @var non-empty-array<string, non-empty-list<int-mask-of<TaintKind::*>>>
 */
return [
'exec' => [TaintKind::INPUT_SHELL],
'create_function' => [0, TaintKind::INPUT_EVAL],
'file_get_contents' => [TaintKind::INPUT_FILE],
'file_put_contents' => [TaintKind::INPUT_FILE],
'fopen' => [TaintKind::INPUT_FILE],
'unlink' => [TaintKind::INPUT_FILE],
'copy' => [TaintKind::INPUT_FILE, TaintKind::INPUT_FILE],
'file' => [TaintKind::INPUT_FILE],
'link' => [TaintKind::INPUT_FILE, TaintKind::INPUT_FILE],
'mkdir' => [TaintKind::INPUT_FILE],
'move_uploaded_file' => [TaintKind::INPUT_FILE, TaintKind::INPUT_FILE],
'parse_ini_file' => [TaintKind::INPUT_FILE],
'chown' => [TaintKind::INPUT_FILE],
'lchown' => [TaintKind::INPUT_FILE],
'readfile' => [TaintKind::INPUT_FILE],
'rename' => [TaintKind::INPUT_FILE, TaintKind::INPUT_FILE],
'rmdir' => [TaintKind::INPUT_FILE],
'header' => [TaintKind::INPUT_HEADER],
'symlink' => [TaintKind::INPUT_FILE],
'tempnam' => [TaintKind::INPUT_FILE],
'igbinary_unserialize' => [TaintKind::INPUT_UNSERIALIZE],
'ldap_search' => [0, TaintKind::INPUT_LDAP, TaintKind::INPUT_LDAP],
'mysqli_query' => [0, TaintKind::INPUT_SQL],
'mysqli::query' => [TaintKind::INPUT_SQL],
'mysqli_real_query' => [0, TaintKind::INPUT_SQL],
'mysqli::real_query' => [TaintKind::INPUT_SQL],
'mysqli_multi_query' => [0, TaintKind::INPUT_SQL],
'mysqli::multi_query' => [TaintKind::INPUT_SQL],
'mysqli_prepare' => [0, TaintKind::INPUT_SQL],
'mysqli::prepare' => [TaintKind::INPUT_SQL],
'mysqli_stmt::__construct' => [0, TaintKind::INPUT_SQL],
'mysqli_stmt_prepare' => [0, TaintKind::INPUT_SQL],
'mysqli_stmt::prepare' => [TaintKind::INPUT_SQL],
'passthru' => [TaintKind::INPUT_SHELL],
'pcntl_exec' => [TaintKind::INPUT_SHELL],
'pg_exec' => [0, TaintKind::INPUT_SQL],
'pg_prepare' => [0, 0, TaintKind::INPUT_SQL],
'pg_put_line' => [0, TaintKind::INPUT_SQL],
'pg_query' => [0, TaintKind::INPUT_SQL],
'pg_query_params' => [0, TaintKind::INPUT_SQL],
'pg_send_prepare' => [0, 0, TaintKind::INPUT_SQL],
'pg_send_query' => [0, TaintKind::INPUT_SQL],
'pg_send_query_params' => [0, TaintKind::INPUT_SQL, 0],
'setcookie' => [TaintKind::INPUT_COOKIE, TaintKind::INPUT_COOKIE],
'shell_exec' => [TaintKind::INPUT_SHELL],
'system' => [TaintKind::INPUT_SHELL],
'unserialize' => [TaintKind::INPUT_UNSERIALIZE],
'popen' => [TaintKind::INPUT_SHELL],
'proc_open' => [TaintKind::INPUT_SHELL],
'curl_init' => [TaintKind::INPUT_SSRF],
'curl_setopt' => [0, 0, TaintKind::INPUT_SSRF],
'getimagesize' => [TaintKind::INPUT_SSRF],
];
