<?php // phpcs:ignoreFile

/**
 * This contains the information needed to convert the function signatures for php 8.0 to php 7.4 (and vice versa)
 *
 * This has two sections.
 * The 'new' section contains function/method names from FunctionSignatureMap (And alternates, if applicable) that do not exist in php7.4 or have different signatures in php 8.0.
 *   If they were just updated, the function/method will be present in the 'new' section with the new signature, and the 'old' section with the old signature
 * The 'old' signatures contains the signatures that are different in php 7.4.
 *   Functions are expected to be removed only in major releases of php.
 *
 * TODO: Add remaining functions
 *
 * @see FunctionSignatureMap.php
 *
 * @phan-file-suppress PhanPluginMixedKeyNoKey (read by Phan when analyzing this file)
 */
return [
'new' => [
'array_combine' => ['associative-array', 'keys'=>'string[]|int[]', 'values'=>'array'],
'bcdiv' => ['string', 'dividend'=>'string', 'divisor'=>'string', 'scale='=>'int'],
'bcmod' => ['string', 'dividend'=>'string', 'divisor'=>'string', 'scale='=>'int'],
'bcpowmod' => ['string', 'base'=>'string', 'exponent'=>'string', 'modulus'=>'string', 'scale='=>'int'],
'com_load_typelib' => ['bool', 'typelib_name'=>'string', 'case_insensitive='=>'true'],
'count_chars' => ['array<int,int>|string', 'input'=>'string', 'mode='=>'int'],
'curl_close' => ['void', 'ch'=>'CurlHandle'],
'curl_copy_handle' => ['CurlHandle', 'ch'=>'CurlHandle'],
'curl_errno' => ['int', 'ch'=>'CurlHandle'],
'curl_error' => ['string', 'ch'=>'CurlHandle'],
'curl_escape' => ['string|false', 'ch'=>'CurlHandle', 'string'=>'string'],
'curl_exec' => ['bool|string', 'ch'=>'CurlHandle'],
'curl_getinfo' => ['mixed', 'ch'=>'CurlHandle', 'option='=>'int'],
'curl_init' => ['CurlHandle|false', 'url='=>'string'],
'curl_multi_add_handle' => ['int', 'mh'=>'CurlMultiHandle', 'ch'=>'CurlHandle'],
'curl_multi_close' => ['void', 'mh'=>'CurlMultiHandle'],
'curl_multi_errno' => ['int', 'mh'=>'CurlMultiHandle'],
'curl_multi_exec' => ['int', 'mh'=>'CurlMultiHandle', '&w_still_running'=>'int'],
'curl_multi_getcontent' => ['string', 'ch'=>'CurlHandle'],
'curl_multi_info_read' => ['array|false', 'mh'=>'CurlMultiHandle', '&w_msgs_in_queue='=>'int'],
'curl_multi_init' => ['CurlMultiHandle|false'],
'curl_multi_remove_handle' => ['int', 'mh'=>'CurlMultiHandle', 'ch'=>'CurlHandle'],
'curl_multi_select' => ['int', 'mh'=>'CurlMultiHandle', 'timeout='=>'float'],
'curl_multi_setopt' => ['bool', 'mh'=>'CurlMultiHandle', 'option'=>'int', 'value'=>'mixed'],
'curl_pause' => ['int', 'ch'=>'CurlHandle', 'bitmask'=>'int'],
'curl_reset' => ['void', 'ch'=>'CurlHandle'],
'curl_setopt' => ['bool', 'ch'=>'CurlHandle', 'option'=>'int', 'value'=>'callable|mixed'],
'curl_setopt_array' => ['bool', 'ch'=>'CurlHandle', 'options'=>'array'],
'curl_share_close' => ['void', 'sh'=>'CurlShareHandle'],
'curl_share_errno' => ['int', 'sh'=>'CurlShareHandle'],
'curl_share_init' => ['CurlShareHandle'],
'curl_share_setopt' => ['bool', 'sh'=>'CurlShareHandle', 'option'=>'int', 'value'=>'mixed'],
'curl_unescape' => ['string|false', 'ch'=>'CurlShareHandle', 'string'=>'string'],
'DateTime::createFromInterface' => ['self', 'object' => 'DateTimeInterface'],
'DateTime::format' => ['string', 'format'=>'string'],
'DateTimeImmutable::format' => ['string', 'format'=>'string'],
'DateTimeImmutable::createFromInterface' => ['self', 'object' => 'DateTimeInterface'],
'DateTimeZone::listIdentifiers' => ['list<string>', 'timezoneGroup='=>'int', 'countryCode='=>'string|null'],
'date_add' => ['DateTime', 'object'=>'DateTime', 'interval'=>'DateInterval'],
'date_date_set' => ['DateTime', 'object'=>'DateTime', 'year'=>'int', 'month'=>'int', 'day'=>'int'],
'date_diff' => ['DateInterval', 'obj1'=>'DateTimeInterface', 'obj2'=>'DateTimeInterface', 'absolute='=>'bool'],
'date_format' => ['string', 'object'=>'DateTimeInterface', 'format'=>'string'],
'date_isodate_set' => ['DateTime', 'object'=>'DateTime', 'year'=>'int', 'week'=>'int', 'day='=>'int|mixed'],
'date_parse' => ['array<string,mixed>', 'date'=>'string'],
'date_sub' => ['DateTime', 'object'=>'DateTime', 'interval'=>'DateInterval'],
'date_sun_info' => ['array<string,bool|int>', 'time'=>'int', 'latitude'=>'float', 'longitude'=>'float'],
'date_time_set' => ['DateTime', 'object'=>'DateTime', 'hour'=>'int', 'minute'=>'int', 'second='=>'int', 'microseconds='=>'int'],
'date_timestamp_set' => ['DateTime', 'object'=>'DateTime', 'unixtimestamp'=>'int'],
'date_timezone_set' => ['DateTime', 'object'=>'DateTime', 'timezone'=>'DateTimeZone'],
'explode' => ['array<int,string>', 'separator'=>'string', 'str'=>'string', 'limit='=>'int'],
'fdiv' => ['float', 'dividend'=>'float', 'divisor'=>'float'],
'get_debug_type' => ['string', 'var'=>'mixed'],
'get_resource_id' => ['int', 'res'=>'resource'],
'gmdate' => ['string', 'format'=>'string', 'timestamp='=>'int'],
'gmmktime' => ['int|false', 'hour'=>'int', 'minute='=>'int', 'second='=>'int', 'month='=>'int', 'day='=>'int', 'year='=>'int'],
'hash_hkdf' => ['string', 'algo'=>'string', 'ikm'=>'string', 'length='=>'int', 'info='=>'string', 'salt='=>'string'],
'imageaffine' => ['false|GdImage', 'image'=>'GdImage', 'affine'=>'array', 'clip='=>'?array'],
'imagealphablending' => ['bool', 'image'=>'GdImage', 'enable'=>'bool'],
'imageantialias' => ['bool', 'image'=>'GdImage', 'enable'=>'bool'],
'imagearc' => ['bool', 'image'=>'GdImage', 'center_x'=>'int', 'center_y'=>'int', 'width'=>'int', 'height'=>'int', 'start_angle'=>'int', 'end_angle'=>'int', 'color'=>'int'],
'imagebmp' => ['bool', 'image'=>'GdImage', 'file='=>'string|resource|null', 'compressed='=>'bool'],
'imagechar' => ['bool', 'image'=>'GdImage', 'font'=>'int', 'x'=>'int', 'y'=>'int', 'char'=>'string', 'color'=>'int'],
'imagecharup' => ['bool', 'image'=>'GdImage', 'font'=>'int', 'x'=>'int', 'y'=>'int', 'char'=>'string', 'color'=>'int'],
'imagecolorallocate' => ['int|false', 'image'=>'GdImage', 'red'=>'int', 'green'=>'int', 'blue'=>'int'],
'imagecolorallocatealpha' => ['int|false', 'image'=>'GdImage', 'red'=>'int', 'green'=>'int', 'blue'=>'int', 'alpha'=>'int'],
'imagecolorat' => ['int|false', 'image'=>'GdImage', 'x'=>'int', 'y'=>'int'],
'imagecolorclosest' => ['int|false', 'image'=>'GdImage', 'red'=>'int', 'green'=>'int', 'blue'=>'int'],
'imagecolorclosestalpha' => ['int|false', 'image'=>'GdImage', 'red'=>'int', 'green'=>'int', 'blue'=>'int', 'alpha'=>'int'],
'imagecolorclosesthwb' => ['int|false', 'image'=>'GdImage', 'red'=>'int', 'green'=>'int', 'blue'=>'int'],
'imagecolordeallocate' => ['bool', 'image'=>'GdImage', 'color'=>'int'],
'imagecolorexact' => ['int|false', 'image'=>'GdImage', 'red'=>'int', 'green'=>'int', 'blue'=>'int'],
'imagecolorexactalpha' => ['int|false', 'image'=>'GdImage', 'red'=>'int', 'green'=>'int', 'blue'=>'int', 'alpha'=>'int'],
'imagecolormatch' => ['bool', 'image1'=>'GdImage', 'image2'=>'GdImage'],
'imagecolorresolve' => ['int|false', 'image'=>'GdImage', 'red'=>'int', 'green'=>'int', 'blue'=>'int'],
'imagecolorresolvealpha' => ['int|false', 'image'=>'GdImage', 'red'=>'int', 'green'=>'int', 'blue'=>'int', 'alpha'=>'int'],
'imagecolorset' => ['void', 'image'=>'GdImage', 'color'=>'int', 'red'=>'int', 'green'=>'int', 'blue'=>'int', 'alpha='=>'int'],
'imagecolorsforindex' => ['array|false', 'image'=>'GdImage', 'color'=>'int'],
'imagecolorstotal' => ['int|false', 'image'=>'GdImage'],
'imagecolortransparent' => ['int|false', 'image'=>'GdImage', 'color='=>'int'],
'imageconvolution' => ['bool', 'image'=>'GdImage', 'matrix'=>'array', 'divisor'=>'float', 'offset'=>'float'],
'imagecopy' => ['bool', 'dst_image'=>'GdImage', 'src_image'=>'GdImage', 'dst_x'=>'int', 'dst_y'=>'int', 'src_x'=>'int', 'src_y'=>'int', 'src_width'=>'int', 'src_height'=>'int'],
'imagecopymerge' => ['bool', 'dst_image'=>'GdImage', 'src_image'=>'GdImage', 'dst_x'=>'int', 'dst_y'=>'int', 'src_x'=>'int', 'src_y'=>'int', 'src_width'=>'int', 'src_height'=>'int', 'pct'=>'int'],
'imagecopymergegray' => ['bool', 'dst_image'=>'GdImage', 'src_image'=>'GdImage', 'dst_x'=>'int', 'dst_y'=>'int', 'src_x'=>'int', 'src_y'=>'int', 'src_width'=>'int', 'src_height'=>'int', 'pct'=>'int'],
'imagecopyresampled' => ['bool', 'dst_image'=>'GdImage', 'src_image'=>'GdImage', 'dst_x'=>'int', 'dst_y'=>'int', 'src_x'=>'int', 'src_y'=>'int', 'dst_width'=>'int', 'dst_height'=>'int', 'src_width'=>'int', 'src_height'=>'int'],
'imagecopyresized' => ['bool', 'dst_image'=>'GdImage', 'src_image'=>'GdImage', 'dst_x'=>'int', 'dst_y'=>'int', 'src_x'=>'int', 'src_y'=>'int', 'dst_width'=>'int', 'dst_height'=>'int', 'src_width'=>'int', 'src_height'=>'int'],
'imagecreate' => ['false|GdImage', 'width'=>'int', 'height'=>'int'],
'imagecreatefrombmp' => ['false|GdImage', 'filename'=>'string'],
'imagecreatefromgd' => ['false|GdImage', 'filename'=>'string'],
'imagecreatefromgd2' => ['false|GdImage', 'filename'=>'string'],
'imagecreatefromgd2part' => ['false|GdImage', 'filename'=>'string', 'x'=>'int', 'y'=>'int', 'width'=>'int', 'height'=>'int'],
'imagecreatefromgif' => ['false|GdImage', 'filename'=>'string'],
'imagecreatefromjpeg' => ['false|GdImage', 'filename'=>'string'],
'imagecreatefrompng' => ['false|GdImage', 'filename'=>'string'],
'imagecreatefromstring' => ['false|GdImage', 'data'=>'string'],
'imagecreatefromwbmp' => ['false|GdImage', 'filename'=>'string'],
'imagecreatefromwebp' => ['false|GdImage', 'filename'=>'string'],
'imagecreatefromxbm' => ['false|GdImage', 'filename'=>'string'],
'imagecreatefromxpm' => ['false|GdImage', 'filename'=>'string'],
'imagecreatetruecolor' => ['false|GdImage', 'width'=>'int', 'height'=>'int'],
'imagecrop' => ['false|GdImage', 'image'=>'GdImage', 'rectangle'=>'array'],
'imagecropauto' => ['false|GdImage', 'image'=>'GdImage', 'mode'=>'int', 'threshold'=>'float', 'color'=>'int'],
'imagedashedline' => ['bool', 'image'=>'GdImage', 'x1'=>'int', 'y1'=>'int', 'x2'=>'int', 'y2'=>'int', 'color'=>'int'],
'imagedestroy' => ['bool', 'image'=>'GdImage'],
'imageellipse' => ['bool', 'image'=>'GdImage', 'center_x'=>'int', 'center_y'=>'int', 'width'=>'int', 'height'=>'int', 'color'=>'int'],
'imagefill' => ['bool', 'image'=>'GdImage', 'x'=>'int', 'y'=>'int', 'color'=>'int'],
'imagefilledarc' => ['bool', 'image'=>'GdImage', 'center_x'=>'int', 'center_y'=>'int', 'width'=>'int', 'height'=>'int', 'start_angle'=>'int', 'end_angle'=>'int', 'color'=>'int', 'style'=>'int'],
'imagefilledellipse' => ['bool', 'image'=>'GdImage', 'center_x'=>'int', 'center_y'=>'int', 'width'=>'int', 'height'=>'int', 'color'=>'int'],
'imagefilledpolygon' => ['bool', 'image'=>'GdImage', 'points'=>'array', 'num_points_or_color'=>'int', 'color'=>'int'],
'imagefilledrectangle' => ['bool', 'image'=>'GdImage', 'x1'=>'int', 'y1'=>'int', 'x2'=>'int', 'y2'=>'int', 'color'=>'int'],
'imagefilltoborder' => ['bool', 'image'=>'GdImage', 'x'=>'int', 'y'=>'int', 'border_color'=>'int', 'color'=>'int'],
'imagefilter' => ['bool', 'image'=>'GdImage', 'filter'=>'int', 'args='=>'int', 'arg2='=>'int', 'arg3='=>'int', 'arg4='=>'int'],
'imageflip' => ['bool', 'image'=>'GdImage', 'mode'=>'int'],
'imagefttext' => ['array|false', 'image'=>'GdImage', 'size'=>'float', 'angle'=>'float', 'x'=>'int', 'y'=>'int', 'color'=>'int', 'font_filename'=>'string', 'text'=>'string', 'options='=>'array'],
'imagegammacorrect' => ['bool', 'image'=>'GdImage', 'input_gamma'=>'float', 'output_gamma'=>'float'],
'imagegd' => ['bool', 'image'=>'GdImage', 'file='=>'string|resource|null'],
'imagegd2' => ['bool', 'image'=>'GdImage', 'file='=>'string|resource|null', 'chunk_size='=>'int', 'mode='=>'int'],
'imagegetclip' => ['array<int,int>', 'image'=>'GdImage'],
'imagegetinterpolation' => ['int', 'image'=>'GdImage'],
'imagegif' => ['bool', 'image'=>'GdImage', 'file='=>'string|resource|null'],
'imagegrabscreen' => ['false|GdImage'],
'imagegrabwindow' => ['false|GdImage', 'handle'=>'int', 'client_area='=>'int'],
'imageinterlace' => ['int|false', 'image'=>'GdImage', 'enable='=>'int'],
'imageistruecolor' => ['bool', 'image'=>'GdImage'],
'imagejpeg' => ['bool', 'image'=>'GdImage', 'file='=>'string|resource|null', 'quality='=>'int'],
'imagejpeg\'1' => ['string|false', 'image'=>'GdImage', 'file='=>'null', 'quality='=>'int'],
'imagelayereffect' => ['bool', 'image'=>'GdImage', 'effect'=>'int'],
'imageline' => ['bool', 'image'=>'GdImage', 'x1'=>'int', 'y1'=>'int', 'x2'=>'int', 'y2'=>'int', 'color'=>'int'],
'imageopenpolygon' => ['bool', 'image'=>'GdImage', 'points'=>'array', 'num_points_or_color'=>'int', 'color'=>'int'],
'imagepalettecopy' => ['void', 'dst'=>'GdImage', 'src'=>'GdImage'],
'imagepalettetotruecolor' => ['bool', 'image'=>'GdImage'],
'imagepng' => ['bool', 'image'=>'GdImage', 'file='=>'string|resource|null', 'quality='=>'int', 'filters='=>'int'],
'imagepolygon' => ['bool', 'image'=>'GdImage', 'points'=>'array', 'num_points_or_color'=>'int', 'color'=>'int'],
'imagerectangle' => ['bool', 'image'=>'GdImage', 'x1'=>'int', 'y1'=>'int', 'x2'=>'int', 'y2'=>'int', 'color'=>'int'],
'imageresolution' => ['array|bool', 'image'=>'GdImage', 'resolution_x='=>'int', 'resolution_y='=>'int'],
'imagerotate' => ['false|GdImage', 'image'=>'GdImage', 'angle'=>'float', 'background_color'=>'int', 'ignore_transparent='=>'int'],
'imagesavealpha' => ['bool', 'image'=>'GdImage', 'enable'=>'bool'],
'imagescale' => ['false|GdImage', 'image'=>'GdImage', 'width'=>'int', 'height='=>'int', 'mode='=>'int'],
'imagesetbrush' => ['bool', 'image'=>'GdImage', 'brush'=>'GdImage'],
'imagesetclip' => ['bool', 'image'=>'GdImage', 'x1'=>'int', 'x2'=>'int', 'y1'=>'int', 'y2'=>'int'],
'imagesetinterpolation' => ['bool', 'image'=>'GdImage', 'method'=>'int'],
'imagesetpixel' => ['bool', 'image'=>'GdImage', 'x'=>'int', 'y'=>'int', 'color'=>'int'],
'imagesetstyle' => ['bool', 'image'=>'GdImage', 'style'=>'non-empty-array'],
'imagesetthickness' => ['bool', 'image'=>'GdImage', 'thickness'=>'int'],
'imagesettile' => ['bool', 'image'=>'GdImage', 'tile'=>'GdImage'],
'imagestring' => ['bool', 'image'=>'GdImage', 'font'=>'int', 'x'=>'int', 'y'=>'int', 'string'=>'string', 'color'=>'int'],
'imagestringup' => ['bool', 'image'=>'GdImage', 'font'=>'int', 'x'=>'int', 'y'=>'int', 'string'=>'string', 'color'=>'int'],
'imagesx' => ['int|false', 'image'=>'GdImage'],
'imagesy' => ['int|false', 'image'=>'GdImage'],
'imagetruecolortopalette' => ['bool', 'image'=>'GdImage', 'dither'=>'bool', 'num_colors'=>'int'],
'imagettftext' => ['false|array', 'image'=>'GdImage', 'size'=>'float', 'angle'=>'float', 'x'=>'int', 'y'=>'int', 'color'=>'int', 'font_filename'=>'string', 'text'=>'string'],
'imagewbmp' => ['bool', 'image'=>'GdImage', 'file='=>'string|resource|null', 'foreground_color='=>'int'],
'imagewebp' => ['bool', 'image'=>'GdImage', 'file='=>'string|resource|null', 'quality='=>'int'],
'imagexbm' => ['bool', 'image'=>'GdImage', 'filename='=>'?string', 'foreground_color='=>'int'],
'mb_convert_case' => ['string', 'string'=>'string', 'mode'=>'int', 'encoding='=>'string'],
'mb_convert_kana' => ['string', 'string'=>'string', 'mode='=>'string', 'encoding='=>'string'],
'mb_decode_numericentity' => ['string', 'string'=>'string', 'convmap'=>'array', 'encoding='=>'string'],
'mb_encode_mimeheader' => ['string', 'string'=>'string', 'charset='=>'string', 'transfer_encoding='=>'string', 'newline='=>'string', 'indent='=>'int'],
'mb_encode_numericentity' => ['string', 'string'=>'string', 'map'=>'array', 'encoding='=>'string', 'hex='=>'bool'],
'mb_scrub' => ['string', 'string'=>'string', 'encoding='=>'string'],
'mb_strimwidth' => ['string', 'string'=>'string', 'start'=>'int', 'width'=>'int', 'trim_marker='=>'string', 'encoding='=>'string'],
'mb_strlen' => ['int', 'string'=>'string', 'encoding='=>'string'],
'mb_strtolower' => ['lowercase-string', 'string'=>'string', 'encoding='=>'string'],
'mb_strtoupper' => ['string', 'string'=>'string', 'encoding='=>'string'],
'mb_strwidth' => ['int', 'string'=>'string', 'encoding='=>'string'],
'mb_substr' => ['string', 'string'=>'string', 'start'=>'int', 'length='=>'?int', 'encoding='=>'string'],
'mb_substr_count' => ['int', 'haystack'=>'string', 'needle'=>'string', 'encoding='=>'string'],
'mktime' => ['int|false', 'hour'=>'int', 'minute='=>'int', 'second='=>'int', 'month='=>'int', 'day='=>'int', 'year='=>'int'],
'parse_str' => ['void', 'encoded_string'=>'string', '&w_result'=>'array'],
'password_hash' => ['string', 'password'=>'string', 'algo'=>'?string|?int', 'options='=>'array'],
'PDOStatement::bindColumn' => ['bool', 'column'=>'mixed', '&rw_var'=>'mixed', 'type='=>'int', 'maxLength='=>'int', 'driverOptions='=>'mixed'],
'PDOStatement::bindParam' => ['bool', 'param,'=>'string|int', '&rw_var'=>'mixed', 'type='=>'int', 'maxLength='=>'int', 'driverOptions='=>'mixed'],
'PDOStatement::bindValue' => ['bool', 'param'=>'string|int', 'value'=>'mixed', 'type='=>'int'],
'PDOStatement::debugDumpParams' => ['bool|null'],
'PDOStatement::errorCode' => ['string|null'],
'PDOStatement::execute' => ['bool', 'params='=>'?array'],
'PDOStatement::fetch' => ['mixed', 'mode='=>'int', 'cursorOrientation='=>'int', 'cursorOffset='=>'int'],
'PDOStatement::fetchAll' => ['array', 'mode='=>'int', '...args='=>'mixed'],
'PDOStatement::fetchColumn' => ['mixed', 'column='=>'int'],
'PDOStatement::fetchObject' => ['object|false', 'class='=>'?string', 'ctorArgs='=>'?array'],
'PDOStatement::setFetchMode' => ['bool', 'mode'=>'int', '...args='=> 'mixed'],
'PhpToken::getAll' => ['list<PhpToken>', 'code'=>'string', 'flags='=>'int'],
'PhpToken::is' => ['bool', 'kind'=>'string|int|string[]|int[]'],
'PhpToken::isIgnorable' => ['bool'],
'PhpToken::getTokenName' => ['string'],
'ReflectionClass::getConstants' => ['array<string,mixed>', 'filter=' => '?int'],
'ReflectionNamedType::isBuiltin' => ['bool'],
'proc_get_status' => ['array<string,int|string|bool>', 'process'=>'resource'],
'socket_accept' => ['Socket|false', 'socket'=>'Socket'],
'socket_addrinfo_bind' => ['?Socket', 'addrinfo'=>'AddressInfo'],
'socket_addrinfo_connect' => ['?Socket', 'addrinfo'=>'AddressInfo'],
'socket_addrinfo_explain' => ['array', 'addrinfo'=>'AddressInfo'],
'socket_addrinfo_lookup' => ['AddressInfo[]', 'node'=>'string', 'service='=>'mixed', 'hints='=>'array'],
'socket_bind' => ['bool', 'socket'=>'Socket', 'addr'=>'string', 'port='=>'int'],
'socket_clear_error' => ['void', 'socket='=>'Socket'],
'socket_close' => ['void', 'socket'=>'Socket'],
'socket_connect' => ['bool', 'socket'=>'Socket', 'addr'=>'string', 'port='=>'int'],
'socket_create' => ['Socket|false', 'domain'=>'int', 'type'=>'int', 'protocol'=>'int'],
'socket_create_listen' => ['Socket|false', 'port'=>'int', 'backlog='=>'int'],
'socket_create_pair' => ['bool', 'domain'=>'int', 'type'=>'int', 'protocol'=>'int', '&w_fd'=>'Socket[]'],
'socket_export_stream' => ['resource|false', 'socket'=>'Socket'],
'socket_get_option' => ['mixed|false', 'socket'=>'Socket', 'level'=>'int', 'optname'=>'int'],
'socket_get_status' => ['array', 'stream'=>'Socket'],
'socket_getopt' => ['mixed', 'socket'=>'Socket', 'level'=>'int', 'optname'=>'int'],
'socket_getpeername' => ['bool', 'socket'=>'Socket', '&w_addr'=>'string', '&w_port='=>'int'],
'socket_getsockname' => ['bool', 'socket'=>'Socket', '&w_addr'=>'string', '&w_port='=>'int'],
'socket_import_stream' => ['Socket|false|null', 'stream'=>'resource'],
'socket_last_error' => ['int', 'socket='=>'Socket'],
'socket_listen' => ['bool', 'socket'=>'Socket', 'backlog='=>'int'],
'socket_read' => ['string|false', 'socket'=>'Socket', 'length'=>'int', 'type='=>'int'],
'socket_recv' => ['int|false', 'socket'=>'Socket', '&w_buf'=>'string', 'length'=>'int', 'flags'=>'int'],
'socket_recvfrom' => ['int|false', 'socket'=>'Socket', '&w_buf'=>'string', 'length'=>'int', 'flags'=>'int', '&w_name'=>'string', '&w_port='=>'int'],
'socket_recvmsg' => ['int|false', 'socket'=>'Socket', '&w_message'=>'string', 'flags='=>'int'],
'socket_select' => ['int|false', '&rw_read_fds'=>'Socket[]|null', '&rw_write_fds'=>'Socket[]|null', '&rw_except_fds'=>'Socket[]|null', 'tv_sec'=>'int', 'tv_usec='=>'int'],
'socket_send' => ['int|false', 'socket'=>'Socket', 'buf'=>'string', 'length'=>'int', 'flags'=>'int'],
'socket_sendmsg' => ['int|false', 'socket'=>'Socket', 'message'=>'array', 'flags'=>'int'],
'socket_sendto' => ['int|false', 'socket'=>'Socket', 'buf'=>'string', 'length'=>'int', 'flags'=>'int', 'addr'=>'string', 'port='=>'int'],
'socket_set_block' => ['bool', 'socket'=>'Socket'],
'socket_set_blocking' => ['bool', 'socket'=>'Socket', 'mode'=>'int'],
'socket_set_nonblock' => ['bool', 'socket'=>'Socket'],
'socket_set_option' => ['bool', 'socket'=>'Socket', 'level'=>'int', 'optname'=>'int', 'optval'=>'int|string|array'],
'socket_set_timeout' => ['bool', 'stream'=>'resource', 'seconds'=>'int', 'microseconds='=>'int'],
'socket_setopt' => ['void', 'socket'=>'Socket', 'level'=>'int', 'optname'=>'int', 'optval'=>'int|string|array'],
'socket_shutdown' => ['bool', 'socket'=>'Socket', 'how='=>'int'],
'socket_strerror' => ['string', 'errno'=>'int'],
'socket_write' => ['int|false', 'socket'=>'Socket', 'buf'=>'string', 'length='=>'int'],
'socket_wsaprotocol_info_export' => ['string|false', 'stream'=>'resource', 'target_pid'=>'int'],
'socket_wsaprotocol_info_import' => ['Socket|false', 'id'=>'string'],
'socket_wsaprotocol_info_release' => ['bool', 'id'=>'string'],
'sodium_crypto_aead_chacha20poly1305_ietf_decrypt' => ['string|false', 'confidential_message'=>'string', 'public_message'=>'string', 'nonce'=>'string', 'key'=>'string'],
'str_contains' => ['bool', 'haystack'=>'string', 'needle'=>'string'],
'str_ends_with' => ['bool', 'haystack'=>'string', 'needle'=>'string'],
'str_starts_with' => ['bool', 'haystack'=>'string', 'needle'=>'string'],
'strchr' => ['string|false', 'haystack'=>'string', 'needle'=>'string', 'before_needle='=>'bool'],
'stripos' => ['int|false', 'haystack'=>'string', 'needle'=>'string', 'offset='=>'int'],
'stristr' => ['string|false', 'haystack'=>'string', 'needle'=>'string', 'before_needle='=>'bool'],
'strpos' => ['int|false', 'haystack'=>'string', 'needle'=>'string', 'offset='=>'int'],
'strrchr' => ['string|false', 'haystack'=>'string', 'needle'=>'string'],
'strripos' => ['int|false', 'haystack'=>'string', 'needle'=>'string', 'offset='=>'int'],
'strrpos' => ['int|false', 'haystack'=>'string', 'needle'=>'string', 'offset='=>'int'],
'strstr' => ['string|false', 'haystack'=>'string', 'needle'=>'string', 'before_needle='=>'bool'],
'timezone_identifiers_list' => ['list<string>', 'timezoneGroup='=>'int', 'countryCode='=>'?string'],
'xml_parser_create' => ['XMLParser', 'encoding='=>'string'],
'xml_parser_create_ns' => ['XMLParser', 'encoding='=>'string', 'sep='=>'string'],
'xml_parser_free' => ['bool', 'parser'=>'XMLParser'],
'xml_parser_get_option' => ['mixed|false', 'parser'=>'XMLParser', 'option'=>'int'],
'xml_parser_set_option' => ['bool', 'parser'=>'XMLParser', 'option'=>'int', 'value'=>'mixed'],
'XMLWriter::flush' => ['string|int', 'empty='=>'bool'],
'XMLWriter::startAttributeNs' => ['bool', 'prefix'=>'?string', 'name'=>'string', 'namespace'=>'?string'],
'XMLWriter::writeAttributeNs' => ['bool', 'prefix'=>'?string', 'name'=>'string', 'namespace'=>'?string', 'value'=>'string'],
'XMLWriter::writeDtdEntity' => ['bool', 'name'=>'string', 'content'=>'string', 'isParam='=>'bool', 'publicId='=>'?string', 'systemId='=>'?string', 'notationData='=>'?string'],
'xmlwriter_end_attribute' => ['bool', 'writer'=>'XMLWriter'],
'xmlwriter_end_cdata' => ['bool', 'writer'=>'XMLWriter'],
'xmlwriter_end_comment' => ['bool', 'writer'=>'XMLWriter'],
'xmlwriter_end_document' => ['bool', 'writer'=>'XMLWriter'],
'xmlwriter_end_dtd' => ['bool', 'writer'=>'XMLWriter'],
'xmlwriter_end_dtd_attlist' => ['bool', 'writer'=>'XMLWriter'],
'xmlwriter_end_dtd_element' => ['bool', 'writer'=>'XMLWriter'],
'xmlwriter_end_dtd_entity' => ['bool', 'writer'=>'XMLWriter'],
'xmlwriter_end_element' => ['bool', 'writer'=>'XMLWriter'],
'xmlwriter_end_pi' => ['bool', 'writer'=>'XMLWriter'],
'xmlwriter_flush' => ['string|int', 'writer'=>'XMLWriter', 'empty='=>'bool'],
'xmlwriter_full_end_element' => ['bool', 'writer'=>'XMLWriter'],
'xmlwriter_open_memory' => ['XMLWriter|false'],
'xmlwriter_open_uri' => ['XMLWriter|false', 'uri'=>'string'],
'xmlwriter_output_memory' => ['string', 'writer'=>'XMLWriter', 'flush='=>'bool'],
'xmlwriter_set_indent' => ['bool', 'writer'=>'XMLWriter', 'enable'=>'bool'],
'xmlwriter_set_indent_string' => ['bool', 'writer'=>'XMLWriter', 'indentation'=>'string'],
'xmlwriter_start_attribute' => ['bool', 'writer'=>'XMLWriter', 'name'=>'string'],
'xmlwriter_start_attribute_ns' => ['bool', 'writer'=>'XMLWriter', 'prefix'=>'?string', 'name'=>'string', 'namespace'=>'?string'],
'xmlwriter_start_cdata' => ['bool', 'writer'=>'XMLWriter'],
'xmlwriter_start_comment' => ['bool', 'writer'=>'XMLWriter'],
'xmlwriter_start_document' => ['bool', 'writer'=>'XMLWriter', 'version='=>'?string', 'encoding='=>'?string', 'standalone='=>'?string'],
'xmlwriter_start_dtd' => ['bool', 'writer'=>'XMLWriter', 'qualifiedName'=>'string', 'publicId='=>'?string', 'systemId='=>'?string'],
'xmlwriter_start_dtd_attlist' => ['bool', 'writer'=>'XMLWriter', 'name'=>'string'],
'xmlwriter_start_dtd_element' => ['bool', 'writer'=>'XMLWriter', 'qualifiedName'=>'string'],
'xmlwriter_start_dtd_entity' => ['bool', 'writer'=>'XMLWriter', 'name'=>'string', 'isParam'=>'bool'],
'xmlwriter_start_element' => ['bool', 'writer'=>'XMLWriter', 'name'=>'string'],
'xmlwriter_start_element_ns' => ['bool', 'writer'=>'XMLWriter', 'prefix'=>'?string', 'name'=>'string', 'namespace'=>'?string'],
'xmlwriter_start_pi' => ['bool', 'writer'=>'XMLWriter', 'target'=>'string'],
'xmlwriter_text' => ['bool', 'writer'=>'XMLWriter', 'content'=>'string'],
'xmlwriter_write_attribute' => ['bool', 'writer'=>'XMLWriter', 'name'=>'string', 'value'=>'string'],
'xmlwriter_write_attribute_ns' => ['bool', 'writer'=>'XMLWriter', 'prefix'=>'?string', 'name'=>'string', '?namespace'=>'string', 'value'=>'string'],
'xmlwriter_write_cdata' => ['bool', 'writer'=>'XMLWriter', 'content'=>'string'],
'xmlwriter_write_comment' => ['bool', 'writer'=>'XMLWriter', 'content'=>'string'],
'xmlwriter_write_dtd' => ['bool', 'writer'=>'XMLWriter', 'name'=>'string', 'publicId='=>'?string', 'systemId='=>'?string', 'content='=>'?string'],
'xmlwriter_write_dtd_attlist' => ['bool', 'writer'=>'XMLWriter', 'name'=>'string', 'content'=>'string'],
'xmlwriter_write_dtd_element' => ['bool', 'writer'=>'XMLWriter', 'name'=>'string', 'content'=>'string'],
'xmlwriter_write_dtd_entity' => ['bool', 'writer'=>'XMLWriter', 'name'=>'string', 'content'=>'string', 'isParam='=>'bool', 'publicId='=>'?string', 'systemId='=>'?string', 'notationData='=>'?string'],
'xmlwriter_write_element' => ['bool', 'writer'=>'XMLWriter', 'name'=>'string', 'content='=>'?string'],
'xmlwriter_write_element_ns' => ['bool', 'writer'=>'XMLWriter', 'prefix'=>'?string', 'name'=>'string', 'namespace'=>'?string', 'content='=>'?string'],
'xmlwriter_write_pi' => ['bool', 'writer'=>'XMLWriter', 'target'=>'string', 'content'=>'string'],
'xmlwriter_write_raw' => ['bool', 'writer'=>'XMLWriter', 'content'=>'string'],
],
'old' => [

'array_combine' => ['associative-array|false', 'keys'=>'string[]|int[]', 'values'=>'array'],
'bcdiv' => ['?string', 'dividend'=>'string', 'divisor'=>'string', 'scale='=>'int'],
'bcmod' => ['?string', 'dividend'=>'string', 'divisor'=>'string', 'scale='=>'int'],
'bcpowmod' => ['?string', 'base'=>'string', 'exponent'=>'string', 'modulus'=>'string', 'scale='=>'int'],
'com_load_typelib' => ['bool', 'typelib_name'=>'string', 'case_insensitive='=>'bool'],
'count_chars' => ['array<int,int>|false|string', 'input'=>'string', 'mode='=>'int'],
'create_function' => ['string', 'args'=>'string', 'code'=>'string'],
'curl_close' => ['void', 'ch'=>'resource'],
'curl_copy_handle' => ['resource', 'ch'=>'resource'],
'curl_errno' => ['int', 'ch'=>'resource'],
'curl_error' => ['string', 'ch'=>'resource'],
'curl_escape' => ['string|false', 'ch'=>'resource', 'string'=>'string'],
'curl_exec' => ['bool|string', 'ch'=>'resource'],
'curl_file_create' => ['CURLFile', 'filename'=>'string', 'mimetype='=>'string', 'postfilename='=>'string'],
'curl_getinfo' => ['mixed', 'ch'=>'resource', 'option='=>'int'],
'curl_init' => ['resource|false', 'url='=>'string'],
'curl_multi_add_handle' => ['int', 'mh'=>'resource', 'ch'=>'resource'],
'curl_multi_close' => ['void', 'mh'=>'resource'],
'curl_multi_errno' => ['int', 'mh'=>'resource'],
'curl_multi_exec' => ['int', 'mh'=>'resource', '&w_still_running'=>'int'],
'curl_multi_getcontent' => ['string', 'ch'=>'resource'],
'curl_multi_info_read' => ['array|false', 'mh'=>'resource', '&w_msgs_in_queue='=>'int'],
'curl_multi_init' => ['resource|false'],
'curl_multi_remove_handle' => ['int', 'mh'=>'resource', 'ch'=>'resource'],
'curl_multi_select' => ['int', 'mh'=>'resource', 'timeout='=>'float'],
'curl_multi_setopt' => ['bool', 'mh'=>'resource', 'option'=>'int', 'value'=>'mixed'],
'curl_pause' => ['int', 'ch'=>'resource', 'bitmask'=>'int'],
'curl_reset' => ['void', 'ch'=>'resource'],
'curl_setopt' => ['bool', 'ch'=>'resource', 'option'=>'int', 'value'=>'callable|mixed'],
'curl_setopt_array' => ['bool', 'ch'=>'resource', 'options'=>'array'],
'curl_share_close' => ['void', 'sh'=>'resource'],
'curl_share_errno' => ['int', 'sh'=>'resource'],
'curl_share_init' => ['resource'],
'curl_share_setopt' => ['bool', 'sh'=>'resource', 'option'=>'int', 'value'=>'mixed'],
'curl_unescape' => ['string|false', 'ch'=>'resource', 'string'=>'string'],
'date_add' => ['DateTime|false', 'object'=>'DateTime', 'interval'=>'DateInterval'],
'date_date_set' => ['DateTime|false', 'object'=>'DateTime', 'year'=>'int', 'month'=>'int', 'day'=>'int'],
'date_diff' => ['DateInterval|false', 'obj1'=>'DateTimeInterface', 'obj2'=>'DateTimeInterface', 'absolute='=>'bool'],
'date_format' => ['string|false', 'object'=>'DateTimeInterface', 'format'=>'string'],
'date_isodate_set' => ['DateTime|false', 'object'=>'DateTime', 'year'=>'int', 'week'=>'int', 'day='=>'int|mixed'],
'date_parse' => ['array<string,mixed>|false', 'date'=>'string'],
'date_sub' => ['DateTime|false', 'object'=>'DateTime', 'interval'=>'DateInterval'],
'date_sun_info' => ['array<string,bool|int>|false', 'time'=>'int', 'latitude'=>'float', 'longitude'=>'float'],
'date_time_set' => ['DateTime|false', 'object'=>'DateTime', 'hour'=>'int', 'minute'=>'int', 'second='=>'int', 'microseconds='=>'int'],
'date_timestamp_set' => ['DateTime|false', 'object'=>'DateTime', 'unixtimestamp'=>'int'],
'date_timezone_set' => ['DateTime|false', 'object'=>'DateTime', 'timezone'=>'DateTimeZone'],
'DateTime::format' => ['string|false', 'format'=>'string'],
'DateTimeImmutable::format' => ['string|false', 'format'=>'string'],
'DateTimeZone::listIdentifiers' => ['list<string>|false', 'timezoneGroup='=>'int', 'countryCode='=>'string|null'],
'each' => ['array{0:int|string,key:int|string,1:mixed,value:mixed}', '&r_arr'=>'array'],
'explode' => ['list<string>', 'separator'=>'string', 'str'=>'string', 'limit='=>'int'],
'gmdate' => ['string|false', 'format'=>'string', 'timestamp='=>'int'],
'gmmktime' => ['int|false', 'hour='=>'int', 'minute='=>'int', 'second='=>'int', 'month='=>'int', 'day='=>'int', 'year='=>'int'],
'gmp_random' => ['GMP', 'limiter='=>'int'],
'gzgetss' => ['string|false', 'zp'=>'resource', 'length'=>'int', 'allowable_tags='=>'string'],
'hash_hkdf' => ['string|false', 'algo'=>'string', 'ikm'=>'string', 'length='=>'int', 'info='=>'string', 'salt='=>'string'],
'image2wbmp' => ['bool', 'im'=>'resource', 'filename='=>'?string', 'threshold='=>'int'],
'imageaffine' => ['resource|false', 'src'=>'resource', 'affine'=>'array', 'clip='=>'array'],
'imagealphablending' => ['bool', 'image'=>'resource', 'enable'=>'bool'],
'imageantialias' => ['bool', 'image'=>'resource', 'enable'=>'bool'],
'imagearc' => ['bool', 'image'=>'resource', 'center_x'=>'int', 'center_y'=>'int', 'width'=>'int', 'height'=>'int', 'start_angle'=>'int', 'end_angle'=>'int', 'color'=>'int'],
'imagebmp' => ['bool', 'image'=>'resource', 'file='=>'string|resource|null', 'compressed='=>'bool'],
'imagechar' => ['bool', 'image'=>'resource', 'font'=>'int', 'x'=>'int', 'y'=>'int', 'char'=>'string', 'color'=>'int'],
'imagecharup' => ['bool', 'image'=>'resource', 'font'=>'int', 'x'=>'int', 'y'=>'int', 'char'=>'string', 'color'=>'int'],
'imagecolorallocate' => ['int|false', 'image'=>'resource', 'red'=>'int', 'green'=>'int', 'blue'=>'int'],
'imagecolorallocatealpha' => ['int|false', 'image'=>'resource', 'red'=>'int', 'green'=>'int', 'blue'=>'int', 'alpha'=>'int'],
'imagecolorat' => ['int|false', 'image'=>'resource', 'x'=>'int', 'y'=>'int'],
'imagecolorclosest' => ['int|false', 'image'=>'resource', 'red'=>'int', 'green'=>'int', 'blue'=>'int'],
'imagecolorclosestalpha' => ['int|false', 'image'=>'resource', 'red'=>'int', 'green'=>'int', 'blue'=>'int', 'alpha'=>'int'],
'imagecolorclosesthwb' => ['int|false', 'image'=>'resource', 'red'=>'int', 'green'=>'int', 'blue'=>'int'],
'imagecolordeallocate' => ['bool', 'image'=>'resource', 'color'=>'int'],
'imagecolorexact' => ['int|false', 'image'=>'resource', 'red'=>'int', 'green'=>'int', 'blue'=>'int'],
'imagecolorexactalpha' => ['int|false', 'image'=>'resource', 'red'=>'int', 'green'=>'int', 'blue'=>'int', 'alpha'=>'int'],
'imagecolormatch' => ['bool', 'image1'=>'resource', 'image2'=>'resource'],
'imagecolorresolve' => ['int|false', 'image'=>'resource', 'red'=>'int', 'green'=>'int', 'blue'=>'int'],
'imagecolorresolvealpha' => ['int|false', 'image'=>'resource', 'red'=>'int', 'green'=>'int', 'blue'=>'int', 'alpha'=>'int'],
'imagecolorset' => ['void', 'image'=>'resource', 'color'=>'int', 'red'=>'int', 'green'=>'int', 'blue'=>'int', 'alpha='=>'int'],
'imagecolorsforindex' => ['array|false', 'image'=>'resource', 'color'=>'int'],
'imagecolorstotal' => ['int|false', 'image'=>'resource'],
'imagecolortransparent' => ['int|false', 'image'=>'resource', 'color='=>'int'],
'imageconvolution' => ['bool', 'image'=>'resource', 'matrix'=>'array', 'divisor'=>'float', 'offset'=>'float'],
'imagecopy' => ['bool', 'dst_image'=>'resource', 'src_image'=>'resource', 'dst_x'=>'int', 'dst_y'=>'int', 'src_x'=>'int', 'src_y'=>'int', 'src_width'=>'int', 'src_height'=>'int'],
'imagecopymerge' => ['bool', 'dst_image'=>'resource', 'src_image'=>'resource', 'dst_x'=>'int', 'dst_y'=>'int', 'src_x'=>'int', 'src_y'=>'int', 'src_width'=>'int', 'src_height'=>'int', 'pct'=>'int'],
'imagecopymergegray' => ['bool', 'dst_image'=>'resource', 'src_image'=>'resource', 'dst_x'=>'int', 'dst_y'=>'int', 'src_x'=>'int', 'src_y'=>'int', 'src_width'=>'int', 'src_height'=>'int', 'pct'=>'int'],
'imagecopyresampled' => ['bool', 'dst_image'=>'resource', 'src_image'=>'resource', 'dst_x'=>'int', 'dst_y'=>'int', 'src_x'=>'int', 'src_y'=>'int', 'dst_width'=>'int', 'dst_height'=>'int', 'src_width'=>'int', 'src_height'=>'int'],
'imagecopyresized' => ['bool', 'dst_image'=>'resource', 'src_image'=>'resource', 'dst_x'=>'int', 'dst_y'=>'int', 'src_x'=>'int', 'src_y'=>'int', 'dst_width'=>'int', 'dst_height'=>'int', 'src_width'=>'int', 'src_height'=>'int'],
'imagecreate' => ['resource|false', 'x_size'=>'int', 'y_size'=>'int'],
'imagecreatefrombmp' => ['resource|false', 'filename'=>'string'],
'imagecreatefromgd' => ['resource|false', 'filename'=>'string'],
'imagecreatefromgd2' => ['resource|false', 'filename'=>'string'],
'imagecreatefromgd2part' => ['resource|false', 'filename'=>'string', 'srcx'=>'int', 'srcy'=>'int', 'width'=>'int', 'height'=>'int'],
'imagecreatefromgif' => ['resource|false', 'filename'=>'string'],
'imagecreatefromjpeg' => ['resource|false', 'filename'=>'string'],
'imagecreatefrompng' => ['resource|false', 'filename'=>'string'],
'imagecreatefromstring' => ['resource|false', 'image'=>'string'],
'imagecreatefromwbmp' => ['resource|false', 'filename'=>'string'],
'imagecreatefromwebp' => ['resource|false', 'filename'=>'string'],
'imagecreatefromxbm' => ['resource|false', 'filename'=>'string'],
'imagecreatefromxpm' => ['resource|false', 'filename'=>'string'],
'imagecreatetruecolor' => ['resource|false', 'x_size'=>'int', 'y_size'=>'int'],
'imagecrop' => ['resource|false', 'im'=>'resource', 'rect'=>'array'],
'imagecropauto' => ['resource|false', 'im'=>'resource', 'mode'=>'int', 'threshold'=>'float', 'color'=>'int'],
'imagedashedline' => ['bool', 'image'=>'resource', 'x1'=>'int', 'y1'=>'int', 'x2'=>'int', 'y2'=>'int', 'color'=>'int'],
'imagedestroy' => ['bool', 'image'=>'resource'],
'imageellipse' => ['bool', 'image'=>'resource', 'center_x'=>'int', 'center_y'=>'int', 'width'=>'int', 'height'=>'int', 'color'=>'int'],
'imagefill' => ['bool', 'image'=>'resource', 'x'=>'int', 'y'=>'int', 'color'=>'int'],
'imagefilledarc' => ['bool', 'image'=>'resource', 'center_x'=>'int', 'center_y'=>'int', 'width'=>'int', 'height'=>'int', 'start_angle'=>'int', 'end_angle'=>'int', 'color'=>'int', 'style'=>'int'],
'imagefilledellipse' => ['bool', 'image'=>'resource', 'center_x'=>'int', 'center_y'=>'int', 'width'=>'int', 'height'=>'int', 'color'=>'int'],
'imagefilledpolygon' => ['bool', 'image'=>'resource', 'points'=>'array', 'num_points_or_color'=>'int', 'color'=>'int'],
'imagefilledrectangle' => ['bool', 'image'=>'resource', 'x1'=>'int', 'y1'=>'int', 'x2'=>'int', 'y2'=>'int', 'color'=>'int'],
'imagefilltoborder' => ['bool', 'image'=>'resource', 'x'=>'int', 'y'=>'int', 'border_color'=>'int', 'color'=>'int'],
'imagefilter' => ['bool', 'image'=>'resource', 'filter'=>'int', 'args='=>'int', 'arg2='=>'int', 'arg3='=>'int', 'arg4='=>'int'],
'imageflip' => ['bool', 'image'=>'resource', 'mode'=>'int'],
'imagefttext' => ['array|false', 'image'=>'resource', 'size'=>'float', 'angle'=>'float', 'x'=>'int', 'y'=>'int', 'color'=>'int', 'font_filename'=>'string', 'text'=>'string', 'options='=>'array'],
'imagegammacorrect' => ['bool', 'image'=>'resource', 'input_gamma'=>'float', 'output_gamma'=>'float'],
'imagegd' => ['bool', 'image'=>'resource', 'file='=>'string|resource|null'],
'imagegd2' => ['bool', 'image'=>'resource', 'file='=>'string|resource|null', 'chunk_size='=>'int', 'mode='=>'int'],
'imagegetclip' => ['array<int,int>|false', 'im'=>'resource'],
'imagegif' => ['bool', 'image'=>'resource', 'file='=>'string|resource|null'],
'imagegrabscreen' => ['false|resource'],
'imagegrabwindow' => ['false|resource', 'window_handle'=>'int', 'client_area='=>'int'],
'imageinterlace' => ['int|false', 'image'=>'resource', 'enable='=>'int'],
'imageistruecolor' => ['bool', 'image'=>'resource'],
'imagejpeg' => ['bool', 'image'=>'resource', 'file='=>'string|resource|null', 'quality='=>'int'],
'imagejpeg\'1' => ['string|false', 'image'=>'resource', 'file='=>'null', 'quality='=>'int'],
'imagelayereffect' => ['bool', 'image'=>'resource', 'effect'=>'int'],
'imageline' => ['bool', 'image'=>'resource', 'x1'=>'int', 'y1'=>'int', 'x2'=>'int', 'y2'=>'int', 'color'=>'int'],
'imageopenpolygon' => ['bool', 'image'=>'resource', 'points'=>'array', 'num_points_or_color'=>'int', 'color'=>'int'],
'imagepalettecopy' => ['void', 'dst'=>'resource', 'src'=>'resource'],
'imagepalettetotruecolor' => ['bool', 'image'=>'resource'],
'imagepng' => ['bool', 'image'=>'resource', 'file='=>'string|resource|null', 'quality='=>'int', 'filters='=>'int'],
'imagepolygon' => ['bool', 'image'=>'resource', 'points'=>'array', 'num_points_or_color'=>'int', 'color'=>'int'],
'imagerectangle' => ['bool', 'image'=>'resource', 'x1'=>'int', 'y1'=>'int', 'x2'=>'int', 'y2'=>'int', 'color'=>'int'],
'imageresolution' => ['array|bool', 'image'=>'resource', 'resolution_x='=>'int', 'resolution_y='=>'int'],
'imagerotate' => ['resource|false', 'src_im'=>'resource', 'angle'=>'float', 'bgdcolor'=>'int', 'ignoretransparent='=>'int'],
'imagesavealpha' => ['bool', 'image'=>'resource', 'enable'=>'bool'],
'imagescale' => ['resource|false', 'im'=>'resource', 'new_width'=>'int', 'new_height='=>'int', 'method='=>'int'],
'imagesetbrush' => ['bool', 'image'=>'resource', 'brush'=>'resource'],
'imagesetclip' => ['bool', 'image'=>'resource', 'x1'=>'int', 'x2'=>'int', 'y1'=>'int', 'y2'=>'int'],
'imagesetinterpolation' => ['bool', 'image'=>'resource', 'method'=>'int'],
'imagesetpixel' => ['bool', 'image'=>'resource', 'x'=>'int', 'y'=>'int', 'color'=>'int'],
'imagesetstyle' => ['bool', 'image'=>'resource', 'style'=>'non-empty-array'],
'imagesetthickness' => ['bool', 'image'=>'resource', 'thickness'=>'int'],
'imagesettile' => ['bool', 'image'=>'resource', 'tile'=>'resource'],
'imagestring' => ['bool', 'image'=>'resource', 'font'=>'int', 'x'=>'int', 'y'=>'int', 'string'=>'string', 'color'=>'int'],
'imagestringup' => ['bool', 'image'=>'resource', 'font'=>'int', 'x'=>'int', 'y'=>'int', 'string'=>'string', 'color'=>'int'],
'imagesx' => ['int|false', 'image'=>'resource'],
'imagesy' => ['int|false', 'image'=>'resource'],
'imagetruecolortopalette' => ['bool', 'image'=>'resource', 'dither'=>'bool', 'num_colors'=>'int'],
'imagettftext' => ['false|array', 'image'=>'resource', 'size'=>'float', 'angle'=>'float', 'x'=>'int', 'y'=>'int', 'color'=>'int', 'font_filename'=>'string', 'text'=>'string'],
'imagewbmp' => ['bool', 'image'=>'resource', 'file='=>'string|resource|null', 'foreground_color='=>'int'],
'imagewebp' => ['bool', 'image'=>'resource', 'file='=>'string|resource|null', 'quality='=>'int'],
'imagexbm' => ['bool', 'image'=>'resource', 'filename='=>'?string', 'foreground_color='=>'int'],
'jpeg2wbmp' => ['bool', 'jpegname'=>'string', 'wbmpname'=>'string', 'dest_height'=>'int', 'dest_width'=>'int', 'threshold'=>'int'],
'ldap_sort' => ['bool', 'link_identifier'=>'resource', 'result_identifier'=>'resource', 'sortfilter'=>'string'],
'mb_convert_case' => ['string|false', 'string'=>'string', 'mode'=>'int', 'encoding='=>'string'],
'mb_convert_kana' => ['string|false', 'string'=>'string', 'mode='=>'string', 'encoding='=>'string'],
'mb_decode_numericentity' => ['string|false', 'string'=>'string', 'convmap'=>'array', 'encoding='=>'string', 'is_hex='=>'bool'],
'mb_encode_mimeheader' => ['string|false', 'string'=>'string', 'charset='=>'string', 'transfer_encoding='=>'string', 'newline='=>'string', 'indent='=>'int'],
'mb_encode_numericentity' => ['string|false', 'string'=>'string', 'map'=>'array', 'encoding='=>'string', 'hex='=>'bool'],
'mb_scrub' => ['string|false', 'string'=>'string', 'encoding='=>'string'],
'mb_strimwidth' => ['string|false', 'string'=>'string', 'start'=>'int', 'width'=>'int', 'trim_marker='=>'string', 'encoding='=>'string'],
'mb_strlen' => ['int|false', 'string'=>'string', 'encoding='=>'string'],
'mb_strtolower' => ['lowercase-string|false', 'string'=>'string', 'encoding='=>'string'],
'mb_strtoupper' => ['string|false', 'string'=>'string', 'encoding='=>'string'],
'mb_strwidth' => ['int|false', 'string'=>'string', 'encoding='=>'string'],
'mb_substr' => ['string|false', 'string'=>'string', 'start'=>'int', 'length='=>'?int', 'encoding='=>'string'],
'mb_substr_count' => ['int|false', 'haystack'=>'string', 'needle'=>'string', 'encoding='=>'string'],
'mktime' => ['int|false', 'hour='=>'int', 'minute='=>'int', 'second='=>'int', 'month='=>'int', 'day='=>'int', 'year='=>'int'],
'parse_str' => ['void', 'encoded_string'=>'string', '&w_result='=>'array'],
'password_hash' => ['string|false|null', 'password'=>'string', 'algo'=>'?string|?int', 'options='=>'array'],
'PDOStatement::bindColumn' => ['bool', 'column'=>'mixed', '&rw_param'=>'mixed', 'type='=>'int', 'maxlen='=>'int', 'driverdata='=>'mixed'],
'PDOStatement::bindParam' => ['bool', 'paramno'=>'mixed', '&rw_param'=>'mixed', 'type='=>'int', 'maxlen='=>'int', 'driverdata='=>'mixed'],
'PDOStatement::bindValue' => ['bool', 'paramno'=>'mixed', 'param'=>'mixed', 'type='=>'int'],
'PDOStatement::debugDumpParams' => ['void'],
'PDOStatement::errorCode' => ['string'],
'PDOStatement::execute' => ['bool', 'bound_input_params='=>'?array'],
'PDOStatement::fetch' => ['mixed', 'how='=>'int', 'orientation='=>'int', 'offset='=>'int'],
'PDOStatement::fetchAll' => ['array|false', 'how='=>'int', 'fetch_argument='=>'int|string|callable', 'ctor_args='=>'?array'],
'PDOStatement::fetchColumn' => ['string|int|float|bool|null', 'column_number='=>'int'],
'PDOStatement::fetchObject' => ['object|false', 'class_name='=>'string', 'ctor_args='=>'array'],
'PDOStatement::setFetchMode' => ['bool', 'mode'=>'int'],
'PDOStatement::setFetchMode\'1' => ['bool', 'fetch_column'=>'int', 'colno'=>'int'],
'PDOStatement::setFetchMode\'2' => ['bool', 'fetch_class'=>'int', 'classname'=>'string', 'ctorargs'=>'array'],
'PDOStatement::setFetchMode\'3' => ['bool', 'fetch_into'=>'int', 'object'=>'object'],
'png2wbmp' => ['bool', 'pngname'=>'string', 'wbmpname'=>'string', 'dest_height'=>'int', 'dest_width'=>'int', 'threshold'=>'int'],
'proc_get_status' => ['array<string,int|string|bool>|false', 'process'=>'resource'],
'read_exif_data' => ['array', 'filename'=>'string', 'sections_needed='=>'string', 'sub_arrays='=>'bool', 'read_thumbnail='=>'bool'],
'ReflectionClass::getConstants' => ['array<string,mixed>'],
'ReflectionType::isBuiltin' => ['bool'],
'socket_accept' => ['resource|false', 'socket'=>'resource'],
'socket_addrinfo_bind' => ['?resource', 'addrinfo'=>'resource'],
'socket_addrinfo_connect' => ['?resource', 'addrinfo'=>'resource'],
'socket_addrinfo_explain' => ['array', 'addrinfo'=>'resource'],
'socket_addrinfo_lookup' => ['resource[]', 'node'=>'string', 'service='=>'mixed', 'hints='=>'array'],
'socket_bind' => ['bool', 'socket'=>'resource', 'addr'=>'string', 'port='=>'int'],
'socket_clear_error' => ['void', 'socket='=>'resource'],
'socket_close' => ['void', 'socket'=>'resource'],
'socket_connect' => ['bool', 'socket'=>'resource', 'addr'=>'string', 'port='=>'int'],
'socket_create' => ['resource|false', 'domain'=>'int', 'type'=>'int', 'protocol'=>'int'],
'socket_create_listen' => ['resource|false', 'port'=>'int', 'backlog='=>'int'],
'socket_create_pair' => ['bool', 'domain'=>'int', 'type'=>'int', 'protocol'=>'int', '&w_fd'=>'resource[]'],
'socket_export_stream' => ['resource|false', 'socket'=>'resource'],
'socket_get_option' => ['mixed|false', 'socket'=>'resource', 'level'=>'int', 'optname'=>'int'],
'socket_get_status' => ['array', 'stream'=>'resource'],
'socket_getopt' => ['mixed', 'socket'=>'resource', 'level'=>'int', 'optname'=>'int'],
'socket_getpeername' => ['bool', 'socket'=>'resource', '&w_addr'=>'string', '&w_port='=>'int'],
'socket_getsockname' => ['bool', 'socket'=>'resource', '&w_addr'=>'string', '&w_port='=>'int'],
'socket_import_stream' => ['resource|false|null', 'stream'=>'resource'],
'socket_last_error' => ['int', 'socket='=>'resource'],
'socket_listen' => ['bool', 'socket'=>'resource', 'backlog='=>'int'],
'socket_read' => ['string|false', 'socket'=>'resource', 'length'=>'int', 'type='=>'int'],
'socket_recv' => ['int|false', 'socket'=>'resource', '&w_buf'=>'string', 'length'=>'int', 'flags'=>'int'],
'socket_recvfrom' => ['int|false', 'socket'=>'resource', '&w_buf'=>'string', 'length'=>'int', 'flags'=>'int', '&w_name'=>'string', '&w_port='=>'int'],
'socket_recvmsg' => ['int|false', 'socket'=>'resource', '&w_message'=>'string', 'flags='=>'int'],
'socket_select' => ['int|false', '&rw_read_fds'=>'resource[]|null', '&rw_write_fds'=>'resource[]|null', '&rw_except_fds'=>'resource[]|null', 'tv_sec'=>'int', 'tv_usec='=>'int'],
'socket_send' => ['int|false', 'socket'=>'resource', 'buf'=>'string', 'length'=>'int', 'flags'=>'int'],
'socket_sendmsg' => ['int|false', 'socket'=>'resource', 'message'=>'array', 'flags'=>'int'],
'socket_sendto' => ['int|false', 'socket'=>'resource', 'buf'=>'string', 'length'=>'int', 'flags'=>'int', 'addr'=>'string', 'port='=>'int'],
'socket_set_block' => ['bool', 'socket'=>'resource'],
'socket_set_blocking' => ['bool', 'socket'=>'resource', 'mode'=>'int'],
'socket_set_nonblock' => ['bool', 'socket'=>'resource'],
'socket_set_option' => ['bool', 'socket'=>'resource', 'level'=>'int', 'optname'=>'int', 'optval'=>'int|string|array'],
'socket_set_timeout' => ['bool', 'stream'=>'resource', 'seconds'=>'int', 'microseconds='=>'int'],
'socket_setopt' => ['void', 'socket'=>'resource', 'level'=>'int', 'optname'=>'int', 'optval'=>'int|string|array'],
'socket_shutdown' => ['bool', 'socket'=>'resource', 'how='=>'int'],
'socket_strerror' => ['string', 'errno'=>'int'],
'socket_write' => ['int|false', 'socket'=>'resource', 'buf'=>'string', 'length='=>'int'],
'socket_wsaprotocol_info_export' => ['string|false', 'stream'=>'resource', 'target_pid'=>'int'],
'socket_wsaprotocol_info_import' => ['resource|false', 'id'=>'string'],
'socket_wsaprotocol_info_release' => ['bool', 'id'=>'string'],
'sodium_crypto_aead_chacha20poly1305_ietf_decrypt' => ['?string|?false', 'confidential_message'=>'string', 'public_message'=>'string', 'nonce'=>'string', 'key'=>'string'],
'SplFileObject::fgetss' => ['string|false', 'allowable_tags='=>'string'],
'strchr' => ['string|false', 'haystack'=>'string', 'needle'=>'string|int', 'before_needle='=>'bool'],
'stripos' => ['int|false', 'haystack'=>'string', 'needle'=>'string|int', 'offset='=>'int'],
'stristr' => ['string|false', 'haystack'=>'string', 'needle'=>'string|int', 'before_needle='=>'bool'],
'strpos' => ['int|false', 'haystack'=>'string', 'needle'=>'string|int', 'offset='=>'int'],
'strrchr' => ['string|false', 'haystack'=>'string', 'needle'=>'string|int'],
'strripos' => ['int|false', 'haystack'=>'string', 'needle'=>'string|int', 'offset='=>'int'],
'strrpos' => ['int|false', 'haystack'=>'string', 'needle'=>'string|int', 'offset='=>'int'],
'strstr' => ['string|false', 'haystack'=>'string', 'needle'=>'string|int', 'before_needle='=>'bool'],
'timezone_identifiers_list' => ['list<string>|false', 'timezoneGroup='=>'int', 'countryCode='=>'?string'],
'xml_parser_create' => ['resource', 'encoding='=>'string'],
'xml_parser_create_ns' => ['resource', 'encoding='=>'string', 'sep='=>'string'],
'xml_parser_free' => ['bool', 'parser'=>'resource'],
'xml_parser_get_option' => ['mixed|false', 'parser'=>'resource', 'option'=>'int'],
'xml_parser_set_option' => ['bool', 'parser'=>'resource', 'option'=>'int', 'value'=>'mixed'],
'XMLWriter::flush' => ['string|int|false', 'empty='=>'bool'],
'XMLWriter::startAttributeNs' => ['bool', 'prefix'=>'string', 'name'=>'string', 'namespace'=>'?string'],
'XMLWriter::writeAttributeNs' => ['bool', 'prefix'=>'string', 'name'=>'string', 'namespace'=>'?string', 'value'=>'string'],
'XMLWriter::writeDtdEntity' => ['bool', 'name'=>'string', 'content'=>'string', 'isParam'=>'bool', 'publicId'=>'string', 'systemId'=>'string', 'notationData'=>'string'],
'xmlwriter_end_attribute' => ['bool', 'writer'=>'resource'],
'xmlwriter_end_cdata' => ['bool', 'writer'=>'resource'],
'xmlwriter_end_comment' => ['bool', 'writer'=>'resource'],
'xmlwriter_end_document' => ['bool', 'writer'=>'resource'],
'xmlwriter_end_dtd' => ['bool', 'writer'=>'resource'],
'xmlwriter_end_dtd_attlist' => ['bool', 'writer'=>'resource'],
'xmlwriter_end_dtd_element' => ['bool', 'writer'=>'resource'],
'xmlwriter_end_dtd_entity' => ['bool', 'writer'=>'resource'],
'xmlwriter_end_element' => ['bool', 'writer'=>'resource'],
'xmlwriter_end_pi' => ['bool', 'writer'=>'resource'],
'xmlwriter_flush' => ['string|int|false', 'writer'=>'resource', 'empty='=>'bool'],
'xmlwriter_full_end_element' => ['bool', 'writer'=>'resource'],
'xmlwriter_open_memory' => ['resource|false'],
'xmlwriter_open_uri' => ['resource|false', 'uri'=>'string'],
'xmlwriter_output_memory' => ['string', 'writer'=>'resource', 'flush='=>'bool'],
'xmlwriter_set_indent' => ['bool', 'writer'=>'resource', 'enable'=>'bool'],
'xmlwriter_set_indent_string' => ['bool', 'writer'=>'resource', 'indentation'=>'string'],
'xmlwriter_start_attribute' => ['bool', 'writer'=>'resource', 'name'=>'string'],
'xmlwriter_start_attribute_ns' => ['bool', 'writer'=>'resource', 'prefix'=>'string', 'name'=>'string', 'namespace'=>'?string'],
'xmlwriter_start_cdata' => ['bool', 'writer'=>'resource'],
'xmlwriter_start_comment' => ['bool', 'writer'=>'resource'],
'xmlwriter_start_document' => ['bool', 'writer'=>'resource', 'version='=>'?string', 'encoding='=>'?string', 'standalone='=>'?string'],
'xmlwriter_start_dtd' => ['bool', 'writer'=>'resource', 'qualifiedName'=>'string', 'publicId='=>'?string', 'systemId='=>'?string'],
'xmlwriter_start_dtd_attlist' => ['bool', 'writer'=>'resource', 'name'=>'string'],
'xmlwriter_start_dtd_element' => ['bool', 'writer'=>'resource', 'qualifiedName'=>'string'],
'xmlwriter_start_dtd_entity' => ['bool', 'writer'=>'resource', 'name'=>'string', 'isParam'=>'bool'],
'xmlwriter_start_element' => ['bool', 'writer'=>'resource', 'name'=>'string'],
'xmlwriter_start_element_ns' => ['bool', 'writer'=>'resource', 'prefix'=>'?string', 'name'=>'string', 'namespace'=>'?string'],
'xmlwriter_start_pi' => ['bool', 'writer'=>'resource', 'target'=>'string'],
'xmlwriter_text' => ['bool', 'writer'=>'resource', 'content'=>'string'],
'xmlwriter_write_attribute' => ['bool', 'writer'=>'resource', 'name'=>'string', 'value'=>'string'],
'xmlwriter_write_attribute_ns' => ['bool', 'writer'=>'resource', 'prefix'=>'string', 'name'=>'string', 'namespace'=>'?string', 'value'=>'string'],
'xmlwriter_write_cdata' => ['bool', 'writer'=>'resource', 'content'=>'string'],
'xmlwriter_write_comment' => ['bool', 'writer'=>'resource', 'content'=>'string'],
'xmlwriter_write_dtd' => ['bool', 'writer'=>'resource', 'name'=>'string', 'publicId='=>'?string', 'systemId='=>'?string', 'content='=>'?string'],
'xmlwriter_write_dtd_attlist' => ['bool', 'writer'=>'resource', 'name'=>'string', 'content'=>'string'],
'xmlwriter_write_dtd_element' => ['bool', 'writer'=>'resource', 'name'=>'string', 'content'=>'string'],
'xmlwriter_write_dtd_entity' => ['bool', 'writer'=>'resource', 'name'=>'string', 'content'=>'string', 'isParam'=>'bool', 'publicId'=>'string', 'systemId'=>'string', 'notationData'=>'string'],
'xmlwriter_write_element' => ['bool', 'writer'=>'resource', 'name'=>'string', 'content'=>'?string'],
'xmlwriter_write_element_ns' => ['bool', 'writer'=>'resource', 'prefix'=>'?string', 'name'=>'string', 'namespace'=>'string', 'content'=>'?string'],
'xmlwriter_write_pi' => ['bool', 'writer'=>'resource', 'target'=>'string', 'content'=>'string'],
'xmlwriter_write_raw' => ['bool', 'writer'=>'resource', 'content'=>'string'],
]
];
