<?php

namespace Pinq\Analysis\TypeData;

use Pinq\Analysis\INativeType;

/**
 * Type data for internal functions.
 *
 * @author Elliot Levin <elliotlevin@hotmail.com>
 */
class InternalFunctions extends TypeDataModule
{
    public function functions()
    {
        return $this->dataTypes() + $this->string() + $this->arrays() + $this->math();
    }

    protected function dataTypes()
    {
        return [
                'is_string'   => INativeType::TYPE_BOOL,
                'is_int'      => INativeType::TYPE_BOOL,
                'is_bool'     => INativeType::TYPE_BOOL,
                'is_float'    => INativeType::TYPE_BOOL,
                'is_object'   => INativeType::TYPE_BOOL,
                'is_array'    => INativeType::TYPE_BOOL,
                'is_resource' => INativeType::TYPE_BOOL,
                'is_scalar'   => INativeType::TYPE_BOOL,
                'is_null'     => INativeType::TYPE_BOOL,
                'is_callable' => INativeType::TYPE_BOOL,
                'gettype'     => INativeType::TYPE_STRING,
                'serialize'   => INativeType::TYPE_STRING,
                'boolval'     => INativeType::TYPE_BOOL,
                'intval'      => INativeType::TYPE_INT,
                'strval'      => INativeType::TYPE_STRING,
                'floatval'    => INativeType::TYPE_DOUBLE,
        ];
    }

    protected function string()
    {
        return [
                'addcslashes'                => INativeType::TYPE_STRING,
                'addslashes'                 => INativeType::TYPE_STRING,
                'bin2hex'                    => INativeType::TYPE_STRING,
                'chr'                        => INativeType::TYPE_STRING,
                'chunk_split'                => INativeType::TYPE_STRING,
                'convert_cyr_string'         => INativeType::TYPE_STRING,
                'convert_uudecode'           => INativeType::TYPE_STRING,
                'convert_uuencode'           => INativeType::TYPE_STRING,
                'crc32'                      => INativeType::TYPE_INT,
                'crypt'                      => INativeType::TYPE_STRING,
                'explode'                    => INativeType::TYPE_ARRAY,
                'fprintf'                    => INativeType::TYPE_INT,
                'get_html_translation_table' => INativeType::TYPE_ARRAY,
                'hebrev'                     => INativeType::TYPE_STRING,
                'hebrevc'                    => INativeType::TYPE_STRING,
                'hex2bin'                    => INativeType::TYPE_STRING,
                'html_entity_decode'         => INativeType::TYPE_STRING,
                'htmlentities'               => INativeType::TYPE_STRING,
                'htmlspecialchars_decode'    => INativeType::TYPE_STRING,
                'htmlspecialchars'           => INativeType::TYPE_STRING,
                'implode'                    => INativeType::TYPE_STRING,
                'lcfirst'                    => INativeType::TYPE_STRING,
                'levenshtein'                => INativeType::TYPE_INT,
                'localeconv'                 => INativeType::TYPE_ARRAY,
                'ltrim'                      => INativeType::TYPE_STRING,
                'md5_file'                   => INativeType::TYPE_STRING,
                'md5'                        => INativeType::TYPE_STRING,
                'metaphone'                  => INativeType::TYPE_STRING,
                'money_format'               => INativeType::TYPE_STRING,
                'nl_langinfo'                => INativeType::TYPE_STRING,
                'nl2br'                      => INativeType::TYPE_STRING,
                'number_format'              => INativeType::TYPE_STRING,
                'ord'                        => INativeType::TYPE_INT,
                'parse_str'                  => INativeType::TYPE_NULL,
                'print'                      => INativeType::TYPE_INT,
                'printf'                     => INativeType::TYPE_INT,
                'quoted_printable_decode'    => INativeType::TYPE_STRING,
                'quoted_printable_encode'    => INativeType::TYPE_STRING,
                'quotemeta'                  => INativeType::TYPE_STRING,
                'rtrim'                      => INativeType::TYPE_STRING,
                'setlocale'                  => INativeType::TYPE_STRING,
                'sha1_file'                  => INativeType::TYPE_STRING,
                'sha1'                       => INativeType::TYPE_STRING,
                'similar_text'               => INativeType::TYPE_INT,
                'soundex'                    => INativeType::TYPE_STRING,
                'sprintf'                    => INativeType::TYPE_STRING,
                'str_getcsv'                 => INativeType::TYPE_ARRAY,
                'str_pad'                    => INativeType::TYPE_STRING,
                'str_repeat'                 => INativeType::TYPE_STRING,
                'str_rot13'                  => INativeType::TYPE_STRING,
                'str_shuffle'                => INativeType::TYPE_STRING,
                'str_split'                  => INativeType::TYPE_ARRAY,
                'strcasecmp'                 => INativeType::TYPE_INT,
                'strcmp'                     => INativeType::TYPE_INT,
                'strcoll'                    => INativeType::TYPE_INT,
                'strcspn'                    => INativeType::TYPE_INT,
                'strip_tags'                 => INativeType::TYPE_STRING,
                'stripcslashes'              => INativeType::TYPE_STRING,
                'stripos'                    => INativeType::TYPE_INT,
                'stripslashes'               => INativeType::TYPE_STRING,
                'stristr'                    => INativeType::TYPE_STRING,
                'strlen'                     => INativeType::TYPE_INT,
                'strnatcasecmp'              => INativeType::TYPE_INT,
                'strnatcmp'                  => INativeType::TYPE_INT,
                'strncasecmp'                => INativeType::TYPE_INT,
                'strncmp'                    => INativeType::TYPE_INT,
                'strpbrk'                    => INativeType::TYPE_STRING,
                'strrchr'                    => INativeType::TYPE_STRING,
                'strrev'                     => INativeType::TYPE_STRING,
                'strripos'                   => INativeType::TYPE_INT,
                'strrpos'                    => INativeType::TYPE_INT,
                'strspn'                     => INativeType::TYPE_INT,
                'strstr'                     => INativeType::TYPE_STRING,
                'strtok'                     => INativeType::TYPE_STRING,
                'strtolower'                 => INativeType::TYPE_STRING,
                'strtoupper'                 => INativeType::TYPE_STRING,
                'strtr'                      => INativeType::TYPE_STRING,
                'substr_compare'             => INativeType::TYPE_INT,
                'substr_count'               => INativeType::TYPE_INT,
                'substr'                     => INativeType::TYPE_STRING,
                'trim'                       => INativeType::TYPE_STRING,
                'ucfirst'                    => INativeType::TYPE_STRING,
                'ucwords'                    => INativeType::TYPE_STRING,
                'vfprintf'                   => INativeType::TYPE_INT,
                'vprintf'                    => INativeType::TYPE_INT,
                'vsprintf'                   => INativeType::TYPE_STRING,
                'wordwrap'                   => INativeType::TYPE_STRING,
        ];
    }

    protected function arrays()
    {
        return [
                'array_change_key_case'   => INativeType::TYPE_ARRAY,
                'array_chunk'             => INativeType::TYPE_ARRAY,
                'array_column'            => INativeType::TYPE_ARRAY,
                'array_combine'           => INativeType::TYPE_ARRAY,
                'array_count_values'      => INativeType::TYPE_ARRAY,
                'array_diff_assoc'        => INativeType::TYPE_ARRAY,
                'array_diff_key'          => INativeType::TYPE_ARRAY,
                'array_diff_uassoc'       => INativeType::TYPE_ARRAY,
                'array_diff_ukey'         => INativeType::TYPE_ARRAY,
                'array_diff'              => INativeType::TYPE_ARRAY,
                'array_fill_keys'         => INativeType::TYPE_ARRAY,
                'array_fill'              => INativeType::TYPE_ARRAY,
                'array_filter'            => INativeType::TYPE_ARRAY,
                'array_flip'              => INativeType::TYPE_ARRAY,
                'array_intersect_assoc'   => INativeType::TYPE_ARRAY,
                'array_intersect_key'     => INativeType::TYPE_ARRAY,
                'array_intersect_uassoc'  => INativeType::TYPE_ARRAY,
                'array_intersect_ukey'    => INativeType::TYPE_ARRAY,
                'array_intersect'         => INativeType::TYPE_ARRAY,
                'array_key_exists'        => INativeType::TYPE_BOOL,
                'array_keys'              => INativeType::TYPE_ARRAY,
                'array_map'               => INativeType::TYPE_ARRAY,
                'array_merge_recursive'   => INativeType::TYPE_ARRAY,
                'array_merge'             => INativeType::TYPE_ARRAY,
                'array_multisort'         => INativeType::TYPE_BOOL,
                'array_pad'               => INativeType::TYPE_ARRAY,
                'array_product'           => INativeType::TYPE_MIXED,
                'array_push'              => INativeType::TYPE_INT,
                'array_replace_recursive' => INativeType::TYPE_ARRAY,
                'array_replace'           => INativeType::TYPE_ARRAY,
                'array_reverse'           => INativeType::TYPE_ARRAY,
                'array_slice'             => INativeType::TYPE_ARRAY,
                'array_splice'            => INativeType::TYPE_ARRAY,
                'array_sum'               => INativeType::TYPE_MIXED,
                'array_udiff_assoc'       => INativeType::TYPE_ARRAY,
                'array_udiff_uassoc'      => INativeType::TYPE_ARRAY,
                'array_udiff'             => INativeType::TYPE_ARRAY,
                'array_uintersect_assoc'  => INativeType::TYPE_ARRAY,
                'array_uintersect_uassoc' => INativeType::TYPE_ARRAY,
                'array_uintersect'        => INativeType::TYPE_ARRAY,
                'array_unique'            => INativeType::TYPE_ARRAY,
                'array_unshift'           => INativeType::TYPE_INT,
                'array_values'            => INativeType::TYPE_ARRAY,
                'array_walk_recursive'    => INativeType::TYPE_BOOL,
                'array_walk'              => INativeType::TYPE_BOOL,
                'arsort'                  => INativeType::TYPE_BOOL,
                'asort'                   => INativeType::TYPE_BOOL,
                'compact'                 => INativeType::TYPE_ARRAY,
                'count'                   => INativeType::TYPE_INT,
                'each'                    => INativeType::TYPE_ARRAY,
                'extract'                 => INativeType::TYPE_INT,
                'in_array'                => INativeType::TYPE_BOOL,
                'krsort'                  => INativeType::TYPE_BOOL,
                'ksort'                   => INativeType::TYPE_BOOL,
                'list'                    => INativeType::TYPE_ARRAY,
                'natcasesort'             => INativeType::TYPE_BOOL,
                'natsort'                 => INativeType::TYPE_BOOL,
                'range'                   => INativeType::TYPE_ARRAY,
                'rsort'                   => INativeType::TYPE_BOOL,
                'shuffle'                 => INativeType::TYPE_BOOL,
                'sort'                    => INativeType::TYPE_BOOL,
                'uasort'                  => INativeType::TYPE_BOOL,
                'uksort'                  => INativeType::TYPE_BOOL,
                'usort'                   => INativeType::TYPE_BOOL,
        ];
    }

    protected function math()
    {
        return [
                'acos'          => INativeType::TYPE_DOUBLE,
                'acosh'         => INativeType::TYPE_DOUBLE,
                'asin'          => INativeType::TYPE_DOUBLE,
                'asinh'         => INativeType::TYPE_DOUBLE,
                'atan2'         => INativeType::TYPE_DOUBLE,
                'atan'          => INativeType::TYPE_DOUBLE,
                'atanh'         => INativeType::TYPE_DOUBLE,
                'base_convert'  => INativeType::TYPE_STRING,
                'ceil'          => INativeType::TYPE_DOUBLE,
                'cos'           => INativeType::TYPE_DOUBLE,
                'cosh'          => INativeType::TYPE_DOUBLE,
                'decbin'        => INativeType::TYPE_STRING,
                'dechex'        => INativeType::TYPE_STRING,
                'decoct'        => INativeType::TYPE_STRING,
                'deg2rad'       => INativeType::TYPE_DOUBLE,
                'exp'           => INativeType::TYPE_DOUBLE,
                'expm1'         => INativeType::TYPE_DOUBLE,
                'floor'         => INativeType::TYPE_DOUBLE,
                'fmod'          => INativeType::TYPE_DOUBLE,
                'getrandmax'    => INativeType::TYPE_INT,
                'hypot'         => INativeType::TYPE_DOUBLE,
                'is_finite'     => INativeType::TYPE_BOOL,
                'is_infinite'   => INativeType::TYPE_BOOL,
                'is_nan'        => INativeType::TYPE_BOOL,
                'lcg_value'     => INativeType::TYPE_DOUBLE,
                'log10'         => INativeType::TYPE_DOUBLE,
                'log1p'         => INativeType::TYPE_DOUBLE,
                'log'           => INativeType::TYPE_DOUBLE,
                'mt_getrandmax' => INativeType::TYPE_INT,
                'mt_rand'       => INativeType::TYPE_INT,
                'pi'            => INativeType::TYPE_DOUBLE,
                'rad2deg'       => INativeType::TYPE_DOUBLE,
                'rand'          => INativeType::TYPE_INT,
                'round'         => INativeType::TYPE_DOUBLE,
                'sin'           => INativeType::TYPE_DOUBLE,
                'sinh'          => INativeType::TYPE_DOUBLE,
                'sqrt'          => INativeType::TYPE_DOUBLE,
                'tan'           => INativeType::TYPE_DOUBLE,
                'tanh'          => INativeType::TYPE_DOUBLE,
        ];
    }
}
