CHANGELOG for 7.2.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 7.2 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v7.2.0...v7.2.1

* 7.2.5 (2025-03-28)

 * bug #60054 [Form] Use duplicate_preferred_choices to set value of ChoiceType (aleho)
 * bug #60026 [Serializer] Fix ObjectNormalizer default context with named serializers (HypeMC)
 * bug #60030 [Cache][DoctrineBridge][HttpFoundation][Lock][Messenger] use `Table::addPrimaryKeyConstraint()` with Doctrine DBAL 4.3+ (xabbuh)
 * bug #59844 [TypeInfo] Fix `isSatisfiedBy` not traversing type tree (mtarld)
 * bug #59858 Update `JsDelivrEsmResolver::IMPORT_REGEX` to support dynamic imports (natepage)
 * bug #60019 [HttpKernel] Fix `TraceableEventDispatcher` when the `Stopwatch` service has been reset (lyrixx)
 * bug #59975 [HttpKernel] Only remove `E_WARNING` from error level during kernel init (fritzmg)
 * bug #59988 [FrameworkBundle] Remove redundant `name` attribute from `default_context` (HypeMC)
 * bug #59963 [TypeInfo] Fix ``@var`` tag reading for promoted properties (mtarld)
 * bug #59949 [Process] Use a pipe for stderr in pty mode to avoid mixed output between stdout and stderr (joelwurtz)
 * bug #59940 [Cache] Fix missing cache data in profiler (dcmbrs)
 * bug #59965 [VarExporter] Fix support for hooks and asymmetric visibility (nicolas-grekas)
 * bug #59924 Extract no type ``@param`` annotation with `PhpStanExtractor` (thomasdubuffet)
 * bug #59908 [Messenger] Reduce keepalive request noise (ro0NL)
 * bug #59874 [Console] fix progress bar messing output in section when there is an EOL (joelwurtz)
 * bug #59888 [PhpUnitBridge] don't trigger "internal" deprecations for PHPUnit Stub objects (xabbuh)
 * bug #59830 [Yaml] drop comments while lexing unquoted strings (xabbuh)
 * bug #59884 [VarExporter] Fix support for asymmetric visibility (nicolas-grekas)
 * bug #59881 [VarExporter] Fix support for abstract properties (nicolas-grekas)
 * bug #59841 [Cache] fix cache data collector on late collect (dcmbrs)

* 7.2.4 (2025-02-26)

 * bug #59198 [Messenger] Filter out non-consumable receivers when registering `ConsumeMessagesCommand` (wazum)
 * bug #59781 [Mailer] fix multiple transports default injection (fkropfhamer)
 * bug #59836 [Mailer][Postmark] Set CID for attachments when it exists (IssamRaouf)
 * bug #59829 [FrameworkBundle] Disable the keys normalization of the CSRF form field attributes (sukei)
 * bug #59840 Fix PHP warning in GetSetMethodNormalizer when a "set()" method is defined (Pepperoni1337)
 * bug #59818 [TypeInfo] Fix create union with nullable type (mtarld)
 * bug #59810 [DependencyInjection] Defer check for circular references instead of skipping them (biozshock)
 * bug #59811 [Validator] Synchronize IBAN formats (alexandre-daubois)
 * bug #59796 [Mime] use address for body at `PathHeader` (tinect)
 * bug #59803 [Semaphore] allow redis cluster/sentinel dsn (smoench)
 * bug #59779 [DomCrawler] Bug #43921  Check for null parent nodes in the case of orphaned branches (ttk)
 * bug #59776 [WebProfilerBundle] fix rendering notifier message options (xabbuh)
 * bug #59769 Enable `JSON_PRESERVE_ZERO_FRACTION` in `jsonRequest` method (raffaelecarelle)
 * bug #59774 [TwigBridge] Fix compatibility with Twig 3.21 (alexandre-daubois)
 * bug #59761 [VarExporter] Fix lazy objects with hooked properties (nicolas-grekas)
 * bug #59763 [HttpClient] Don't send any default content-type when the body is empty (nicolas-grekas)
 * bug #59747 [Translation] check empty notes (davidvancl)
 * bug #59751 [Cache] Tests for Redis Replication with cache (DemigodCode)
 * bug #59752 [BrowserKit] Fix submitting forms with empty file fields (nicolas-grekas)
 * bug #59742 [Notifier] [BlueSky] Change the value returned as the message ID (javiereguiluz)
 * bug #59033 [WebProfilerBundle] Fix interception for non conventional redirects (Huluti)
 * bug #59713 [DependencyInjection] Do not preload functions (biozshock)
 * bug #59723 [DependencyInjection] Fix cloned lazy services not sharing their dependencies when dumped with PhpDumper (pvandommelen)
 * bug #59727 [HttpClient] Fix activity tracking leading to negative timeout errors (nicolas-grekas)
 * bug #59728 [Form][FrameworkBundle] Use auto-configuration to make the default CSRF token id apply only to the app; not to bundles (nicolas-grekas)
 * bug #59262 [DependencyInjection] Fix env default processor with scalar node (tBibaut)
 * bug #59699 [Serializer] Handle default context in named Serializer (HypeMC)
 * bug #59640 [Security] Return null instead of empty username to fix deprecation notice (phasdev)
 * bug #59661 [Lock] Fix Predis error handling (HypeMC)
 * bug #59596 [Mime] use `isRendered` method to ensure we can avoid rendering an email twice (walva)
 * bug #59689 [HttpClient] Fix buffering AsyncResponse with no passthru (nicolas-grekas)
 * bug #59654 [HttpClient] Fix uploading files > 2GB (nicolas-grekas)
 * bug #59648 [HttpClient] Fix retrying requests with `Psr18Client` and NTLM connections (nicolas-grekas, ajgarlag)
 * bug #59681 [TypeInfo] Fix promoted property phpdoc reading (mtarld)

* 7.2.3 (2025-01-29)

 * bug #58889 [Serializer] Handle default context in Serializer (Valmonzo)
 * bug #59631 [HttpClient] Fix processing a NativeResponse after its client has been reset (Jean-Beru)
 * bug #59590 [Security] Throw an explicit error when refreshing a token with a null user (alexandre-daubois)
 * bug #59625 [FrameworkBundle] Add missing `not-compromised-password` entry in XSD (alexandre-daubois)
 * bug #59610 [Mailer] Ensure TransportExceptionInterface populates stream debug data (bytestream)
 * bug #59598 [Mime] Fix body validity check in `Email` when using `Message::setBody()` (alexandre-daubois)
 * bug #59513 [Messenger ] Extract retry delay from nested `RecoverableExceptionInterface` (AydinHassan)
 * bug #59544 [AssetMapper] Fix CssCompiler matches url in comments (smnandre)
 * bug #59575 [DoctrineBridge] Add support for doctrine/persistence 4 (greg0ire)
 * bug #59611 [Mailer][Notifier] Fix channel parameter value to fixed value for Mailer and Notifier Sweego Transports (welcoMattic)
 * bug #59399 [DomCrawler] Make `ChoiceFormField::isDisabled` return `true` for unchecked disabled checkboxes (MatTheCat)
 * bug #59581 [Cache] Don't clear system caches on `cache:clear` (nicolas-grekas)
 * bug #59579 [FrameworkBundle] Fix patching refs to the tmp warmup dir in files generated by optional cache warmers (nicolas-grekas)
 * bug #59580 [Config] Add missing `json_encode` flags when creating `.meta.json` files (nicolas-grekas)
 * bug #57459 [PropertyInfo] convert legacy types to TypeInfo types if getType() is not implemented (xabbuh)
 * bug #59525 [HtmlSanitizer] Fix access to undefined keys in UrlSanitizer (Antoine Beyet)
 * bug #59538 [VarDumper] fix dumped markup (xabbuh)
 * bug #59508 [Messenger] [AMQP] Improve AMQP connection issues (AurelienPillevesse)
 * bug #59501 [Serializer] [ObjectNormalizer] Filter int when using FILTER_BOOL (DjordyKoert)
 * bug #59515 [FrameworkBundle] Fix wiring ConsoleProfilerListener (nicolas-grekas)
 * bug #59136 [DependencyInjection] Reset env vars with `kernel.reset` (faizanakram99)
 * bug #59488 [Lock] Make sure RedisStore will also support Valkey (PatNowak)
 * bug #59486 [Validator] Update sr_Cyrl 120:This value is not a valid slug. (kaznovac)
 * bug #59403 [FrameworkBundle][HttpFoundation] Reset Request's formats using the service resetter (nicolas-grekas)
 * bug #59404 [Mailer] Fix SMTP stream EOF handling on Windows by using feof() (skmedix)
 * bug #59390 [VarDumper] Fix blank strings display (MatTheCat)
 * bug #59446 [Routing] Fix configuring a single route's hosts (MatTheCat)
 * bug #58901 [HttpClient] Ignore RuntimeExceptions thrown when rewinding the PSR-7 created in HttplugWaitLoop::createPsr7Response (KurtThiemann)
 * bug #59046 [HttpClient] Fix Undefined array key `connection` (PhilETaylor)
 * bug #59055 [HttpFoundation] Fixed `IpUtils::anonymize` exception when using IPv6 link-local addresses with RFC4007 scoping (jbtronics)
 * bug #59256 [Mailer] Fix Sendmail memory leak (rch7)
 * bug #59375 [RemoteEvent][Webhook] fix SendgridPayloadConverter category support (ericabouaf)
 * bug #59367 [PropertyInfo] Make sure that SerializerExtractor returns null for invalid class metadata (wuchen90)
 * bug #59376 [RemoteEvent][Webhook] Fix `SendgridRequestParser` and `SendgridPayloadConverter` (ericabouaf)
 * bug #59381 [Yaml] fix inline notation with inline comment (alexpott)
 * bug #59352 [Messenger] Fix `TransportMessageIdStamp` not always added (HypeMC)
 * bug #59185 [DoctrineBridge] Fix compatibility to Doctrine persistence 2.5 in Doctrine Bridge 6.4 to avoid Projects stuck on 6.3 (alexander-schranz)
 * bug #59245 [PropertyInfo] Fix add missing composer conflict (mtarld)
 * bug #59292 [WebProfilerBundle] Fix event delegation on links inside toggles (MatTheCat)
 * bug #59362 [Doctrine][Messenger] Prevents multiple TransportMessageIdStamp being stored in envelope (rtreffler)
 * bug #59323 [Serializer] Fix exception thrown by `YamlEncoder` (VincentLanglet)
 * bug #59293 [AssetMapper] Fix JavaScript compiler creates self-referencing imports (smnandre)
 * bug #59296 [Form] do not render hidden CSRF token forms with autocomplete set to off (xabbuh)
 * bug #59349 [Yaml] reject inline notations followed by invalid content (xabbuh)
 * bug #59229 [WebProfilerBundle] fix loading of toolbar stylesheet (alexislefebvre)
 * bug #59363 [VarDumper] Fix displaying closure's "this" from anonymous classes (nicolas-grekas)
 * bug #59364 [ErrorHandler] Don't trigger "internal" deprecations for anonymous LazyClosure instances (nicolas-grekas)
 * bug #59221 [PropertyAccess] Fix compatibility with PHP 8.4 asymmetric visibility (Florian-Merle)
 * bug #59348 [Lock] Fix predis command error checking (dciprian-petrisor)
 * bug #59357 [HttpKernel] Don't override existing `LoggerInterface` autowiring alias in `LoggerPass` (nicolas-grekas)
 * bug #59347 [Security] Fix triggering session tracking from ContextListener (nicolas-grekas)
 * bug #59146 [Security] Use the session only if it is started when using `SameOriginCsrfTokenManager` (Thibault G)
 * bug #59188 [HttpClient] Fix `reset()` not called on decorated clients (HypeMC)
 * bug #59339 [SecurityBundle] Remove outdated guard from security xsd schema (chalasr)
 * bug #59343 [Security] Adjust parameter order in exception message (Link1515)
 * bug #59342 [SecurityBundle] Do not pass traceable authenticators to `security.helper` (MatTheCat)
 * bug #59320 [HttpClient] fix amphp http client v5 unix socket (praswicaksono)
 * bug #59312 [Yaml] Fix parsing of unquoted strings in Parser::lexUnquotedString() to ignore spaces (Link1515)
 * bug #59334 [ErrorHandler] [A11y] Simple proposal for color updates on error stack traces against colorblindness (DocFX)

* 7.2.2 (2024-12-31)

 * bug #59304 [PropertyInfo] Remove ``@internal`` from `PropertyReadInfo` and `PropertyWriteInfo` (Dario Guarracino)
 * bug #59252 [Stopwatch] bug #54854  undefined key error when trying to fetch a mis… (Alex Niedre)
 * bug #59278 [SecurityBundle] Do not replace authenticators service by their traceable version (MatTheCat)
 * bug #59228 [HttpFoundation] Avoid mime type guess with temp files in `BinaryFileResponse` (alexandre-daubois)
 * bug #59318 [Finder] Fix using `==` as default operator in `DateComparator` (MatTheCat)
 * bug #59321 [HtmlSanitizer] reject URLs containing whitespaces (xabbuh)
 * bug #59310 [Validator] the "max" option can be zero (xabbuh)
 * bug #59271 [TypeInfo] Fix PHPDoc resolving of union with mixed (mtarld)
 * bug #59269 [Security/Csrf] Trust "Referer" at the same level as "Origin" (nicolas-grekas)
 * bug #59250 [HttpClient] Fix a typo in NoPrivateNetworkHttpClient (Jontsa)
 * bug #59103 [Messenger] ensure exception on rollback does not hide previous exception (nikophil)
 * bug #59226 [FrameworkBundle] require the writer to implement getFormats() in the translation:extract (xabbuh)
 * bug #59213 [FrameworkBundle] don't require fake notifier transports to be installed as non-dev dependencies (xabbuh)
 * bug #59113 [FrameworkBundle][Translation] fix translation lint compatibility with the `PseudoLocalizationTranslator` (xabbuh)
 * bug #59060 [Validator] set the violation path only if the `errorPath` option is set (xabbuh)
 * bug #59066 Fix resolve enum in string type resolver (DavidBadura)
 * bug #59156 [PropertyInfo]  Fix interface handling in PhpStanTypeHelper (mtarld)
 * bug #59160 [BeanstalkMessenger] Round delay to an integer to avoid deprecation warning (plantas)
 * bug #59012 [PropertyInfo] Fix interface handling in `PhpStanTypeHelper` (janedbal)
 * bug #59134 [HttpKernel] Denormalize request data using the csv format when using "#[MapQueryString]" or "#[MapRequestPayload]" (except for content data) (ovidiuenache)
 * bug #59140 [WebProfilerBundle] fix: white-space in highlighted code (chr-hertel)

* 7.2.1 (2024-12-11)

 * bug #59145 [TypeInfo] Make `Type::nullable` method no-op on every nullable type (mtarld)
 * bug #59122 [Notifier] fix desktop channel bus abstract arg (raphael-geffroy)
 * bug #59124 [FrameworkBundle] fix: notifier push channel bus abstract arg (raphael-geffroy)
 * bug #59069 [Console] Fix division by 0 error (Rindula)
 * bug #59086 [FrameworkBundle] Make uri_signer lazy and improve error when kernel.secret is empty (nicolas-grekas)
 * bug #59099 [sendgrid-mailer] Fix null check on region (AUDUL)
 * bug #59070 [PropertyInfo] evaluate access flags for properties with asymmetric visibility (xabbuh)
 * bug #59062 [HttpClient] Always set CURLOPT_CUSTOMREQUEST to the correct HTTP method in CurlHttpClient (KurtThiemann)
 * bug #59059 [TwigBridge] generate conflict-free variable names (xabbuh)

* 7.2.0 (2024-11-29)

 * bug #59023 [HttpClient] Fix streaming and redirecting with NoPrivateNetworkHttpClient (nicolas-grekas)
 * bug #59014 [Form] Allow integer for the `calendar` option of `DateType` (alexandre-daubois)
 * bug #59013 [HttpClient] Fix checking for private IPs before connecting (nicolas-grekas)
 * bug #58562 [HttpClient] Close gracefull when the server closes the connection abruptly (discordier)
 * bug #59007 [Dotenv] read runtime config from composer.json in debug dotenv command (xabbuh)
 * bug #58963 [PropertyInfo] Fix write visibility for Asymmetric Visibility and Virtual Properties (xabbuh, pan93412)
 * bug #58983 [Translation] [Bridge][Lokalise] Fix empty keys array in PUT, DELETE requests causing Lokalise API error (DominicLuidold)
 * bug #58956 [DoctrineBridge] Fix `Connection::createSchemaManager()` for Doctrine DBAL v2 (neodevcode)
 * bug #58959 [PropertyInfo] consider write property visibility to decide whether a property is writable (xabbuh)
 * bug #58964 [TwigBridge] do not add child nodes to EmptyNode instances (xabbuh)
 * bug #58950 [FrameworkBundle] Revert " Deprecate making `cache.app` adapter taggable" (keulinho)
 * bug #58952 [Cache] silence warnings issued by Redis Sentinel on connection issues (xabbuh)
 * bug #58953 [HttpClient] Fix computing stats for PUSH with Amp (nicolas-grekas)
 * bug #58943 [FrameworkBundle] Revert " Don't auto-register form/csrf when the corresponding components are not installed" (nicolas-grekas)
 * bug #58937 [FrameworkBundle] Don't auto-register form/csrf when the corresponding components are not installed (nicolas-grekas)
 * bug #58859 [AssetMapper] ignore missing directory in `isVendor()` (alexislefebvre)
 * bug #58917 [OptionsResolver] Allow Union/Intersection Types in Resolved Closures (zanbaldwin)
 * bug #58822 [DependencyInjection] Fix checking for interfaces in ContainerBuilder::getReflectionClass() (donquixote)
 * bug #58865 Dynamically fix compatibility with doctrine/data-fixtures v2 (greg0ire)
 * bug #58921 [HttpKernel] Ensure `HttpCache::getTraceKey()` does not throw exception (lyrixx)
 * bug #58908 [DoctrineBridge] don't call `EntityManager::initializeObject()` with scalar values (xabbuh)
 * bug #58938 [Cache] make RelayProxyTrait compatible with relay extension 0.9.0 (xabbuh)
 * bug #58924 [HttpClient] Fix empty hosts in option "resolve" (nicolas-grekas)
 * bug #58915 [HttpClient] Fix option "resolve" with IPv6 addresses (nicolas-grekas)
 * bug #58919 [WebProfilerBundle] Twig deprecations (mazodude)
 * bug #58914 [HttpClient] Fix option "bindto" with IPv6 addresses (nicolas-grekas)
 * bug #58888 [Mailer][Notifier] Sweego is backing their bridges, thanks to them! (nicolas-grekas)
 * bug #58885 [PropertyInfo][Serializer][TypeInfo][Validator] TypeInfo 7.1 compatibility (mtarld)
 * bug #58870 [Serializer][Validator] prevent failures around not existing TypeInfo classes (xabbuh)
 * bug #58872 [PropertyInfo][Serializer][Validator] TypeInfo 7.2 compatibility (mtarld)
 * bug #58875 [HttpClient] Removed body size limit (Carl Julian Sauter)
 * bug #58866 [Validator] fix compatibility with PHP < 8.2.4 (xabbuh)
 * bug #58862 [Notifier] Fix GoIpTransport (nicolas-grekas)
 * bug #58860 [HttpClient] Fix catching some invalid Location headers (nicolas-grekas)
 * bug #58834 [FrameworkBundle] ensure `validator.translation_domain` parameter is always set (xabbuh)
 * bug #58836 Work around `parse_url()` bug (bis) (nicolas-grekas)
 * bug #58818 [Messenger] silence PHP warnings issued by `Redis::connect()` (xabbuh)
 * bug #58828 [PhpUnitBridge] fix dumping tests to skip with data providers (xabbuh)
 * bug #58842 [Routing] Fix: lost priority when defining hosts in configuration (BeBlood)
 * bug #58850 [HttpClient] fix PHP 7.2 compatibility (xabbuh)

* 7.2.0-RC1 (2024-11-13)

 * feature #58852 [TypeInfo] Remove ``@experimental`` tag (mtarld)
 * feature #57630 [TypeInfo] Redesign Type methods and nullability (mtarld)
 * security #cve-2024-50342 [HttpClient] Resolve hostnames in NoPrivateNetworkHttpClient (nicolas-grekas)
 * security #cve-2024-51996 [Security] Check owner of persisted remember-me cookie (jderusse)
 * bug #58799 [String] Fix some spellings in `EnglishInflector` (alexandre-daubois)
 * bug #58823 [TwigBridge] Fix emojify as function in Undefined Handler (smnandre)
 * bug #56868 [Serializer] fixed object normalizer for a class with `cancel` method (er1z)
 * feature #58483 [Messenger] Extend SQS visibility timeout for messages that are still being processed (valtzu)
 * bug #58601 [RateLimiter] Fix bucket size reduced when previously created with bigger size (Orkin)
 * bug #58659 [AssetMapper] Fix `JavaScriptImportPathCompiler` regex for non-latin characters (GregRbs92)
 * bug #58658 [Twitter][Notifier] Fix post INIT upload (matyo91)
 * bug #58705 [Serializer] Revert Default groups (mtarld)
 * bug #58763 [Messenger][RateLimiter] fix additional message handled when using a rate limiter (Jean-Beru)
 * bug #58791 [RateLimiter] handle error results of DateTime::modify() (xabbuh)
 * bug #58804 [Serializer][TypeInfo] fix support for phpstan/phpdoc-parser 2 (xabbuh)
 * bug #58800 [PropertyInfo] fix support for phpstan/phpdoc-parser 2 (xabbuh)

* 7.2.0-BETA2 (2024-11-06)

 * bug #58776 [DependencyInjection][HttpClient][Routing] Reject URIs that contain invalid characters (nicolas-grekas)
 * bug #58772 [DoctrineBridge] Backport detection fix of Xml/Yaml driver in DoctrineExtension (MatTheCat)
 * bug #58706 [TwigBridge] use reproducible variable names in the default domain node visitor (xabbuh)
 * security #cve-2024-51736 [Process] Use PATH before CD to load the shell on Windows (nicolas-grekas)
 * security #cve-2024-50342 [HttpClient] Filter private IPs before connecting when Host == IP (nicolas-grekas)
 * security #cve-2024-50345 [HttpFoundation] Reject URIs that contain invalid characters (nicolas-grekas)
 * security #cve-2024-50340 [Runtime] Do not read from argv on non-CLI SAPIs (wouterj)
 * bug #58765 [VarDumper] fix detecting anonymous exception classes on Windows and PHP 7 (xabbuh)
 * bug #58757 [RateLimiter] Fix DateInterval normalization (danydev)
 * bug #58764 [Mime] Don't require passing the encoder name to `TextPart` (javiereguiluz)
 * bug #58712 [HttpFoundation] Fix support for `\SplTempFileObject` in `BinaryFileResponse` (elementaire)
 * bug #58762 [WebProfilerBundle] re-add missing profiler shortcuts on profiler homepage (xabbuh)
 * bug #58754 [Security] Store original token in token storage when implicitly exiting impersonation (wouterj)
 * bug #58753 [Cache] Fix clear() when using Predis (nicolas-grekas)
 * bug #58713 [Config] Handle Phar absolute path in `FileLocator` (alexandre-daubois)
 * bug #58728 [WebProfilerBundle] Re-add missing Profiler shortcuts on Profiler homepage (welcoMattic)
 * bug #58739 [WebProfilerBoundle] form data collector check passed and resolved options are defined (vltrof)
 * bug #58752 [Process] Fix escaping /X arguments on Windows (nicolas-grekas)
 * bug #58735 [Process] Return built-in cmd.exe commands directly in ExecutableFinder (Seldaek)
 * bug #58723 [Process] Properly deal with not-found executables on Windows (nicolas-grekas)
 * bug #58711 [Process] Fix handling empty path found in the PATH env var with ExecutableFinder (nicolas-grekas)
 * bug #58704 [HttpClient] fix for HttpClientDataCollector fails if proc_open is disabled via php.ini (ZaneCEO)
 * bug #58703 [TwigBridge] Use INTERNAL_VAR_NAME instead of getVarName (pan93412)

* 7.2.0-BETA1 (2024-10-27)

 * feature #58467 [PhpUnitBridge] support `ClockMock` and `DnsMock` with PHPUnit 10+ (xabbuh)
 * feature #58506 [FrameworkBundle] Add `--no-fill` option to `translation:extract` command (jawira)
 * feature #58428 [Config] Add `StringNode` (raffaelecarelle)
 * feature #58322 [Notifier] Add Sweego bridge (welcoMattic)
 * feature #58527 [Notifier] Add LINE Bot bridge (pan93412)
 * feature #58552 [Console][Messenger] Add `$seconds` to `keepalive()` methods (valtzu)
 * feature #51041 [Form] Use `form.post_set_data` in `ResizeFormListener` (HeahDude)
 * feature #58287 [WebProfilerBundle] Render the toolbar stylesheet (smnandre)
 * feature #58512 [Validator] Pass context to expressions used in `When` constraints (KoNekoD)
 * feature #52503 [DoctrineBridge][Form] Introducing new `LazyChoiceLoader` class and `choice_lazy` option for `ChoiceType` (yceruto)
 * feature #58109 [Lock] Add `NullStore` (xabbuh)
 * feature #58490 [Config] Allow using `defaultNull()` on `BooleanNodeDefinition` (alexandre-daubois)
 * feature #58095 [Security] Implement stateless headers/cookies-based CSRF protection (nicolas-grekas)
 * feature #53508 [Console][Messenger] Asynchronously notify transports which messages are still being processed (HypeMC)
 * feature #57829 [FrameworkBundle] Finetune `AboutCommand` (JoppeDC)
 * feature #58264 [Mailer] Support region in sendgrid bridge (MrYamous)
 * feature #50324 [Webhook] Add Mailchimp webhook (johanadivare)
 * feature #58361 [Mailer][Mime] Support unicode email addresses (arnt, OskarStark)
 * feature #53533 [Console] Add ability to schedule alarm signals and a `ConsoleAlarmEvent` (HypeMC)
 * feature #54664 [DependencyInjection] Resolve container parameter used in index attribute of service tags (Marvin Feldmann)
 * feature #57576 [Console] Add finished indicator to `ProgressIndicator` (LauLaman)
 * feature #58448 [TwigBridge] Update main.css email stylesheet to latest foundation-emails release (phasdev)
 * feature #58408 [Translation] Allow sort when extracting translation files (danut007ro)
 * feature #58427 [Notifier] [GatewayAPI] Add support for label parameter (Nico Hiort af Ornäs)
 * feature #58341 [ExpressionLanguage] Add support for logical `xor` operator (HypeMC)
 * feature #58385 [String] Add the `AbstractString::kebab()` method (alexandre-daubois)
 * feature #58403 [Mailer][Webhook] Mailtrap webhook support (kbond)
 * feature #58351 [Mailer] deprecate the TransportFactoryTestCase (xabbuh)
 * feature #58401 [Mailer][Webhook] Fix SendGrid Webhook parsing (kbond)
 * feature #58366 [HttpKernel] Improve accessibility (javiereguiluz)
 * feature #58352 [Translation] deprecate the ProviderFactoryTestCase (xabbuh)
 * feature #58248 [Webhook] Allow request parsers to return multiple `RemoteEvent`'s (kbond)
 * feature #58308 [Serializer] Deprecate `AdvancedNameConverterInterface` (mtarld)
 * feature #58335 [Notifier] deprecate the TransportFactoryTestCase (xabbuh)
 * feature #57270 [Messenger] Allow to skip message in `FailedMessagesRetryCommand` (Thibaut Chieux)
 * feature #58141 [AssetMapper] Search & filter assets in `debug:asset-mapper` command (smnandre)
 * feature #58386 [WebProfilerBundle] Update the contents of the Config panel (javiereguiluz)
 * feature #58161 [FrameworkBundle][HttpKernel] Add support for `SYMFONY_TRUSTED_PROXIES`, `SYMFONY_TRUSTED_HEADERS`, `SYMFONY_TRUST_X_SENDFILE_TYPE_HEADER` and `SYMFONY_TRUSTED_HOSTS` env vars (nicolas-grekas)
 * feature #53632 [Console] Add silent verbosity suppressing all output, including errors (wouterj)
 * feature #56823 [Serializer] Introduce named serializers (HypeMC)
 * feature #57611 [DependencyInjection][FrameworkBundle] Introducing container non-empty parameters (yceruto)
 * feature #58249 [FrameworkBundle] Add ability to use existing service as lock/semaphore resource (HypeMC)
 * feature #58166 [Security][SecurityBundle] Allow passing attributes to passport via `Security::login()` (alexandre-daubois)
 * feature #58205 [Translation] Added segment-attributes metadata for Xliff2 files to preserve the "state" attribute of translations (jbtronics)
 * feature #58228 [String] Add Spanish inflector with some rules (dennistobar)
 * feature #58252 [Mailer] add Mailtrap bridge (kbond)
 * feature #57805 [FrameworkBundle] Deprecate `session.sid_length` and `session.sid_bits_per_character` config options (alexandre-daubois)
 * feature #58199 [FrameworkBundle] Add `--resolve-env-vars` option to `lint:container` command (ostrolucky)
 * feature #58244 [HttpFoundation] Deprecate more options in `NativeSessionStorage` (alexandre-daubois)
 * feature #58246 [Serializer][Uid] Add the `Uuid::FORMAT_RFC_9562` and `UidNormalizer::NORMALIZATION_FORMAT_RFC9562` constants (alexandre-daubois)
 * feature #58258 [Process] Add Laravel Herd php detection path (mpociot)
 * feature #58182 make test case classes compatible with PHPUnit 10+ (xabbuh)
 * feature #58165 [FrameworkBundle] Remove default value for `gc_probability` config option (nicolas-grekas)
 * feature #58154 [HttpFoundation] Add `PRIVATE_SUBNETS` as a shortcut for private IP address ranges to `Request::setTrustedProxies()` (nicolas-grekas)
 * feature #58145 allow Twig 4 (xabbuh)
 * feature #58072 [Translation] [Loco] Ability to configure value of `status` query-variable (mathielen)
 * feature #57793 [Serializer] Support subclasses of `DateTime` and `DateTimeImmutable` (amcsi)
 * feature #58042 [Ldap] Add support for sasl_bind and whoami LDAP operations (manu0401)
 * feature #58074 [Console][Process] Add `$verbosity` argument to `mustRun` helper method (willrowe)
 * feature #58129 [VarExporter] Allow reinitializing lazy objects with a new initializer (nicolas-grekas)
 * feature #57683 [Notifier] Support for desktop notifications via `jolicode/JoliNotif` (ahmedghanem00)
 * feature #58035 [DependencyInjection] Add support for `key-type` in `XmlFileLoader` (alexandre-daubois)
 * feature #58047 [Webhook] Pass original request to `RequestParserInterface` (alexandre-daubois)
 * feature #58052 [ExpressionLanguage] Add support for `<<`, `>>`, and `~` bitwise operators (alexandre-daubois)
 * feature #58062 [Validator] Add $groups and $payload to Compound constructor (derrabus)
 * feature #58038 [HttpFoundation] Add optional `$v4Bytes` and `$v6Bytes` parameters to `IpUtils::anonymize()` (alexandre-daubois)
 * feature #58060 [Serializer] Add SnakeCaseToCamelCaseNameConverter (dunglas)
 * feature #49547 [Validator] Add `CompoundConstraintTestCase` to ease testing Compound Constraints (alexandre-daubois)
 * feature #57833 [VarDumper] Add support for virtual properties (alexandre-daubois)
 * feature #57960 [Form] Add support for the `calendar` option in `DateType` (alexandre-daubois)
 * feature #52951 [Messenger] Add previous to the exception output (ToshY)
 * feature #54179 [HttpClient] Add support for amphp/http-client v5 (nicolas-grekas)
 * feature #57577 [FrameworkBundle][HttpKernel] Let `RequestPayloadValueResolver` consider mapped argument type (unixslayer)
 * feature #58001 [Scheduler] Add capability to skip missed periodic tasks, only the last schedule will be called (eltharin)
 * feature #57827 [Serializer][Translation] Deprecate passing a non-empty CSV escape char (alexandre-daubois)
 * feature #58007 [Security] Deprecate empty user identifier (ajgarlag)
 * feature #57431 [Mailer] Add Sweego bridge (welcoMattic)
 * feature #58028 [TwigBridge] Render a `block` via the `#[Template]` attribute (smnandre)
 * feature #58004 [DependencyInjection] Add `ContainerBuilder::registerChild()` shortcut method (HypeMC)
 * feature #57881 [Webhook] decouple the Webhook component from the Serializer component (xabbuh)
 * feature #57804 [FrameworkBundle] enable detailed error messages by default when debug enabled (xabbuh)
 * feature #57777 [VarDumper] Add support for `FORCE_COLOR` environment variable (artshade)
 * feature #57915 [Messenger] Allow setting retry delay by RecoverableExceptionInterface (valtzu)
 * feature #57927 [FrameworkBundle] Deprecate making `cache.app` adapter taggable (alexandre-daubois)
 * feature #57935 [DoctrineBridge] Loosened CollectionToArrayTransformer::transform() to accept ReadableCollection (timdev)
 * feature #57940 [Uid] Add support for binary, base-32 and base-58 representations in `Uuid::isValid()` (alexandre-daubois)
 * feature #57908 [Validator] Add `Week` constraint (alexandre-daubois)
 * feature #57934 [DependencyInjection] Deprecate `!tagged` tag, use `!tagged_iterator` instead (alexandre-daubois)
 * feature #57903 [Mailer] Implement Postal mailer (jonasclaes)
 * feature #57938 [Validator] Add support for RFC4122 format in the `Ulid` constraint (alexandre-daubois)
 * feature #57879 [AssetMapper] Truncate public digests to 8 characters (smnandre)
 * feature #57909 [HttpFoundation] Add `$requests` parameter to `RequestStack` constructor (alexander-schranz)
 * feature #57839 [Form] Deprecate VersionAwareTest trait (derrabus)
 * feature #57836 [Cache] Add optional ClockInterface to ArrayAdapter (jasiolpn)
 * feature #54593 [PhpUnitBridge] Add `ExpectUserDeprecationMessageTrait` (derrabus)
 * feature #57525 [SecurityBundle] Improve profiler’s authenticators tab (MatTheCat)
 * feature #57618 [TypeInfo] Add `PhpDocAwareReflectionTypeResolver` (mtarld)
 * feature #57702 [Cache] Stop defaulting to `igbinary` in `DefaultMarshaller` (Martijn Croonen)
 * feature #57773 [Security] pass the current token to the `checkPostAuth()` method of user checkers (xabbuh)
 * feature #57797 [FrameworkBundle]  terminate with non-zero exit code when a secret could not be read (xabbuh)
 * feature #57716 [Validator] Add the `WordCount` constraint (alexandre-daubois)
 * feature #57694 [SecurityBundle] Update web-token/jwt-library version and adjust checker parameters (Spomky)
 * feature #57692 [SecurityBundle] Link to the profile the token was (de)authenticated (MatTheCat)
 * feature #57685 [ExpressionLanguage] Allow passing any iterable as `$providers` list (HypeMC)
 * feature #57670 [FrameworkBundle] Add `exit` option to `secrets:decrypt-to-local` command (dciprian-petrisor)
 * feature #57671 [Messenger] Let WrappedExceptionsInterface extend the native Throwable interface (xabbuh)
 * feature #57658 [Notifier] Remove the Gitter bridge (fabpot)
 * feature #57627 [Notifier] Add Sipgate bridge (Lukas Kaltenbach, sakul95)
 * feature #57243 [String] Add `TruncateMode` mode to `truncate` methods (Korbeil)
 * feature #57456 [Mailer] Add mailomat bridge (scuben)
 * feature #57399 [HtmlSanitizer] Add support for configuring the default action (Seldaek)
 * feature #57595 [Yaml] Deprecate duplicate mapping keys containing null (xabbuh)
 * feature #57507 [Messenger] Introduce `#[AsMessage]` attribute for message routing (pounard)
 * feature #57518 Unify how --format is handled by commands (fabpot)
 * feature #57379 [DependencyInjection] Add `#[WhenNot]` attribute (alexandre-daubois)
 * feature #54978 [ExpressionLanguage] Add comment support to expression language (valtzu)
 * feature #57438 [Validator] Add the `format` option to the `Ulid` constraint to allow accepting different ULID formats (alexandre-daubois)
 * feature #57426 [Messenger] Add `--format` option to the `messenger:stats` command (xvilo)
 * feature #57369 [Security] Display authenticators in the profiler even if they are all skipped (MatTheCat)
 * feature #57425 [SecurityBundle] Improve profiler’s data (MatTheCat)
 * feature #57436 [Validator] Add `errorPath` to Unique constraint (norkunas)
 * feature #57408 [FrameworkBundle] Simpler Kernel setup with `MicroKernelTrait` (yceruto)
 * feature #57424 [Mailer] [Infobip] Add trackClicks, trackOpens and trackingUrl as supp… (ndousson)
 * feature #57380 [Validator] fix IBAN validator fails if IBAN contains non-breaking space (antten)
 * feature #53749 [Validator] Add `Yaml` constraint for validating YAML content (symfonyaml)
 * feature #57313 [Uid] Make `AbstractUid` implement `Ds\Hashable` if available (jahudka)
 * feature #52679 [Process] `ExecutableFinder::addSuffix()` has no effect (TravisCarden)
 * feature #54879 BicValidator add strict mode to validate bics in strict mode (maxbeckers)
 * feature #54679 [TypeInfo] Proxies methods to non-nullable and fail gracefully (mtarld)
 * feature #54737 [Notifier] [Slack] Add button block element and `emoji`/`verbatim` options to section block (cvergne)
 * feature #54757 [ExpressionLanguage] Support non-existent names when followed by null coalescing (adamkiss)
 * feature #54747 [Notifier] Add Primotexto bridge (Samael tomas)
 * feature #54975 [Mime] Support custom encoders in mime parts (KDederichs)
 * feature #54894 [PropertyInfo] Adds static cache to `PhpStanExtractor` (mvhirsch)
 * feature #57101 [Translation] Add `lint:translations` command (Kocal)
 * feature #56985 [FrameworkBundle] Derivate `kernel.secret` from the decryption secret when its env var is not defined (nicolas-grekas)
 * feature #57073 [AssetMapper][FrameworkBundle] Do not require `http_client` service (ruudk)
 * feature #54678 [FrameworkBundle] Add support for setting `headers` with `TemplateController` (HypeMC)
 * feature #54756 [Notifier] [Bluesky] Allow to attach image (jdecool)
 * feature #54854 [Stopwatch] Add `ROOT` constant to make it easier to reference (hacfi)
 * feature #54855 [Stopwatch] Add `getLastPeriod` method to `StopwatchEvent` (hacfi)
 * feature #56838 [Security] Deprecate argument $secret of RememberMeToken and RememberMeAuthenticator (nicolas-grekas)
 * feature #54881 [Validator] Make `PasswordStrengthValidator::estimateStrength()` public (yalit)

